/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.operations.oracle;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.schemaEditor.generation.DdlBuildingContext;
import com.intellij.database.schemaEditor.generation.DdlGraph;
import com.intellij.database.schemaEditor.generation.DdlOperations;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.operations.DasDdlOperations;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.UserDataHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OracleRecompilePackageOperation
extends DdlOperations.DdlOperationGenerator<DeObject> {
    public static final DdlGraph.DdlOperation RECOMPILE_PACKAGE = new DdlGraph.DdlOperation("recompile-package", DasDdlOperations.RECOMPILE);
    public static final Condition<DeObject> SUPPORT_CONDITION = new Condition<DeObject>(){

        public boolean value(DeObject object) {
            return OracleRecompilePackageOperation.isSupported(object);
        }
    };

    public OracleRecompilePackageOperation() {
        super(RECOMPILE_PACKAGE);
    }

    @Override
    @NotNull
    public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeObject object, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/operations/oracle/OracleRecompilePackageOperation", "generate"));
        }
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/operations/oracle/OracleRecompilePackageOperation", "generate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/schemaEditor/operations/oracle/OracleRecompilePackageOperation", "generate"));
        }
        assert (OracleRecompilePackageOperation.isSupported(object));
        String kind = object.getKind() == ObjectKind.PACKAGE ? "SPECIFICATION" : "BODY";
        builder.keywords("ALTER", "PACKAGE").space().qualifiedRef(object).space().keywords("COMPILE", kind, "REUSE", "SETTINGS");
        DdlBuilder ddlBuilder = builder.newStatement();
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/oracle/OracleRecompilePackageOperation", "generate"));
        }
        return ddlBuilder;
    }

    public static boolean isSupported(@NotNull DasObject object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/operations/oracle/OracleRecompilePackageOperation", "isSupported"));
        }
        return object.getKind() == ObjectKind.PACKAGE || object.getKind() == ObjectKind.BODY;
    }
}

