/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.operations.sqlite;

import com.intellij.database.schemaEditor.generation.DdlBuildingContext;
import com.intellij.database.schemaEditor.generation.DdlGenerator;
import com.intellij.database.schemaEditor.generation.DdlGraph;
import com.intellij.database.schemaEditor.generation.DdlGraphBuilder;
import com.intellij.database.schemaEditor.generation.DdlOperationKey;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeIndex;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.schemaEditor.operations.DasDdlOperations;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqliteReplaceTableOperation
extends DasDdlOperations.CreateTableOperation {
    public static final DdlGraph.DdlOperation SQLITE_REPLACE_TABLE = new DdlGraph.DdlOperation("sqlite-replace-table", DasDdlOperations.CREATE_TABLE);
    private static final Key<DeTable> TMP_VIEW = Key.create((String)"SqliteReplaceTableOperation.TMP_NAME");

    public SqliteReplaceTableOperation() {
        super(SQLITE_REPLACE_TABLE);
    }

    @Override
    @NotNull
    public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeTable table, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/operations/sqlite/SqliteReplaceTableOperation", "generate"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/schemaEditor/operations/sqlite/SqliteReplaceTableOperation", "generate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/schemaEditor/operations/sqlite/SqliteReplaceTableOperation", "generate"));
        }
        DeTable from = (DeTable)DasDdlOperations.getAlterFrom(table, data);
        assert (from != table);
        for (DeIndex index : from.indices) {
            builder.getDialect().sqlDropIndex(builder, from, index, index.getName(), true).newStatement();
        }
        super.generate(builder, table, data, context);
        DeTable tmpView = (DeTable)TMP_VIEW.get(data);
        String tmpName = ((DeTable)ObjectUtils.chooseNotNull((Object)tmpView, (Object)table)).name;
        builder.keywords("INSERT", "INTO").space().identifier(table, tmpName).symbol("(");
        boolean first = true;
        for (DeColumn column : table.columns) {
            if (column.editedObject == null) continue;
            if (!first) {
                builder.symbol(",").space();
            }
            first = false;
            builder.identifier(column, column.name);
        }
        builder.symbol(")").space().keyword("SELECT").space();
        first = true;
        for (DeColumn column : table.columns) {
            if (column.editedObject == null) continue;
            if (!first) {
                builder.symbol(",").space();
            }
            first = false;
            builder.identifier(column.editedObject, column.editedObject.getName());
        }
        builder.space().keyword("FROM").space().identifier(from, from.name).newStatement();
        builder.getDialect().sqlDropTable(builder, from, true, false, from.model).newStatement();
        if (tmpView != null) {
            builder.getDialect().sqlRenameTable(builder, tmpView, table.name).newStatement();
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/sqlite/SqliteReplaceTableOperation", "generate"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    protected DeTable getView(@NotNull DeTable table, @Nullable UserDataHolder data) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/schemaEditor/operations/sqlite/SqliteReplaceTableOperation", "getView"));
        }
        DeObject from = DasDdlOperations.getAlterFrom(table, data);
        if (from == table || !Comparing.equal((String)from.name, (String)table.name)) {
            DeTable deTable = super.getView(table, data);
            if (deTable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/sqlite/SqliteReplaceTableOperation", "getView"));
            }
            return deTable;
        }
        DeTable tmp = (DeTable)TMP_VIEW.get(data);
        if (tmp != null) {
            DeTable deTable = tmp;
            if (deTable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/sqlite/SqliteReplaceTableOperation", "getView"));
            }
            return deTable;
        }
        tmp = DeObject.copy(table, true, DeObject.DeCopier.deepSubTree(table));
        Application application = ApplicationManager.getApplication();
        String uuid = application == null || application.isUnitTestMode() ? "_tmp" : UUID.randomUUID().toString().substring(0, 4);
        tmp.name = tmp.name + uuid;
        TMP_VIEW.set(data, (Object)tmp);
        DeTable deTable = tmp;
        if (deTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/sqlite/SqliteReplaceTableOperation", "getView"));
        }
        return deTable;
    }

    @Override
    @NotNull
    public DdlGenerator addToBuilder(@NotNull DdlGenerator generator, @NotNull DdlGraphBuilder builder, @NotNull DeTable das, @Nullable UserDataHolder data) {
        if (generator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "com/intellij/database/schemaEditor/operations/sqlite/SqliteReplaceTableOperation", "addToBuilder"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/operations/sqlite/SqliteReplaceTableOperation", "addToBuilder"));
        }
        if (das == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "das", "com/intellij/database/schemaEditor/operations/sqlite/SqliteReplaceTableOperation", "addToBuilder"));
        }
        generator.addOperation(builder, DdlGraph.DdlOperation.BEGIN_TRANSACTION, DeTable.STUB, null);
        generator.addOperation(builder, DdlGraph.DdlOperation.COMMIT, DeTable.STUB, null);
        DdlGenerator ddlGenerator = super.addToBuilder(generator, builder, das, data);
        if (ddlGenerator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/sqlite/SqliteReplaceTableOperation", "addToBuilder"));
        }
        return ddlGenerator;
    }

    @Override
    @NotNull
    public JBIterable<DdlOperationKey> getDependencies(@NotNull DeTable object, @Nullable UserDataHolder data) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/operations/sqlite/SqliteReplaceTableOperation", "getDependencies"));
        }
        JBIterable jBIterable = super.getDependencies(object, data).append((Object)new DdlOperationKey(DeTable.STUB, DdlGraph.DdlOperation.BEGIN_TRANSACTION));
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/sqlite/SqliteReplaceTableOperation", "getDependencies"));
        }
        return jBIterable;
    }

    @Override
    @NotNull
    public JBIterable<DdlOperationKey> getDependants(@NotNull DeTable object, @Nullable UserDataHolder data) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/operations/sqlite/SqliteReplaceTableOperation", "getDependants"));
        }
        JBIterable jBIterable = super.getDependants(object, data).append((Object)new DdlOperationKey(DeTable.STUB, DdlGraph.DdlOperation.COMMIT));
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/sqlite/SqliteReplaceTableOperation", "getDependants"));
        }
        return jBIterable;
    }

    @Override
    @NotNull
    public JBIterable<DdlOperationKey> getImplemented(@NotNull DeTable object, @Nullable UserDataHolder data) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/operations/sqlite/SqliteReplaceTableOperation", "getImplemented"));
        }
        JBIterable tree = ((JBTreeTraverser)object.model.traverser().withRoot((Object)object)).filter(DeObject.class);
        JBIterable jBIterable = super.getImplemented(object, data).append(DasDdlOperations.getObjectsCreateKeys((Iterable<? extends DeObject>)tree)).append(DasDdlOperations.getObjectsDropKeys((Iterable<? extends DeObject>)tree));
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/sqlite/SqliteReplaceTableOperation", "getImplemented"));
        }
        return jBIterable;
    }
}

