/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.settings;

import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.settings.UserParametersTable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.FileContentUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class UserParametersComponent
implements ConfigurableUi<DatabaseSettings>,
Disposable {
    private JPanel myPanel;
    private JPanel myParamPatternPlaceholder;
    private JCheckBox myUsePatternsInLiterals;
    private JCheckBox myUsePatternsInSql;
    private final UserParametersTable myPattenList;

    public UserParametersComponent() {
        this.$$$setupUI$$$();
        this.myPattenList = new UserParametersTable(this);
        this.myParamPatternPlaceholder.add((Component)this.myPattenList.getComponent(), "Center");
    }

    public void reset(@NotNull DatabaseSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/database/settings/UserParametersComponent", "reset"));
        }
        this.myPattenList.reset(settings);
        this.myUsePatternsInLiterals.setSelected(settings.getUserPatterns().inLiterals);
        this.myUsePatternsInSql.setSelected(settings.getUserPatterns().inScripts);
    }

    public boolean isModified(@NotNull DatabaseSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/database/settings/UserParametersComponent", "isModified"));
        }
        if (this.myPattenList.isModified(settings)) {
            return true;
        }
        if (!Comparing.equal((Object)settings.getUserPatterns().inLiterals, (Object)this.myUsePatternsInLiterals.isSelected())) {
            return true;
        }
        return !Comparing.equal((Object)settings.getUserPatterns().inScripts, (Object)this.myUsePatternsInSql.isSelected());
    }

    public void apply(@NotNull DatabaseSettings settings) throws ConfigurationException {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/database/settings/UserParametersComponent", "apply"));
        }
        settings.getUserPatterns().inLiterals = this.myUsePatternsInLiterals.isSelected();
        settings.getUserPatterns().inScripts = this.myUsePatternsInSql.isSelected();
        this.myPattenList.apply(settings);
        DatabaseSettings.fireSettingsChanged();
        FileContentUtil.reparseOpenedFiles();
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/settings/UserParametersComponent", "getComponent"));
        }
        return jPanel;
    }

    public void dispose() {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myParamPatternPlaceholder = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBCheckBox jBCheckBox = new JBCheckBox();
        this.myUsePatternsInLiterals = jBCheckBox;
        jBCheckBox.setText("Enable in string literals with SQL injection");
        jPanel2.add((Component)jBCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBCheckBox jBCheckBox2 = new JBCheckBox();
        this.myUsePatternsInSql = jBCheckBox2;
        jBCheckBox2.setText("Enable in console and SQL files");
        jPanel2.add((Component)jBCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText("Parameter Patterns");
        jPanel2.add((Component)titledSeparator, new GridConstraints(2, 0, 1, 1, 0, 3, 6, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

