/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.vendors.mssql.ssrp;

import com.intellij.database.vendors.mssql.ssrp.SsrpConstants;
import com.intellij.database.vendors.mssql.ssrp.SsrpDecoder;
import com.intellij.database.vendors.mssql.ssrp.SsrpEncoder;
import com.intellij.database.vendors.mssql.ssrp.SsrpInfo;
import com.intellij.openapi.util.Ref;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SsrpNet {
    public static Set<Response> queryNetworkInstances(int port, int timeout) throws SsrpConstants.SsrpException {
        DatagramSocket sock = null;
        final HashSet result = ContainerUtil.newHashSet();
        Consumer<Response> consumer = new Consumer<Response>(){

            public void consume(Response response) {
                result.add(response);
            }
        };
        try {
            sock = new DatagramSocket();
            sock.setBroadcast(true);
            byte[] req = SsrpEncoder.createClientBroadcastReq();
            sock.setSoTimeout(timeout);
            sock.send(new DatagramPacket(req, req.length, InetAddress.getByName("255.255.255.255"), port));
            DatagramPacket packet = SsrpNet.allocateLargePacket();
            while (SsrpNet.appendResponseOrTimeout(Collections.emptyMap(), sock, packet, consumer) != Boolean.FALSE) {
            }
            HashSet hashSet = result;
            return hashSet;
        }
        catch (UnknownHostException e) {
            throw new SsrpConstants.SsrpException(e);
        }
        catch (SocketException e) {
            throw new SsrpConstants.SsrpException(e);
        }
        catch (IOException e) {
            throw new SsrpConstants.SsrpException(e);
        }
        finally {
            if (sock != null) {
                sock.close();
            }
        }
    }

    @NotNull
    public static Set<Response> queryNetworkInstances(@NotNull Set<String> hosts, int port, int timeout) throws SsrpConstants.SsrpException {
        Object object;
        if (hosts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hosts", "com/intellij/database/vendors/mssql/ssrp/SsrpNet", "queryNetworkInstances"));
        }
        DatagramSocket sock = null;
        final HashSet result = ContainerUtil.newHashSet();
        final HashSet added = ContainerUtil.newHashSet();
        Consumer<Response> consumer = new Consumer<Response>(){

            public void consume(Response response) {
                result.add(response);
                added.add(response.host);
            }
        };
        try {
            Boolean res;
            sock = new DatagramSocket();
            byte[] req = SsrpEncoder.createClientUnicastReq();
            sock.setSoTimeout(timeout);
            HashMap addr2host = ContainerUtil.newHashMap();
            HashMap host2addr = ContainerUtil.newHashMap();
            int count = 0;
            for (String host : hosts) {
                try {
                    InetAddress address = InetAddress.getByName(host);
                    addr2host.put(address, host);
                    host2addr.put(host, address);
                    sock.send(new DatagramPacket(req, req.length, address, port));
                    ++count;
                }
                catch (UnknownHostException e) {
                    consumer.consume((Object)SsrpNet.createUnknownHost(host));
                }
            }
            DatagramPacket packet = SsrpNet.allocateLargePacket();
            int i = 0;
            while (i < count && (res = SsrpNet.appendResponseOrTimeout(addr2host, sock, packet, consumer)) != Boolean.FALSE) {
                if (res == null) continue;
                ++i;
            }
            for (String host : hosts) {
                if (added.contains(host)) continue;
                consumer.consume((Object)SsrpNet.createNoResponse(host, (InetAddress)host2addr.get(host)));
            }
            HashSet hashSet = result;
            object = hashSet;
        }
        catch (SocketException e) {
            throw new SsrpConstants.SsrpException(e);
        }
        catch (IOException e) {
            throw new SsrpConstants.SsrpException(e);
        }
        finally {
            if (sock != null) {
                sock.close();
            }
        }
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/vendors/mssql/ssrp/SsrpNet", "queryNetworkInstances"));
        }
        return object;
    }

    public static Response queryInstances(@NotNull String host, int port, int timeout) throws SsrpConstants.SsrpException {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/database/vendors/mssql/ssrp/SsrpNet", "queryInstances"));
        }
        DatagramSocket sock = null;
        final Ref result = Ref.create();
        Consumer<Response> consumer = new Consumer<Response>(){

            public void consume(Response response) {
                result.set((Object)response);
            }
        };
        try {
            sock = new DatagramSocket();
            byte[] req = SsrpEncoder.createClientUnicastReq();
            sock.setSoTimeout(timeout);
            InetAddress address = InetAddress.getByName(host);
            sock.send(new DatagramPacket(req, req.length, address, port));
            DatagramPacket packet = SsrpNet.allocateLargePacket();
            while (SsrpNet.appendResponseOrTimeout(Collections.singletonMap(address, host), sock, packet, consumer) == null) {
            }
            if (result.get() != null) {
                Response response = (Response)result.get();
                return response;
            }
            Response response = SsrpNet.createNoResponse(host, address);
            return response;
        }
        catch (UnknownHostException e) {
            Response response = SsrpNet.createUnknownHost(host);
            return response;
        }
        catch (SocketException e) {
            throw new SsrpConstants.SsrpException(e);
        }
        catch (IOException e) {
            throw new SsrpConstants.SsrpException(e);
        }
        finally {
            if (sock != null) {
                sock.close();
            }
        }
    }

    @NotNull
    private static Response createNoResponse(@NotNull String host, InetAddress address) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/database/vendors/mssql/ssrp/SsrpNet", "createNoResponse"));
        }
        Response response = new Response(SsrpInfo.concat("ServerName", host, "SsrpError", "NoResponse"), host, address);
        if (response == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/vendors/mssql/ssrp/SsrpNet", "createNoResponse"));
        }
        return response;
    }

    @NotNull
    private static Response createUnknownHost(@NotNull String host) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/database/vendors/mssql/ssrp/SsrpNet", "createUnknownHost"));
        }
        Response response = new Response(SsrpInfo.concat("ServerName", host, "SsrpError", "UnknownHost"), host, null);
        if (response == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/vendors/mssql/ssrp/SsrpNet", "createUnknownHost"));
        }
        return response;
    }

    @NotNull
    private static DatagramPacket allocateLargePacket() {
        byte[] responseBuffer = new byte[65600];
        DatagramPacket datagramPacket = new DatagramPacket(responseBuffer, responseBuffer.length);
        if (datagramPacket == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/vendors/mssql/ssrp/SsrpNet", "allocateLargePacket"));
        }
        return datagramPacket;
    }

    private static Boolean appendResponseOrTimeout(@NotNull Map<InetAddress, String> addr2host, @NotNull DatagramSocket sock, @NotNull DatagramPacket buffer, @NotNull Consumer<Response> consumer) throws SsrpConstants.SsrpException {
        if (addr2host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "addr2host", "com/intellij/database/vendors/mssql/ssrp/SsrpNet", "appendResponseOrTimeout"));
        }
        if (sock == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sock", "com/intellij/database/vendors/mssql/ssrp/SsrpNet", "appendResponseOrTimeout"));
        }
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/database/vendors/mssql/ssrp/SsrpNet", "appendResponseOrTimeout"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/vendors/mssql/ssrp/SsrpNet", "appendResponseOrTimeout"));
        }
        try {
            sock.receive(buffer);
            String resp = SsrpDecoder.decodeResponseString(ByteBuffer.wrap(buffer.getData()));
            if (resp == null) {
                return null;
            }
            consumer.consume((Object)new Response(resp, addr2host.get(buffer.getAddress()), buffer.getAddress()));
        }
        catch (SocketTimeoutException e) {
            return false;
        }
        catch (IOException e) {
            throw new SsrpConstants.SsrpException(e);
        }
        return true;
    }

    public static class Response {
        public String response;
        public String host;
        public InetAddress addr;

        public Response(String response, String host, InetAddress addr) {
            this.response = response;
            this.host = host;
            this.addr = addr;
        }
    }
}

