/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.DatabaseNotifications;
import com.intellij.database.dataSource.DataSource;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.ScriptModelUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.database.view.DatabaseView;
import com.intellij.lang.Language;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.util.Consumer;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import java.sql.Connection;
import java.sql.Statement;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public class DatabaseRefactoringHandler {
    private String myStatement = "";
    private DbDataSource myDataSource;
    private final DasNamespace myDefaultNs;
    private LoaderContext myContext;

    public DatabaseRefactoringHandler(DbDataSource dataSource, @Nullable DasNamespace defaultNs) {
        this.myDataSource = dataSource;
        this.myDefaultNs = defaultNs;
        Object delegate = dataSource.getDelegate();
        this.myContext = new LoaderContext(delegate instanceof DataSource ? (DataSource)delegate : null);
    }

    public DatabaseRefactoringHandler setStatement(String statement) {
        this.myStatement = statement;
        return this;
    }

    @NotNull
    public DbDataSource getDataSource() {
        DbDataSource dbDataSource = this.myDataSource;
        if (dbDataSource == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseRefactoringHandler", "getDataSource"));
        }
        return dbDataSource;
    }

    @NotNull
    public String getStatement() {
        String string = this.myStatement;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseRefactoringHandler", "getStatement"));
        }
        return string;
    }

    public LoaderContext getContext() {
        return this.myContext;
    }

    public List<String> generateQueries() {
        String s;
        final SqlPsiFacade facade = SqlPsiFacade.getInstance((Project)this.myDataSource.getProject());
        final Ref model = Ref.create();
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                PsiFile psi = PsiFileFactory.getInstance((Project)DatabaseRefactoringHandler.this.myDataSource.getProject()).createFileFromText("a.sql", (Language)DbSqlUtil.getSqlDialect((DbElement)DatabaseRefactoringHandler.this.myDataSource), (CharSequence)DatabaseRefactoringHandler.this.myStatement);
                model.set((Object)facade.createScriptModel(psi));
            }
        });
        JBIterable queries = ((ScriptModel)model.get()).statements().asCursor().transform(ScriptModelUtil.TO_TEXT);
        DatabaseDialectEx dialect = (DatabaseDialectEx)DbImplUtil.getSqlDialect(this.myDataSource.getProject(), (DatabaseSystem)this.myDataSource).getDatabaseDialect();
        if (this.myDefaultNs != null && (s = dialect.sqlSetCurrentSchema(ObjectPath.of((DasObject)this.myDefaultNs))) != null) {
            queries = JBIterable.of((Object[])new String[]{s}).append((Iterable)queries);
        }
        return queries.toList();
    }

    @NotNull
    public Promise<Void> runStatements() {
        final Project project = this.myDataSource.getProject();
        if (!(this.myContext.getDataSource() instanceof LocalDataSource)) {
            Promise promise = Promise.REJECTED;
            if (promise == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseRefactoringHandler", "runStatements"));
            }
            return promise;
        }
        final Set selectionBeforeUpdate = DatabaseView.getDatabaseView(project).getTreeBuilder().getSelectedElements();
        final LocalDataSource dataSourceDelegate = (LocalDataSource)this.myContext.getDataSource();
        final AsyncPromise callback = new AsyncPromise();
        final ErrorHandler errorHandler = new ErrorHandler();
        callback.rejected((Consumer)new Consumer<Throwable>(){

            public void consume(Throwable throwable) {
                if (!errorHandler.getSummary().isEmpty()) {
                    DataSourceUiUtil.showNotification(project, "", errorHandler.getSummary(), true);
                }
            }
        });
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Database update"){

            /*
             * Exception decompiling
             */
            public void run(@NotNull ProgressIndicator indicator) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        });
        AsyncPromise asyncPromise = callback;
        if (asyncPromise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseRefactoringHandler", "runStatements"));
        }
        return asyncPromise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int executeQueries(@NotNull Project project, @NotNull Connection connection, @NotNull List<String> queries, @NotNull ErrorHandler errorHandler, @NotNull ProgressIndicator indicator) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/view/DatabaseRefactoringHandler", "executeQueries"));
        }
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/view/DatabaseRefactoringHandler", "executeQueries"));
        }
        if (queries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queries", "com/intellij/database/view/DatabaseRefactoringHandler", "executeQueries"));
        }
        if (errorHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorHandler", "com/intellij/database/view/DatabaseRefactoringHandler", "executeQueries"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/view/DatabaseRefactoringHandler", "executeQueries"));
        }
        int totalCount = queries.size();
        int count = 0;
        for (String query : queries) {
            if (StringUtil.isEmptyOrSpaces((String)query)) {
                ++count;
                continue;
            }
            indicator.checkCanceled();
            Statement statement = null;
            try {
                statement = connection.createStatement();
                statement.executeUpdate(query);
                DatabaseNotifications.REFACTORING_GROUP.createNotification(query, MessageType.INFO).notify(project);
                indicator.setFraction((double)(++count) / (double)totalCount);
            }
            catch (Exception e) {
                DatabaseNotifications.REFACTORING_GROUP.createNotification(query, MessageType.ERROR).notify(project);
                errorHandler.addError(null, (Throwable)e);
                int n = count;
                return n;
            }
            finally {
                JdbcUtil.closeStatementSafe((Statement)statement);
            }
        }
        return count;
    }

    static /* synthetic */ int access$200(Project x0, Connection x1, List x2, ErrorHandler x3, ProgressIndicator x4) {
        return DatabaseRefactoringHandler.executeQueries(x0, x1, x2, x3, x4);
    }
}

