/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasTable;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeForeignKey;
import com.intellij.database.schemaEditor.model.DeIndex;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.schemaEditor.model.DeTableKey;
import com.intellij.database.view.editors.DatabaseEditorBaseEx;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseEditorUtil;
import com.intellij.database.view.editors.DatabaseTableColumnEditor;
import com.intellij.database.view.editors.DatabaseTableEditor;
import com.intellij.database.view.models.ColumnEditorModel;
import com.intellij.database.view.models.EditorModelBase;
import com.intellij.database.view.models.TableEditorModel;
import com.intellij.database.view.models.builder.ForeignKeyModelBuilder;
import com.intellij.database.view.models.builder.IndexModelBuilder;
import com.intellij.database.view.models.builder.KeyModelBuilder;
import com.intellij.database.view.models.builder.TableModelBuilder;
import com.intellij.database.view.ui.AbstractTableDialogHelper;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import icons.DatabaseIcons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseTableColumnsEditor
extends DatabaseTableEditor.TabProvider {
    private static final DataKey<DatabaseTableEditor> TABLE_EDITOR = DataKey.create((String)"TABLE_EDITOR");
    private static final DataKey<DatabaseEditorCapabilities.TableEditorCaps> TABLE_CAPS = DataKey.create((String)"TABLE_CAPS");
    private static final DataKey<ListTableModel<DatabaseTableColumnEditor>> TABLE_COLUMNS = DataKey.create((String)"TABLE_COLUMNS");
    private JPanel myPanel;
    private DatabaseEditorUtil.DbListTableWithEditor myTable;
    private ListTableModel<DatabaseTableColumnEditor> myColumnModel;
    private final DatabaseTableEditor myTableEditor;
    private final DatabaseEditorCapabilities.TableEditorCaps myCaps;

    public DatabaseTableColumnsEditor(@NotNull DatabaseTableEditor tableEditor, @NotNull DatabaseEditorCapabilities.TableEditorCaps caps) {
        if (tableEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tableEditor", "com/intellij/database/view/editors/DatabaseTableColumnsEditor", "<init>"));
        }
        if (caps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caps", "com/intellij/database/view/editors/DatabaseTableColumnsEditor", "<init>"));
        }
        this.myTableEditor = tableEditor;
        this.myCaps = caps;
        this.myColumnModel = DatabaseEditorUtil.createTableModel(this.getTableModel(), new DatabaseEditorUtil.EditorModelHelper<DatabaseTableColumnEditor>(){

            @Override
            @Nullable
            public DatabaseTableColumnEditor createRow() {
                if (!DatabaseTableColumnsEditor.this.myCaps.getColumns().canAdd()) {
                    return null;
                }
                int idx = DatabaseTableColumnsEditor.this.getTableModel().getColumnsCount();
                DeColumn column = DatabaseTableColumnsEditor.this.getTableModel().createColumn("column_" + (idx + 1));
                DatabaseTableColumnsEditor.this.getTableModel().insertColumn(column, idx);
                return DatabaseTableColumnsEditor.this.createColumnEditor(column);
            }

            @Override
            public boolean removeRow(DatabaseTableColumnEditor item, int idx) {
                if (!DatabaseTableColumnsEditor.this.myCaps.getColumns().canRemove()) {
                    return false;
                }
                DatabaseTableColumnsEditor.this.getTableModel().removeColumn(DatabaseTableColumnsEditor.this.getTableModel().getColumns().get(idx));
                Disposer.dispose((Disposable)item);
                return true;
            }

            @Override
            public boolean exchangeRows(DatabaseTableColumnEditor item0, int idx0, DatabaseTableColumnEditor item1, int idx1) {
                if (!DatabaseTableColumnsEditor.this.myCaps.getColumns().canReorder()) {
                    return false;
                }
                if (idx0 > idx1) {
                    int tmp = idx0;
                    idx0 = idx1;
                    idx1 = tmp;
                }
                List<DeColumn> columns = DatabaseTableColumnsEditor.this.getTableModel().getColumns();
                DeColumn col1 = columns.get(idx0);
                DeColumn col2 = columns.get(idx1);
                DatabaseTableColumnsEditor.this.getTableModel().removeColumn(col2);
                DatabaseTableColumnsEditor.this.getTableModel().removeColumn(col1);
                DatabaseTableColumnsEditor.this.getTableModel().insertColumn(col2, idx0);
                DatabaseTableColumnsEditor.this.getTableModel().insertColumn(col1, idx1);
                return true;
            }
        }, true);
        this.myTable = DatabaseEditorUtil.createTableWithEditor(this.myColumnModel, this.myTableEditor, 4, JBUI.scale((int)500), (ActionGroup)new DefaultActionGroup(new AnAction[]{NewAltKeyAction.INSTANCE, NewIndexAction.INSTANCE, NewForeignKeyAction.INSTANCE}));
        this.myTable.getTable().getEmptyText().setText("No columns");
        DataManager.registerDataProvider((JComponent)this.myTable.getTable(), (DataProvider)new DataProvider(){

            @Nullable
            public Object getData(@NonNls String dataId) {
                if (TABLE_EDITOR.is(dataId)) {
                    return DatabaseTableColumnsEditor.this.myTableEditor;
                }
                if (TABLE_CAPS.is(dataId)) {
                    return DatabaseTableColumnsEditor.this.myCaps;
                }
                if (TABLE_COLUMNS.is(dataId)) {
                    return DatabaseTableColumnsEditor.this.myColumnModel;
                }
                return null;
            }
        });
        DatabaseEditorUtil.FlagUpdater columnsAddable = new DatabaseEditorUtil.FlagUpdater(this.myCaps.getColumns().canAdd());
        DatabaseEditorUtil.FlagUpdater columnsRemovable = new DatabaseEditorUtil.FlagUpdater(this.myCaps.getColumns().canRemove());
        DatabaseEditorUtil.FlagUpdater columnsReorderable = new DatabaseEditorUtil.FlagUpdater(this.myCaps.getColumns().canReorder());
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTable)this.myTable.getTable()).setAddActionUpdater((AnActionButtonUpdater)columnsAddable).setRemoveActionUpdater((AnActionButtonUpdater)columnsRemovable).setMoveUpActionUpdater((AnActionButtonUpdater)columnsReorderable).setMoveDownActionUpdater((AnActionButtonUpdater)columnsReorderable);
        this.myPanel = decorator.createPanel();
        DatabaseEditorUtil.setTableDecoratorMinSize(this.myPanel, (JTable)this.myTable.getTable());
        this.myPanel.setBorder(BORDER);
    }

    @Nullable
    public DatabaseTableColumnEditor startItemEditing(@NotNull DeColumn column) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/view/editors/DatabaseTableColumnsEditor", "startItemEditing"));
        }
        return DatabaseEditorUtil.startItemEditing(column, this.myTable, this.myColumnModel);
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableColumnsEditor", "getComponent"));
        }
        return jPanel;
    }

    @NotNull
    public TableEditorModel getTableModel() {
        TableEditorModel tableEditorModel = this.myTableEditor.getTableModel();
        if (tableEditorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableColumnsEditor", "getTableModel"));
        }
        return tableEditorModel;
    }

    @NotNull
    private DatabaseTableColumnEditor createColumnEditor(@NotNull DeColumn column) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/view/editors/DatabaseTableColumnsEditor", "createColumnEditor"));
        }
        DatabaseTableColumnEditor editor = new DatabaseTableColumnEditor(this.myTableEditor.getState(), this.getTableModel(), this.getTableModel().modelsCache.get(column, ColumnEditorModel.class), this.getTableColumnCaps(column));
        Disposer.register((Disposable)this.myTableEditor, (Disposable)editor);
        editor.getColumnModel().addListener(new EditorModelBase.Listener(){

            @Override
            public void changed() {
                DatabaseTableColumnsEditor.this.myTableEditor.updateUi();
            }
        }, this.myTableEditor);
        DatabaseTableColumnEditor databaseTableColumnEditor = editor;
        if (databaseTableColumnEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableColumnsEditor", "createColumnEditor"));
        }
        return databaseTableColumnEditor;
    }

    @NotNull
    private DatabaseEditorCapabilities.TableColumnEditorCaps getTableColumnCaps(@NotNull DeColumn column) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/view/editors/DatabaseTableColumnsEditor", "getTableColumnCaps"));
        }
        DasTable table = (DasTable)this.getTable().editedObject;
        DasColumn col = (DasColumn)column.editedObject;
        DatabaseEditorCapabilities.TableColumnEditorCaps tableColumnEditorCaps = DatabaseTableColumnEditor.getTableColumnCaps(this.myCaps, table, col);
        if (tableColumnEditorCaps == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableColumnsEditor", "getTableColumnCaps"));
        }
        return tableColumnEditorCaps;
    }

    public void updateFromModel() {
        DatabaseEditorUtil.cleanupEditors(this.myColumnModel, this.getTableModel().getColumns(), new Function<DeColumn, DatabaseTableColumnEditor>(){

            public DatabaseTableColumnEditor fun(DeColumn column) {
                return DatabaseTableColumnsEditor.this.createColumnEditor(column);
            }
        });
        this.myTable.getTable().repaint();
    }

    @NotNull
    public DeTable getTable() {
        DeTable deTable = (DeTable)this.getTableModel().getObject();
        if (deTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableColumnsEditor", "getTable"));
        }
        return deTable;
    }

    @Override
    @NotNull
    public String getTabTitle() {
        int count = this.getTableModel().getColumnsCount();
        String string = "Columns" + (count == 0 ? "" : " (" + count + ")");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableColumnsEditor", "getTabTitle"));
        }
        return string;
    }

    @NotNull
    public ListTableModel<DatabaseTableColumnEditor> getColumnsListModel() {
        ListTableModel<DatabaseTableColumnEditor> listTableModel = this.myColumnModel;
        if (listTableModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableColumnsEditor", "getColumnsListModel"));
        }
        return listTableModel;
    }

    @Nullable
    public DatabaseEditorBaseEx getActiveEditor() {
        return DatabaseEditorUtil.getEditedItem(this.myTable, this.myColumnModel);
    }

    @NotNull
    public DatabaseEditorCapabilities.ListCapability getCaps() {
        DatabaseEditorCapabilities.ListCapability listCapability = this.myCaps.getColumns();
        if (listCapability == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableColumnsEditor", "getCaps"));
        }
        return listCapability;
    }

    private static abstract class NewColumnsObjectAction
    extends DumbAwareAction {
        public NewColumnsObjectAction(@Nullable String text, @Nullable String description, @Nullable Icon icon) {
            super(text, description, icon);
        }

        @NotNull
        private static List<DeColumn> getColumns(@NotNull DataContext context) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/editors/DatabaseTableColumnsEditor$NewColumnsObjectAction", "getColumns"));
            }
            DatabaseTableEditor editor = (DatabaseTableEditor)TABLE_EDITOR.getData(context);
            JTable table = (JTable)ObjectUtils.tryCast((Object)PlatformDataKeys.CONTEXT_COMPONENT.getData(context), JTable.class);
            ListTableModel columnsModel = (ListTableModel)TABLE_COLUMNS.getData(context);
            if (table == null || editor == null || columnsModel == null) {
                List<DeColumn> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableColumnsEditor$NewColumnsObjectAction", "getColumns"));
                }
                return list;
            }
            ArrayList columns = ContainerUtil.newArrayList();
            for (int i : table.getSelectedRows()) {
                if (i < 0 || i > columnsModel.getRowCount()) continue;
                DatabaseTableColumnEditor columnEditor = (DatabaseTableColumnEditor)columnsModel.getItem(i);
                columns.add(columnEditor.getColumn());
            }
            ArrayList arrayList = columns;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableColumnsEditor$NewColumnsObjectAction", "getColumns"));
            }
            return arrayList;
        }

        public void update(AnActionEvent e) {
            super.update(e);
            DatabaseTableEditor editor = (DatabaseTableEditor)TABLE_EDITOR.getData(e.getDataContext());
            DatabaseEditorCapabilities.TableEditorCaps caps = (DatabaseEditorCapabilities.TableEditorCaps)TABLE_CAPS.getData(e.getDataContext());
            List<DeColumn> columns = NewColumnsObjectAction.getColumns(e.getDataContext());
            boolean enabled = editor != null && caps != null && this.check(editor, caps, columns);
            e.getPresentation().setEnabled(enabled);
        }

        protected abstract boolean check(@NotNull DatabaseTableEditor var1, @NotNull DatabaseEditorCapabilities.TableEditorCaps var2, @NotNull List<DeColumn> var3);

        public void actionPerformed(AnActionEvent e) {
            final DatabaseTableEditor editor = (DatabaseTableEditor)TABLE_EDITOR.getData(e.getDataContext());
            DatabaseEditorCapabilities.TableEditorCaps caps = (DatabaseEditorCapabilities.TableEditorCaps)TABLE_CAPS.getData(e.getDataContext());
            if (editor == null || caps == null) {
                return;
            }
            List<DeColumn> columns = NewColumnsObjectAction.getColumns(e.getDataContext());
            if (!this.check(editor, caps, columns)) {
                return;
            }
            final DeObject exported = this.create(editor.getTableModel(), columns);
            if (exported == null) {
                return;
            }
            AbstractTableDialogHelper.runOnceValid(editor.getState(), new Runnable(){

                @Override
                public void run() {
                    editor.startItemEditing(exported);
                }
            });
        }

        public abstract DeObject create(@NotNull TableEditorModel var1, @NotNull List<DeColumn> var2);
    }

    private static class NewForeignKeyAction
    extends NewColumnsObjectAction {
        public static AnAction INSTANCE = new NewForeignKeyAction();

        public NewForeignKeyAction() {
            super("New &Foreign Key", null, DatabaseIcons.BlueKey);
        }

        @Override
        protected boolean check(@NotNull DatabaseTableEditor editor, @NotNull DatabaseEditorCapabilities.TableEditorCaps caps, @NotNull List<DeColumn> columns) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/view/editors/DatabaseTableColumnsEditor$NewForeignKeyAction", "check"));
            }
            if (caps == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caps", "com/intellij/database/view/editors/DatabaseTableColumnsEditor$NewForeignKeyAction", "check"));
            }
            if (columns == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/view/editors/DatabaseTableColumnsEditor$NewForeignKeyAction", "check"));
            }
            return caps.getForeignKeys().canAdd() && columns.size() > 0;
        }

        @Override
        public DeObject create(@NotNull TableEditorModel model, @NotNull List<DeColumn> columns) {
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/view/editors/DatabaseTableColumnsEditor$NewForeignKeyAction", "create"));
            }
            if (columns == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/view/editors/DatabaseTableColumnsEditor$NewForeignKeyAction", "create"));
            }
            Ref fks = Ref.create();
            ((TableModelBuilder)((TableModelBuilder.TableForeignKeyModelBuilder)((TableModelBuilder.TableForeignKeyModelBuilder)((ForeignKeyModelBuilder)((Object)TableModelBuilder.modify(model).withForeignKey(""))).addRefRefs(columns)).addAndGet((Ref<DeForeignKey>)fks)).leave()).commit();
            return (DeObject)fks.get();
        }
    }

    private static class NewIndexAction
    extends NewColumnsObjectAction {
        public static AnAction INSTANCE = new NewIndexAction();

        public NewIndexAction() {
            super("New &Index", null, DatabaseIcons.Index);
        }

        @Override
        protected boolean check(@NotNull DatabaseTableEditor editor, @NotNull DatabaseEditorCapabilities.TableEditorCaps caps, @NotNull List<DeColumn> columns) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/view/editors/DatabaseTableColumnsEditor$NewIndexAction", "check"));
            }
            if (caps == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caps", "com/intellij/database/view/editors/DatabaseTableColumnsEditor$NewIndexAction", "check"));
            }
            if (columns == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/view/editors/DatabaseTableColumnsEditor$NewIndexAction", "check"));
            }
            return caps.getIndices().canAdd() && columns.size() > 0;
        }

        @Override
        public DeObject create(@NotNull TableEditorModel model, @NotNull List<DeColumn> columns) {
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/view/editors/DatabaseTableColumnsEditor$NewIndexAction", "create"));
            }
            if (columns == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/view/editors/DatabaseTableColumnsEditor$NewIndexAction", "create"));
            }
            Ref index = Ref.create();
            ((TableModelBuilder)((TableModelBuilder.TableIndexModelBuilder)((TableModelBuilder.TableIndexModelBuilder)((IndexModelBuilder)((Object)TableModelBuilder.modify(model).withIndex(""))).addColumns(columns, DasIndex.Sorting.NONE)).addAndGet((Ref<DeIndex>)index)).leave()).commit();
            return (DeObject)index.get();
        }
    }

    private static class NewAltKeyAction
    extends NewColumnsObjectAction {
        public static AnAction INSTANCE = new NewAltKeyAction();

        public NewAltKeyAction() {
            super("New Table &Key", null, DatabaseIcons.GoldKeyAlt);
        }

        @Override
        protected boolean check(@NotNull DatabaseTableEditor editor, @NotNull DatabaseEditorCapabilities.TableEditorCaps caps, @NotNull List<DeColumn> columns) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/view/editors/DatabaseTableColumnsEditor$NewAltKeyAction", "check"));
            }
            if (caps == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caps", "com/intellij/database/view/editors/DatabaseTableColumnsEditor$NewAltKeyAction", "check"));
            }
            if (columns == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/view/editors/DatabaseTableColumnsEditor$NewAltKeyAction", "check"));
            }
            return caps.getAltKeys().canAdd() && columns.size() > 0;
        }

        @Override
        public DeObject create(@NotNull TableEditorModel model, @NotNull List<DeColumn> columns) {
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/view/editors/DatabaseTableColumnsEditor$NewAltKeyAction", "create"));
            }
            if (columns == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/view/editors/DatabaseTableColumnsEditor$NewAltKeyAction", "create"));
            }
            Ref key = Ref.create();
            ((TableModelBuilder)((TableModelBuilder.TableKeyModelBuilder)((TableModelBuilder.TableKeyModelBuilder)((KeyModelBuilder)((Object)TableModelBuilder.modify(model).withKey(""))).addColumns(columns, DasIndex.Sorting.NONE)).addAndGet((Ref<DeTableKey>)key)).leave()).commit();
            return (DeObject)key.get();
        }
    }
}

