/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeNamespace;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.util.DasUtil;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.editors.DatabaseObjectRefEditor;
import com.intellij.database.view.models.EditorModelUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.util.containers.JBIterable;
import icons.DatabaseIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseTableRefEditor {
    private final DeModel myModel;
    private final DasModel myTargetModel;
    private DatabaseObjectRefEditor<DasTable> myDelegate;
    private DeTable myStubCache;

    public DatabaseTableRefEditor(@NotNull DeModel model, @NotNull DatabaseEditorContext context) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/view/editors/DatabaseTableRefEditor", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/editors/DatabaseTableRefEditor", "<init>"));
        }
        this.myModel = model;
        this.myTargetModel = context.getModel();
        this.myDelegate = new DatabaseObjectRefEditor<DasTable>(context){

            @Override
            @Nullable
            protected Icon getIcon(@NotNull DasTable item) {
                if (item == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/database/view/editors/DatabaseTableRefEditor$1", "getIcon"));
                }
                return DatabaseIcons.Table;
            }
        };
        this.myDelegate.setItems((JBIterable<DasTable>)this.myTargetModel.traverser().filter(DasTable.class).filter(DasUtil.byKind((ObjectKind)ObjectKind.TABLE)));
    }

    @NotNull
    public EditorTextField getEditor() {
        EditorTextField editorTextField = this.myDelegate.getEditor();
        if (editorTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableRefEditor", "getEditor"));
        }
        return editorTextField;
    }

    @NotNull
    public String getName() {
        String string = this.myDelegate.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableRefEditor", "getName"));
        }
        return string;
    }

    @Nullable
    public DeTable getObject() {
        DasTable res = this.myDelegate.getObject();
        if (res == null) {
            return null;
        }
        return (DeTable)this.myModel.getExportHelper().exportDeep(this.myTargetModel, (Iterable<? extends DasObject>)JBIterable.of((Object[])new DasTable[]{res}), true).first();
    }

    public void setObject(@Nullable DeTable obj) {
        this.myDelegate.setObject(obj);
    }

    @NotNull
    public DeTable getObjectOrStub(@Nullable DeNamespace parent) {
        DeTable res = this.getObject();
        if (res == null) {
            String name = this.getName();
            if (this.myStubCache == null || !this.myStubCache.name.equals(name)) {
                this.myStubCache = DatabaseTableRefEditor.createStub(name, parent, this.myModel);
            }
            res = this.myStubCache;
        }
        DeTable deTable = res;
        if (deTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableRefEditor", "getObjectOrStub"));
        }
        return deTable;
    }

    @NotNull
    public static DeTable createStub(@NotNull String name, @Nullable DeNamespace parent, @NotNull DeModel model) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/view/editors/DatabaseTableRefEditor", "createStub"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/view/editors/DatabaseTableRefEditor", "createStub"));
        }
        DeTable deTable = EditorModelUtil.setStub(new DeTable(name, parent, model));
        if (deTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableRefEditor", "createStub"));
        }
        return deTable;
    }
}

