/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.models;

import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.schemaEditor.model.DeIndex;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.view.models.EditorModelBase;
import com.intellij.database.view.models.EditorModelsCache;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class BatchIndicesEditorModel
extends EditorModelBase {
    public static final Function<DeIndex, Boolean> PREV_UNIQUE_GENERATOR = new Function<DeIndex, Boolean>(){

        public Boolean fun(DeIndex index) {
            return ((DasIndex)ObjectUtils.assertNotNull((Object)((DasIndex)index.editedObject))).isUnique();
        }
    };
    public static final Function<DeIndex, Boolean> TRUE_UNIQUE_GENERATOR = new Function<DeIndex, Boolean>(){

        public Boolean fun(DeIndex index) {
            return true;
        }
    };
    public static final Function<DeIndex, Boolean> FALSE_UNIQUE_GENERATOR = new Function<DeIndex, Boolean>(){

        public Boolean fun(DeIndex index) {
            return false;
        }
    };
    public static final Consumer<List<DeIndex>> PREV_NAME_GENERATOR = new Consumer<List<DeIndex>>(){

        public void consume(List<DeIndex> indices) {
            for (DeIndex index : indices) {
                index.name = ((DasObject)ObjectUtils.assertNotNull((Object)index.editedObject)).getName();
            }
        }

        public String toString() {
            return "Using present names";
        }
    };
    public static final Consumer<List<DeIndex>> DEFAULT_NAME_GENERATOR = new PatternNameGenerator("{table}_{columns}_index");
    private final List<DeIndex> myIndices;
    private Consumer<List<DeIndex>> myNameGenerator;
    private Function<DeIndex, Boolean> myUniqueGenerator;

    @NotNull
    public Iterable<DeIndex> getIndices() {
        List<DeIndex> list = this.myIndices;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/models/BatchIndicesEditorModel", "getIndices"));
        }
        return list;
    }

    public BatchIndicesEditorModel(@NotNull List<DeIndex> indices, @NotNull DeModel model, @NotNull EditorModelsCache models) {
        if (indices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indices", "com/intellij/database/view/models/BatchIndicesEditorModel", "<init>"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/view/models/BatchIndicesEditorModel", "<init>"));
        }
        if (models == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "models", "com/intellij/database/view/models/BatchIndicesEditorModel", "<init>"));
        }
        super(model, models);
        this.myIndices = indices;
    }

    public void setNameGenerator(@NotNull Consumer<List<DeIndex>> generator) {
        if (generator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "com/intellij/database/view/models/BatchIndicesEditorModel", "setNameGenerator"));
        }
        if (Comparing.equal(generator, this.myNameGenerator)) {
            return;
        }
        this.myNameGenerator = generator;
        generator.consume(this.myIndices);
        this.modify();
    }

    @NotNull
    public Consumer<List<DeIndex>> getNameGenerator() {
        Consumer<List<DeIndex>> consumer = this.myNameGenerator;
        if (consumer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/models/BatchIndicesEditorModel", "getNameGenerator"));
        }
        return consumer;
    }

    public void setUniqueGenerator(@NotNull Function<DeIndex, Boolean> generator) {
        if (generator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "com/intellij/database/view/models/BatchIndicesEditorModel", "setUniqueGenerator"));
        }
        if (Comparing.equal(generator, this.myUniqueGenerator)) {
            return;
        }
        this.myUniqueGenerator = generator;
        for (DeIndex index : this.myIndices) {
            index.unique = (Boolean)generator.fun((Object)index);
        }
        this.modify();
    }

    @NotNull
    public Function<DeIndex, Boolean> getUniqueGenerator() {
        Function<DeIndex, Boolean> function = this.myUniqueGenerator;
        if (function == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/models/BatchIndicesEditorModel", "getUniqueGenerator"));
        }
        return function;
    }

    @NotNull
    public ThreeState isUnique() {
        ThreeState res = ThreeState.UNSURE;
        for (DeIndex index : this.myIndices) {
            if (res == ThreeState.UNSURE) {
                res = ThreeState.fromBoolean((boolean)index.unique);
                continue;
            }
            if (index.unique == res.toBoolean()) continue;
            ThreeState threeState = ThreeState.UNSURE;
            if (threeState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/models/BatchIndicesEditorModel", "isUnique"));
            }
            return threeState;
        }
        ThreeState threeState = res;
        if (threeState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/models/BatchIndicesEditorModel", "isUnique"));
        }
        return threeState;
    }

    @NotNull
    public JBIterable<DeIndex> getEditedObjects() {
        JBIterable jBIterable = JBIterable.from(this.myIndices);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/models/BatchIndicesEditorModel", "getEditedObjects"));
        }
        return jBIterable;
    }

    public static class PatternNameGenerator
    implements Consumer<List<DeIndex>> {
        private final String myPattern;

        public PatternNameGenerator(@NotNull String pattern) {
            if (pattern == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/database/view/models/BatchIndicesEditorModel$PatternNameGenerator", "<init>"));
            }
            this.myPattern = pattern;
        }

        @NotNull
        public String generate(@NotNull DeIndex index) {
            if (index == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "com/intellij/database/view/models/BatchIndicesEditorModel$PatternNameGenerator", "generate"));
            }
            String string = this.myPattern.replace("{table}", index.table.name).replace("{columns}", StringUtil.join((Iterable)index.getColumnsRef().names(), (String)"_"));
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/models/BatchIndicesEditorModel$PatternNameGenerator", "generate"));
            }
            return string;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PatternNameGenerator generator = (PatternNameGenerator)o;
            return this.myPattern.equals(generator.myPattern);
        }

        public int hashCode() {
            return this.myPattern.hashCode();
        }

        public String toString() {
            return this.myPattern;
        }

        @NotNull
        public String getPattern() {
            String string = this.myPattern;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/models/BatchIndicesEditorModel$PatternNameGenerator", "getPattern"));
            }
            return string;
        }

        public void consume(List<DeIndex> indices) {
            Map names = DasUtil.newCasingAwareMap((boolean)DasUtil.isCaseSensitive((Casing)indices.get((int)0).model.getCasing(ObjectKind.INDEX, null)));
            for (DeIndex index : indices) {
                index.name = this.generate(index);
                Integer integer = (Integer)names.get(index.name);
                if (integer != null) {
                    integer = integer + 1;
                    names.put(index.name, integer);
                    index.name = index.name + "_" + integer;
                    continue;
                }
                names.put(index.name, 0);
            }
        }
    }
}

