/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeIndex;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.view.editors.DatabaseBatchIndicesEditor;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.models.BatchIndicesEditorModel;
import com.intellij.database.view.ui.AbstractDbRefactoringDialog;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class AbstractBatchIndicesDialog
extends AbstractDbRefactoringDialog<DatabaseBatchIndicesEditor> {
    protected BatchIndicesEditorModel myBatchIndicesModel;

    protected AbstractBatchIndicesDialog(@NotNull DatabaseEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/ui/AbstractBatchIndicesDialog", "<init>"));
        }
        super(context);
    }

    public static boolean canAddAnything(@NotNull DatabaseEditorContext context, @NotNull List<? extends DasColumn> columns) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/ui/AbstractBatchIndicesDialog", "canAddAnything"));
        }
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/view/ui/AbstractBatchIndicesDialog", "canAddAnything"));
        }
        if (columns.isEmpty()) {
            return false;
        }
        for (DasColumn dasColumn : columns) {
            DasTable table = dasColumn.getTable();
            if (table.getKind() == ObjectKind.TABLE) continue;
            return false;
        }
        DatabaseDialectEx dialect = context.getDialect();
        return dialect.getSchemaEditor().getDbEditorCaps().getTableEditorCaps(true).getIndexCaps(false).canDoAnything();
    }

    public static boolean canModifyAnything(@NotNull DatabaseEditorContext context, @NotNull List<? extends DasIndex> indices) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/ui/AbstractBatchIndicesDialog", "canModifyAnything"));
        }
        if (indices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indices", "com/intellij/database/view/ui/AbstractBatchIndicesDialog", "canModifyAnything"));
        }
        if (indices.isEmpty()) {
            return false;
        }
        DatabaseDialectEx dialect = context.getDialect();
        return dialect.getSchemaEditor().getDbEditorCaps().getTableEditorCaps(true).getIndexCaps(true).canDoAnything();
    }

    @Override
    @NotNull
    protected String getTitle(boolean modify) {
        String string = modify ? "Batch Modify Indices" : "Batch Add Indices";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/AbstractBatchIndicesDialog", "getTitle"));
        }
        return string;
    }

    public void setIndices(@NotNull List<DeIndex> indices) {
        boolean edit;
        if (indices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indices", "com/intellij/database/view/ui/AbstractBatchIndicesDialog", "setIndices"));
        }
        if (indices.isEmpty()) {
            throw new AssertionError((Object)"Invalid indices");
        }
        for (DeIndex index : indices) {
            if (index.model != this.myModel) {
                throw new AssertionError((Object)"Invalid indices");
            }
        }
        this.myBatchIndicesModel = new BatchIndicesEditorModel(indices, this.myModel, this.myEditorModelsCache);
        boolean bl = edit = indices.get((int)0).editedObject == null;
        if (edit) {
            this.myBatchIndicesModel.setNameGenerator(BatchIndicesEditorModel.DEFAULT_NAME_GENERATOR);
            this.myBatchIndicesModel.setUniqueGenerator(BatchIndicesEditorModel.FALSE_UNIQUE_GENERATOR);
        } else {
            this.myBatchIndicesModel.setNameGenerator(BatchIndicesEditorModel.PREV_NAME_GENERATOR);
            this.myBatchIndicesModel.setUniqueGenerator(BatchIndicesEditorModel.PREV_UNIQUE_GENERATOR);
        }
        this.myBatchIndicesModel.commit();
        this.setEditor(new DatabaseBatchIndicesEditor(this.myState, this.myBatchIndicesModel));
        if (edit) {
            ((DatabaseBatchIndicesEditor)this.myEditor).setUniqueRevertStateEnabled(false);
        } else {
            ((DatabaseBatchIndicesEditor)this.myEditor).setUniqueRevertStateEnabled(this.myBatchIndicesModel.isUnique() == ThreeState.UNSURE);
            ((DatabaseBatchIndicesEditor)this.myEditor).setHintText("Edit to override existing names");
        }
    }

    @Override
    protected boolean isRefactoringValid() {
        return super.isRefactoringValid() && this.areIndicesNamesUnique();
    }

    private boolean areIndicesNamesUnique() {
        Set names = DasUtil.newCasingAwareSet((boolean)DasUtil.isCaseSensitive((Casing)this.getContext().getModel().getCasing(ObjectKind.INDEX, null)));
        for (DeIndex index : this.myBatchIndicesModel.getIndices()) {
            if (names.contains(index.name)) {
                return false;
            }
            names.add(index.name);
        }
        return true;
    }

    @NotNull
    public List<DeIndex> createIndices(@NotNull List<? extends DasColumn> columns) {
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/view/ui/AbstractBatchIndicesDialog", "createIndices"));
        }
        ArrayList indices = ContainerUtil.newArrayListWithCapacity((int)columns.size());
        for (DasColumn dasColumn : columns) {
            DeTable table = (DeTable)this.export((DasObject)dasColumn.getTable(), true);
            DeIndex index = new DeIndex("", table, this.myModel);
            index.items.add(new DeIndex.Item((DeColumn)this.export((DasObject)dasColumn, false), DasIndex.Sorting.NONE));
            indices.add(index);
            table.indices.add(index);
        }
        ArrayList arrayList = indices;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/AbstractBatchIndicesDialog", "createIndices"));
        }
        return arrayList;
    }

    @NotNull
    public List<DeIndex> existingIndices(@NotNull List<? extends DasIndex> indices) {
        if (indices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indices", "com/intellij/database/view/ui/AbstractBatchIndicesDialog", "existingIndices"));
        }
        ArrayList deIndices = ContainerUtil.newArrayListWithCapacity((int)indices.size());
        for (DasIndex dasIndex : indices) {
            this.checkObjectInContext((DasObject)dasIndex);
            deIndices.add(this.export((DasObject)dasIndex, true));
        }
        ArrayList arrayList = deIndices;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/AbstractBatchIndicesDialog", "existingIndices"));
        }
        return arrayList;
    }

    @NotNull
    public static AbstractBatchIndicesDialog newBatchAddIndicesDialog(@NotNull DatabaseEditorContext context, @NotNull List<? extends DasColumn> columns) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/ui/AbstractBatchIndicesDialog", "newBatchAddIndicesDialog"));
        }
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/view/ui/AbstractBatchIndicesDialog", "newBatchAddIndicesDialog"));
        }
        AbstractBatchIndicesDialog dialog = new AbstractBatchIndicesDialog(context);
        dialog.setIndices(dialog.createIndices(columns));
        AbstractBatchIndicesDialog abstractBatchIndicesDialog = dialog;
        if (abstractBatchIndicesDialog == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/AbstractBatchIndicesDialog", "newBatchAddIndicesDialog"));
        }
        return abstractBatchIndicesDialog;
    }

    @NotNull
    public static AbstractBatchIndicesDialog newBatchModifyIndicesDialog(@NotNull DatabaseEditorContext context, @NotNull List<? extends DasIndex> indices) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/ui/AbstractBatchIndicesDialog", "newBatchModifyIndicesDialog"));
        }
        if (indices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indices", "com/intellij/database/view/ui/AbstractBatchIndicesDialog", "newBatchModifyIndicesDialog"));
        }
        AbstractBatchIndicesDialog dialog = new AbstractBatchIndicesDialog(context);
        dialog.setIndices(dialog.existingIndices(indices));
        dialog.setRefactoring(true);
        AbstractBatchIndicesDialog abstractBatchIndicesDialog = dialog;
        if (abstractBatchIndicesDialog == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/AbstractBatchIndicesDialog", "newBatchModifyIndicesDialog"));
        }
        return abstractBatchIndicesDialog;
    }
}

