/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.DatabaseDriverListener;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.view.ui.DatabaseConfigController;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Progressive;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.HideableDecorator;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.Consumer;
import com.intellij.util.PathUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import com.intellij.util.ui.classpath.SimpleClasspathElementFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DriverClasspathPanel
implements Disposable {
    public static final String DRIVER_FILES = "Driver files";
    @NotNull
    private Project myProject;
    @Nullable
    private LocalDataSource myDataSource;
    @Nullable
    private DatabaseDriver myDriver;
    @NotNull
    private DatabaseConfigController myController;
    private JBList myArtifactList;
    private JPanel myArtifactsPanel;
    private Runnable onUpdate;
    private HideableDecorator myArtifactsDecorator;

    public DriverClasspathPanel(@NotNull Project project, @Nullable DatabaseDriver driver, @Nullable LocalDataSource dataSource, @NotNull DatabaseConfigController controller) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/view/ui/DriverClasspathPanel", "<init>"));
        }
        if (controller == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "controller", "com/intellij/database/view/ui/DriverClasspathPanel", "<init>"));
        }
        this.myProject = project;
        this.myDriver = driver;
        this.myDataSource = dataSource;
        this.myController = controller;
        DatabaseDriverManager.getInstance().addDriverListener(new DatabaseDriverListener.Adapter(){

            @Override
            public void driverUpdated(DatabaseDriver driver) {
                if (driver == DriverClasspathPanel.this.myDriver) {
                    DriverClasspathPanel.this.updateClasspath();
                }
            }

            @Override
            public void driverFilesDownloaded(DatabaseDriver driver) {
                if (driver == DriverClasspathPanel.this.myDriver) {
                    DriverClasspathPanel.this.updateClasspath();
                }
            }
        }, this);
    }

    public void dispose() {
    }

    public void setDriver(@Nullable DatabaseDriver driver) {
        this.myDriver = driver;
        this.updateClasspath();
    }

    public void setOnUpdate(Runnable onUpdate) {
        this.onUpdate = onUpdate;
    }

    public JPanel createComponent(boolean expand) {
        this.myArtifactsPanel = new JPanel(new BorderLayout());
        this.myArtifactList = new JBList();
        this.myArtifactList.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer(){

            protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                ClassPathItem item = (ClassPathItem)value;
                if (item != null) {
                    File file = item.file;
                    SimpleTextAttributes style = item.fromParent ? SimpleTextAttributes.GRAY_ATTRIBUTES : (file != null && file.exists() ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.ERROR_ATTRIBUTES);
                    this.append(file != null ? file.getPath() : item.element.getPresentableName(), style);
                    if (file != null) {
                        this.setIcon(!file.exists() ? PlatformIcons.FILE_ICON : (file.isDirectory() ? PlatformIcons.FOLDER_ICON : FileTypeManager.getInstance().getFileTypeByExtension(FileUtilRt.getExtension((String)file.getName())).getIcon()));
                    } else {
                        this.setIcon(PlatformIcons.LIBRARY_ICON);
                    }
                } else {
                    this.append("?");
                    this.setIcon(null);
                }
            }
        });
        JPanel artifactsListPanel = ToolbarDecorator.createDecorator((JList)this.myArtifactList).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                DriverClasspathPanel.this.doChooseFiles((Consumer<List<VirtualFile>>)((Consumer)new Consumer<List<VirtualFile>>(){

                    public void consume(List<VirtualFile> files) {
                        for (VirtualFile file : files) {
                            for (SimpleClasspathElement cpe : SimpleClasspathElementFactory.createElements((String[])new String[]{file.getUrl()})) {
                                ((DefaultListModel)DriverClasspathPanel.this.myArtifactList.getModel()).addElement(new ClassPathItem(cpe, false));
                            }
                        }
                    }
                }));
            }
        }).setRemoveActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(AnActionEvent e) {
                ClassPathItem item = (ClassPathItem)DriverClasspathPanel.this.myArtifactList.getSelectedValue();
                return !item.fromParent;
            }
        }).createPanel();
        this.myArtifactsDecorator = new HideableDecorator(this.myArtifactsPanel, DRIVER_FILES, false);
        this.myArtifactsDecorator.setContentComponent((JComponent)artifactsListPanel);
        this.myArtifactsDecorator.setOn(expand);
        this.myArtifactsPanel.add((Component)artifactsListPanel, "Center");
        artifactsListPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                DriverClasspathPanel.this.updateTitle();
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                DriverClasspathPanel.this.updateTitle();
            }
        });
        return this.myArtifactsPanel;
    }

    private void doChooseFiles(@NotNull Consumer<List<VirtualFile>> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/view/ui/DriverClasspathPanel", "doChooseFiles"));
        }
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, true, true, false, true){

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                return super.isFileVisible(file, showHiddenFiles) && file.isDirectory() || file.getFileType() == FileTypes.ARCHIVE;
            }
        };
        descriptor.setTitle("Select Database Driver Files");
        VirtualFile toSelect = LocalFileSystem.getInstance().findFileByPath(DatabaseDriverImpl.getDriverDownloadDirectory());
        FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)this.myProject, (Component)this.myArtifactsPanel, (VirtualFile)toSelect, consumer);
    }

    public void updateClasspath() {
        DefaultListModel listModel = new DefaultListModel();
        if (this.myDataSource != null) {
            ListModel oldModel = this.myArtifactList.getModel();
            if (oldModel.getSize() == 0) {
                for (SimpleClasspathElement cp : this.myDataSource.getOwnClasspath()) {
                    listModel.addElement(new ClassPathItem(cp, false));
                }
            } else {
                listModel = (DefaultListModel)oldModel;
            }
        } else if (this.myDriver != null) {
            for (SimpleClasspathElement element : this.myDriver.getClasspathElements()) {
                listModel.addElement(new ClassPathItem(element, this.myDataSource != null));
            }
        }
        this.myArtifactList.setModel(listModel);
        listModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                DriverClasspathPanel.this.onUpdateClasspath();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                DriverClasspathPanel.this.onUpdateClasspath();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                DriverClasspathPanel.this.onUpdateClasspath();
            }
        });
        this.onUpdateClasspath();
    }

    private void updateTitle() {
        if (this.myDriver != null && !this.myArtifactsDecorator.isExpanded()) {
            if (this.myDataSource != null && this.myDataSource.getClasspathElements() != this.myDriver.getClasspathElements() && this.myDriver.isDownloaded()) {
                this.myArtifactsDecorator.setTitle("Driver files - using " + this.myDriver.getFullName());
                return;
            }
            if (this.myDataSource != null && !this.myDataSource.getClasspathElements().isEmpty()) {
                this.myArtifactsDecorator.setTitle("Driver files - custom drivers");
                return;
            }
            if (!this.myDriver.isDownloaded()) {
                this.myArtifactsDecorator.setTitle("Driver files - not downloaded");
                return;
            }
        }
        this.myArtifactsDecorator.setTitle(DRIVER_FILES);
    }

    private void updateEmptyText() {
        if (this.myDriver != null) {
            if (this.myDataSource != null) {
                if (!this.myDriver.isDownloaded()) {
                    this.myArtifactList.getEmptyText().clear().appendText("Download", SimpleTextAttributes.LINK_ATTRIBUTES, (ActionListener)new DownloadActionListener());
                } else {
                    this.myArtifactList.getEmptyText().clear().appendText("Using ").appendText(this.myDriver.getFullName(), SimpleTextAttributes.LINK_ATTRIBUTES, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            DriverClasspathPanel.this.myController.navigateTo(DriverClasspathPanel.this.myDriver);
                        }
                    }).appendText(" driver files" + (this.myDriver.getClasspathElements().isEmpty() ? " (no files)" : ""));
                }
            } else if (StringUtil.isNotEmpty((String)this.myDriver.getArtifactName())) {
                this.myArtifactList.getEmptyText().clear().appendText("Download", SimpleTextAttributes.LINK_ATTRIBUTES, (ActionListener)new DownloadActionListener());
            } else {
                this.myArtifactList.setEmptyText("");
            }
        } else {
            this.myArtifactList.setEmptyText("Specify driver files");
        }
    }

    private void onUpdateClasspath() {
        this.updateEmptyText();
        this.updateTitle();
        if (this.onUpdate != null) {
            this.onUpdate.run();
        }
    }

    public List<SimpleClasspathElement> getClasspath() {
        ListModel artifactListModel = this.myArtifactList.getModel();
        ArrayList<SimpleClasspathElement> fileList = new ArrayList<SimpleClasspathElement>();
        for (int i = 0; i < artifactListModel.getSize(); ++i) {
            ClassPathItem item = (ClassPathItem)artifactListModel.getElementAt(i);
            if (item == null || item.fromParent) continue;
            fileList.add(item.element);
        }
        return fileList;
    }

    private class DownloadActionListener
    implements ActionListener {
        private DownloadActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DriverClasspathPanel.this.myDriver != null && !StringUtil.isEmpty((String)DriverClasspathPanel.this.myDriver.getArtifactName())) {
                final Progressive task = DriverClasspathPanel.this.myDriver.downloadDriverTask();
                String title = IdeBundle.message((String)"progress.download.0.title", (Object[])new Object[]{StringUtil.capitalize((String)DriverClasspathPanel.this.myDriver.getArtifactName()) + " files"});
                new Task.Modal(null, title, true){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/view/ui/DriverClasspathPanel$DownloadActionListener$1", "run"));
                        }
                        task.run(indicator);
                        if (!indicator.isCanceled()) {
                            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    DriverClasspathPanel.this.updateClasspath();
                                }
                            });
                        }
                    }
                }.queue();
            }
        }
    }

    private static class ClassPathItem {
        @NotNull
        SimpleClasspathElement element;
        @Nullable
        File file;
        boolean fromParent;

        ClassPathItem(@NotNull SimpleClasspathElement element, boolean fromParent) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/view/ui/DriverClasspathPanel$ClassPathItem", "<init>"));
            }
            this.element = element;
            this.fromParent = fromParent;
            String url = (String)ContainerUtil.getFirstItem((List)element.getClassesRootUrls());
            if (url != null) {
                this.file = new File(PathUtil.toPresentableUrl((String)url));
            }
        }

        public String toString() {
            String url = (String)ContainerUtil.getFirstItem((List)this.element.getClassesRootUrls());
            return url == null ? "" : PathUtil.toPresentableUrl((String)url);
        }
    }
}

