/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.intellij.database.model.DataType;
import com.intellij.dbm.common.DBScriptingService;
import com.intellij.dbm.common.DbmCheck;
import com.intellij.dbm.common.DbmColumn;
import com.intellij.dbm.common.DbmForeignKey;
import com.intellij.dbm.common.DbmIndex;
import com.intellij.dbm.common.DbmKey;
import com.intellij.dbm.common.DbmLikeTable;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.DbmSchema;
import com.intellij.dbm.common.DbmSequence;
import com.intellij.dbm.common.DbmTable;
import com.intellij.dbm.common.DbmTrigger;
import com.intellij.dbm.common.DbmView;
import com.intellij.dbm.common.DomObjectsRef;
import com.intellij.dbm.common.Family;
import com.intellij.dbm.common.ScriptPreferences;
import com.intellij.dbm.common.ScriptRequirements;
import com.intellij.dbm.common.ScriptTask;
import com.intellij.openapi.util.Couple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.sql.SqlScript;
import org.jetbrains.dekaf.sql.SqlScriptBuilder;
import org.jetbrains.dekaf.sql.SqlStatement;

public abstract class DBAbstractScriptingService
implements DBScriptingService {
    @NotNull
    final ScriptRequirements myReqs;
    @NotNull
    final ScriptPreferences myPrefs;
    private static final SqlScript EMPTY_SCRIPT = new SqlScript(new SqlStatement[0]);

    protected DBAbstractScriptingService(@NotNull ScriptRequirements reqs, @NotNull ScriptPreferences prefs) {
        if (reqs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reqs", "com/intellij/dbm/common/DBAbstractScriptingService", "<init>"));
        }
        if (prefs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefs", "com/intellij/dbm/common/DBAbstractScriptingService", "<init>"));
        }
        this.myReqs = reqs;
        this.myPrefs = prefs;
    }

    protected DBAbstractScriptingService() {
        this(new ScriptRequirements(), new ScriptPreferences());
    }

    @NotNull
    public String nameOf(@NotNull DbmObject object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/dbm/common/DBAbstractScriptingService", "nameOf"));
        }
        String string = this.convertNameFromCatalogToScript(object.getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DBAbstractScriptingService", "nameOf"));
        }
        return string;
    }

    @NotNull
    public String namesOf(@NotNull Family<? extends DbmObject> family) {
        if (family == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "family", "com/intellij/dbm/common/DBAbstractScriptingService", "namesOf"));
        }
        StringBuilder b = new StringBuilder();
        for (DbmObject dbmObject : family) {
            if (!dbmObject.hasName()) continue;
            if (b.length() > 0) {
                b.append(',').append(' ');
            }
            b.append(this.nameOf(dbmObject));
        }
        String string = b.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DBAbstractScriptingService", "namesOf"));
        }
        return string;
    }

    @NotNull
    public String namesOf(@NotNull DomObjectsRef<?> names) {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/dbm/common/DBAbstractScriptingService", "namesOf"));
        }
        StringBuilder b = new StringBuilder();
        for (String name : names.names()) {
            if (name == null) continue;
            if (b.length() > 0) {
                b.append(',').append(' ');
            }
            b.append(this.convertNameFromCatalogToScript(name));
        }
        String string = b.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DBAbstractScriptingService", "namesOf"));
        }
        return string;
    }

    protected String convertNameFromCatalogToScript(String name) {
        return name;
    }

    protected String humanizeName(String name) {
        return name;
    }

    @Override
    @NotNull
    public SqlScript makeSchemaScript(@NotNull DbmSchema schema, @NotNull ScriptTask task) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/common/DBAbstractScriptingService", "makeSchemaScript"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/dbm/common/DBAbstractScriptingService", "makeSchemaScript"));
        }
        switch (task) {
            case COMPLETE_CREATE: {
                SqlScript sqlScript = this.makeSchemaScriptCompleteCreate(schema);
                if (sqlScript == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DBAbstractScriptingService", "makeSchemaScript"));
                }
                return sqlScript;
            }
            case COMPLETE_DROP: {
                SqlScript sqlScript = this.makeSchemaScriptCompleteDrop(schema);
                if (sqlScript == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DBAbstractScriptingService", "makeSchemaScript"));
                }
                return sqlScript;
            }
        }
        SqlScript sqlScript = EMPTY_SCRIPT;
        if (sqlScript == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DBAbstractScriptingService", "makeSchemaScript"));
        }
        return sqlScript;
    }

    protected SqlScript makeSchemaScriptCompleteCreate(@NotNull DbmSchema schema) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/common/DBAbstractScriptingService", "makeSchemaScriptCompleteCreate"));
        }
        SqlScriptBuilder script = new SqlScriptBuilder();
        for (DbmSequence dbmSequence : schema.sequences()) {
            SqlScript sqlScript = this.makeSequenceScript(dbmSequence);
            script.add(new SqlScript[]{sqlScript});
        }
        SqlScript typesScript = this.makeTypesCompletely(schema);
        script.add(new SqlScript[]{typesScript});
        for (DbmTable dbmTable : schema.tables()) {
            SqlScript tableScript = this.makeTableScriptCompleteCreate(dbmTable);
            script.add(new SqlScript[]{tableScript});
        }
        for (DbmView dbmView : schema.views()) {
            SqlScript viewScript = this.makeViewScriptCompleteCreate(dbmView);
            script.add(new SqlScript[]{viewScript});
        }
        return script.build();
    }

    protected SqlScript makeSchemaScriptCompleteDrop(@NotNull DbmSchema schema) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/common/DBAbstractScriptingService", "makeSchemaScriptCompleteDrop"));
        }
        ArrayList<? extends DbmTable> tables = new ArrayList<DbmTable>((Collection<? extends DbmTable>)schema.tables().asList());
        Collections.reverse(tables);
        SqlScriptBuilder script = new SqlScriptBuilder();
        for (DbmTable dbmTable : tables) {
            SqlScript tableScript = this.makeTableScriptCompleteDrop(dbmTable);
            script.add(new SqlScript[]{tableScript});
        }
        return script.build();
    }

    @NotNull
    protected abstract SqlScript makeSequenceScript(@NotNull DbmSequence var1);

    @NotNull
    protected abstract SqlScript makeTypesCompletely(@NotNull DbmSchema var1);

    @Override
    @NotNull
    public SqlScript makeTableScript(@NotNull DbmTable table, @NotNull ScriptTask task) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/dbm/common/DBAbstractScriptingService", "makeTableScript"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/dbm/common/DBAbstractScriptingService", "makeTableScript"));
        }
        switch (task) {
            case COMPLETE_CREATE: {
                SqlScript sqlScript = this.makeTableScriptCompleteCreate(table);
                if (sqlScript == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DBAbstractScriptingService", "makeTableScript"));
                }
                return sqlScript;
            }
            case COMPLETE_DROP: {
                SqlScript sqlScript = this.makeTableScriptCompleteDrop(table);
                if (sqlScript == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DBAbstractScriptingService", "makeTableScript"));
                }
                return sqlScript;
            }
        }
        SqlScript sqlScript = EMPTY_SCRIPT;
        if (sqlScript == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DBAbstractScriptingService", "makeTableScript"));
        }
        return sqlScript;
    }

    @NotNull
    protected SqlScript makeTableScriptCompleteCreate(@NotNull DbmTable table) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/dbm/common/DBAbstractScriptingService", "makeTableScriptCompleteCreate"));
        }
        HashSet<DbmObject> readyObjects = new HashSet<DbmObject>();
        Couple<String> hf = this.makeTableHeaderFooter(table);
        StringBuilder b = new StringBuilder();
        b.append((String)hf.first).append("\n(\n");
        for (DbmColumn dbmColumn : table.columns()) {
            b.append("    ");
            this.makeColumnDefinition(dbmColumn, b, readyObjects);
            b.append(",\n");
        }
        for (DbmKey dbmKey : table.keys()) {
            if (readyObjects.contains(dbmKey)) continue;
            b.append("    ");
            this.makeInnerKeyDefinition(dbmKey, b);
            b.append(",\n");
            readyObjects.add(dbmKey);
            if (dbmKey.getUnderlyingIndex() == null) continue;
            readyObjects.add(dbmKey.getUnderlyingIndex());
        }
        for (DbmIndex dbmIndex : table.indices()) {
            if (readyObjects.contains(dbmIndex) || !dbmIndex.isUnique()) continue;
            b.append("    ");
            this.makeInnerIndexDefinition(dbmIndex, b);
            b.append(",\n");
            readyObjects.add(dbmIndex);
        }
        for (DbmForeignKey dbmForeignKey : table.foreignKeys()) {
            if (readyObjects.contains(dbmForeignKey)) continue;
            b.append("    ");
            this.makeInnerForeignKeyDefinition(dbmForeignKey, b);
            b.append(",\n");
            readyObjects.add(dbmForeignKey);
        }
        for (DbmCheck dbmCheck : table.checks()) {
            if (readyObjects.contains(dbmCheck)) continue;
            b.append("    ");
            if (dbmCheck.hasNaturalName()) {
                b.append("constraint ").append(this.nameOf(dbmCheck)).append(' ');
            }
            b.append("check (").append(dbmCheck.getPredicate()).append("),\n");
            readyObjects.add(dbmCheck);
        }
        b.delete(b.length() - 2, b.length());
        b.append("\n)\n");
        if (((String)hf.second).length() > 0) {
            b.append((String)hf.second).append('\n');
        }
        SqlScriptBuilder script = new SqlScriptBuilder();
        script.parse(b.toString());
        this.makeComments(table, script);
        for (DbmTrigger dbmTrigger : table.triggers()) {
            String sourceText = dbmTrigger.getSourceText();
            if (sourceText == null) continue;
            script.parse(sourceText);
        }
        SqlScript sqlScript = script.build();
        if (sqlScript == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DBAbstractScriptingService", "makeTableScriptCompleteCreate"));
        }
        return sqlScript;
    }

    @NotNull
    protected SqlScript makeTableScriptCompleteDrop(@NotNull DbmTable table) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/dbm/common/DBAbstractScriptingService", "makeTableScriptCompleteDrop"));
        }
        SqlScript sqlScript = new SqlScript(new String[]{"drop table " + this.nameOf(table)});
        if (sqlScript == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DBAbstractScriptingService", "makeTableScriptCompleteDrop"));
        }
        return sqlScript;
    }

    protected abstract Couple<String> makeTableHeaderFooter(@NotNull DbmTable var1);

    @NotNull
    SqlScript makeViewScript(@NotNull DbmView view, @NotNull ScriptTask task) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/dbm/common/DBAbstractScriptingService", "makeViewScript"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/dbm/common/DBAbstractScriptingService", "makeViewScript"));
        }
        switch (task) {
            case COMPLETE_CREATE: {
                SqlScript sqlScript = this.makeViewScriptCompleteCreate(view);
                if (sqlScript == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DBAbstractScriptingService", "makeViewScript"));
                }
                return sqlScript;
            }
            case COMPLETE_DROP: {
                SqlScript sqlScript = this.makeViewScriptCompleteDrop(view);
                if (sqlScript == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DBAbstractScriptingService", "makeViewScript"));
                }
                return sqlScript;
            }
        }
        SqlScript sqlScript = new SqlScript(new String[]{""});
        if (sqlScript == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DBAbstractScriptingService", "makeViewScript"));
        }
        return sqlScript;
    }

    @NotNull
    private SqlScript makeViewScriptCompleteCreate(@NotNull DbmView view) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/dbm/common/DBAbstractScriptingService", "makeViewScriptCompleteCreate"));
        }
        String viewName = view.getNameOrNull();
        if (viewName == null) {
            SqlScript sqlScript = EMPTY_SCRIPT;
            if (sqlScript == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DBAbstractScriptingService", "makeViewScriptCompleteCreate"));
            }
            return sqlScript;
        }
        StringBuilder b = new StringBuilder(600);
        b.append(this.myPrefs.useCreateOrReplace ? "create or replace view " : "create view ");
        b.append(viewName);
        if (this.myPrefs.specifyViewColumns && view.columns().isNotEmpty()) {
            b.append(" (");
            for (DbmColumn dbmColumn : view.columns()) {
                b.append(this.nameOf(dbmColumn)).append(", ");
            }
            b.delete(b.length() - 2, b.length()).append(')');
        }
        b.append("\nas\n");
        b.append(view.getSourceText());
        SqlScriptBuilder script = new SqlScriptBuilder();
        script.parse(b.toString());
        this.makeComments(view, script);
        for (DbmTrigger dbmTrigger : view.triggers()) {
            String sourceText = dbmTrigger.getSourceText();
            if (sourceText == null) continue;
            script.parse(sourceText);
        }
        SqlScript sqlScript = script.build();
        if (sqlScript == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DBAbstractScriptingService", "makeViewScriptCompleteCreate"));
        }
        return sqlScript;
    }

    private void makeComments(@NotNull DbmLikeTable table, @NotNull SqlScriptBuilder script) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/dbm/common/DBAbstractScriptingService", "makeComments"));
        }
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "com/intellij/dbm/common/DBAbstractScriptingService", "makeComments"));
        }
        if (table.getComment() != null) {
            String commentCmd = "comment on table " + this.nameOf(table) + " is '" + table.getComment() + "'";
            script.parse(commentCmd);
        }
        for (DbmColumn dbmColumn : table.columns()) {
            if (dbmColumn.getComment() == null) continue;
            String commentCmd = "comment on column " + this.nameOf(table) + '.' + this.nameOf(dbmColumn) + " is '" + dbmColumn.getComment() + "'";
            script.parse(commentCmd);
        }
    }

    @NotNull
    protected SqlScript makeViewScriptCompleteDrop(@NotNull DbmView view) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/dbm/common/DBAbstractScriptingService", "makeViewScriptCompleteDrop"));
        }
        String viewName = view.getNameOrNull();
        SqlScript sqlScript = viewName != null ? new SqlScript(new String[]{"drop view " + viewName}) : EMPTY_SCRIPT;
        if (sqlScript == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DBAbstractScriptingService", "makeViewScriptCompleteDrop"));
        }
        return sqlScript;
    }

    protected void makeColumnDefinition(@NotNull DbmColumn column, @NotNull StringBuilder b, @NotNull Set<DbmObject> readyObjects) {
        DbmCheck[] simpleChecks;
        DbmKey simpleKey;
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/dbm/common/DBAbstractScriptingService", "makeColumnDefinition"));
        }
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/intellij/dbm/common/DBAbstractScriptingService", "makeColumnDefinition"));
        }
        if (readyObjects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readyObjects", "com/intellij/dbm/common/DBAbstractScriptingService", "makeColumnDefinition"));
        }
        b.append(this.nameOf(column));
        if (column.getDataType() != null) {
            b.append(' ');
            this.makeTypeDefinition(column.getDataType(), b);
        }
        if (column.getDefaultExpression() != null) {
            b.append(" default ").append(column.getDefaultExpression());
        }
        if (column.isMandatory()) {
            b.append(" not null");
        }
        if ((simpleKey = column.getSimpleKey()) != null) {
            b.append("\n\t");
            if (simpleKey.hasNaturalName()) {
                b.append(" constraint ").append(this.nameOf(simpleKey));
            }
            b.append(simpleKey.isPrimary() ? " primary key" : " unique");
            readyObjects.add(simpleKey);
            if (simpleKey.getUnderlyingIndex() != null) {
                readyObjects.add(simpleKey.getUnderlyingIndex());
            }
        }
        for (DbmCheck check : simpleChecks = column.getSimpleChecks()) {
            if (check.getPredicate() == null) {
                return;
            }
            b.append("\n\t");
            if (check.hasNaturalName()) {
                b.append(" constraint ").append(this.nameOf(check)).append(' ');
            }
            b.append("check (").append(check.getPredicate()).append(")");
            readyObjects.add(check);
        }
    }

    public void makeTypeDefinition(@NotNull DataType type, @NotNull StringBuilder b) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/dbm/common/DBAbstractScriptingService", "makeTypeDefinition"));
        }
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/intellij/dbm/common/DBAbstractScriptingService", "makeTypeDefinition"));
        }
        b.append(type.getSpecification());
    }

    protected void makeInnerKeyDefinition(@NotNull DbmKey key, @NotNull StringBuilder b) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/dbm/common/DBAbstractScriptingService", "makeInnerKeyDefinition"));
        }
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/intellij/dbm/common/DBAbstractScriptingService", "makeInnerKeyDefinition"));
        }
        if (key.hasNaturalName()) {
            b.append("constraint ").append(this.nameOf(key)).append(' ');
        }
        b.append(key.isPrimary() ? "primary key (" : "unique (").append(this.namesOf(key.myColumns)).append(')');
    }

    protected void makeInnerIndexDefinition(@NotNull DbmIndex index, @NotNull StringBuilder b) {
        if (index == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "com/intellij/dbm/common/DBAbstractScriptingService", "makeInnerIndexDefinition"));
        }
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/intellij/dbm/common/DBAbstractScriptingService", "makeInnerIndexDefinition"));
        }
        b.append(index.isUnique() ? "index (" : "unique (").append(this.namesOf(index.myColumns)).append(')');
    }

    protected void makeInnerForeignKeyDefinition(@NotNull DbmForeignKey fkey, @NotNull StringBuilder b) {
        if (fkey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fkey", "com/intellij/dbm/common/DBAbstractScriptingService", "makeInnerForeignKeyDefinition"));
        }
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/intellij/dbm/common/DBAbstractScriptingService", "makeInnerForeignKeyDefinition"));
        }
        DbmKey refKey = fkey.refKey.resolveObject();
        if (refKey == null) {
            return;
        }
        if (fkey.hasNaturalName()) {
            b.append("constraint ").append(this.nameOf(fkey)).append(' ');
        }
        b.append("foreign key (").append(this.namesOf(fkey.myColumns)).append(") references ").append(this.nameOf((DbmObject)refKey.getTable()));
        if (!refKey.isPrimary()) {
            b.append(" (").append(this.namesOf(refKey.myColumns)).append(")");
        }
    }

    @Override
    @NotNull
    public String makeTriggerCreateDefinition(@NotNull DbmTrigger o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/dbm/common/DBAbstractScriptingService", "makeTriggerCreateDefinition"));
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DBAbstractScriptingService", "makeTriggerCreateDefinition"));
        }
        return "";
    }
}

