/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.dbm.common.DbmCheck;
import com.intellij.dbm.common.DbmIndex;
import com.intellij.dbm.common.DbmKey;
import com.intellij.dbm.common.DbmLikeColumn;
import com.intellij.dbm.common.DbmLikeTable;
import com.intellij.dbm.common.DbmTableElement;
import com.intellij.dbm.common.DbmUserDefinedType;
import com.intellij.dbm.common.SequenceIdentity;
import com.intellij.dbm.common.StateProperty;
import com.intellij.util.Numbers;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.util.Strings;

public class DbmColumn
extends DbmTableElement
implements DbmLikeColumn,
DasColumn {
    @StateProperty
    public boolean myMandatory;
    @StateProperty
    public boolean myComputed;
    @StateProperty
    @Nullable
    public DataType myDataType;
    @StateProperty
    @Nullable
    public SequenceIdentity mySequenceIdentity;
    @StateProperty
    @Nullable
    public String myDefaultExpression;
    private short myPosition;

    public DbmColumn(@NotNull DbmLikeTable table, @Nullable String name) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/dbm/common/DbmColumn", "<init>"));
        }
        super(table, name);
    }

    @Override
    @NotNull
    public final ObjectKind kind() {
        ObjectKind objectKind = ObjectKind.COLUMN;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmColumn", "kind"));
        }
        return objectKind;
    }

    @Override
    public short getPosition() {
        return this.myPosition;
    }

    @Override
    public void setPosition(short position) {
        if (this.myPosition == position) {
            return;
        }
        this.modifying();
        this.myPosition = position;
    }

    @Override
    @NotNull
    protected String calculateDisplayOrder() {
        String string = Numbers.toFixLengthNumber(this.getPosition(), 3);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmColumn", "calculateDisplayOrder"));
        }
        return string;
    }

    @Override
    @NotNull
    public DataType getDataType() {
        DataType dataType = (DataType)ObjectUtils.notNull((Object)this.myDataType, (Object)DataType.UNKNOWN);
        if (dataType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmColumn", "getDataType"));
        }
        return dataType;
    }

    public boolean isNotNull() {
        return this.myMandatory;
    }

    @Override
    @Nullable
    public DbmUserDefinedType getCustomType() {
        if (this.myDataType == null) {
            return null;
        }
        if (this.myDataType.schemaName == null) {
            return null;
        }
        return this.table.schema().resolveCustomType(this.myDataType);
    }

    public void setDataType(@Nullable DataType dataType) {
        DataType dt;
        DataType dataType2 = dt = dataType == DataType.UNKNOWN ? null : dataType;
        if (Objects.equal((Object)this.myDataType, (Object)dt)) {
            return;
        }
        this.modifying();
        this.myDataType = dt;
    }

    @Override
    public boolean isMandatory() {
        return this.myMandatory;
    }

    public void setMandatory(boolean mandatory) {
        if (this.myMandatory == mandatory) {
            return;
        }
        this.modifying();
        this.myMandatory = mandatory;
    }

    public boolean isComputed() {
        return this.myComputed;
    }

    public void setComputed(boolean computed) {
        if (this.myComputed == computed) {
            return;
        }
        this.modifying();
        this.myComputed = computed;
    }

    @Nullable
    public SequenceIdentity getSequenceIdentity() {
        return this.mySequenceIdentity;
    }

    public void setSequenceIdentity(@Nullable SequenceIdentity sequenceIdentity) {
        if (Objects.equal((Object)this.mySequenceIdentity, (Object)sequenceIdentity)) {
            return;
        }
        this.modifying();
        this.mySequenceIdentity = sequenceIdentity;
    }

    @Override
    @Nullable
    public String getDefaultExpression() {
        return this.myDefaultExpression;
    }

    public void setDefaultExpression(@Nullable String defaultExpression) {
        if (Strings.eq((String)this.myDefaultExpression, (String)defaultExpression)) {
            return;
        }
        this.modifying();
        this.myDefaultExpression = defaultExpression;
    }

    @Override
    @NotNull
    public String description(boolean includeSurrogates) {
        int n;
        StringBuilder b = new StringBuilder(60);
        if (this.myComputed) {
            b.append("computed ");
        }
        if (this.myDataType != null) {
            b.append(this.myDataType.getSpecification()).append(' ');
        }
        if (this.myMandatory) {
            b.append("NN ");
        }
        if (this.mySequenceIdentity != null) {
            b.append("identity ").append(this.mySequenceIdentity.getSpecification()).append(' ');
        }
        if (this.myDefaultExpression != null) {
            b.append("default ").append(this.myDefaultExpression).append(' ');
        }
        if ((n = b.length()) > 2) {
            b.deleteCharAt(n - 1);
        }
        String string = b.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmColumn", "description"));
        }
        return string;
    }

    @Nullable
    public DbmKey getSimpleKey() {
        for (DbmKey dbmKey : this.table.keys()) {
            if (!dbmKey.isOneColumn(this)) continue;
            return dbmKey;
        }
        return null;
    }

    @Nullable
    public DbmIndex getSimpleIndex() {
        for (DbmIndex dbmIndex : this.table.indices()) {
            if (dbmIndex.myColumns.size() != 1 || !this.isName(dbmIndex.myColumns.firstName())) continue;
            return dbmIndex;
        }
        return null;
    }

    @NotNull
    public DbmCheck[] getSimpleChecks() {
        ArrayList<DbmCheck> checks = new ArrayList<DbmCheck>(1);
        for (DbmCheck dbmCheck : this.table.checks()) {
            if (!dbmCheck.isOneColumn(this)) continue;
            checks.add(dbmCheck);
        }
        DbmCheck[] dbmCheckArray = checks.toArray(new DbmCheck[checks.size()]);
        if (dbmCheckArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmColumn", "getSimpleChecks"));
        }
        return dbmCheckArray;
    }

    @Override
    protected void collectState(@NotNull ImmutableMap.Builder<String, Object> stateBuilder, boolean surrogates) {
        if (stateBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateBuilder", "com/intellij/dbm/common/DbmColumn", "collectState"));
        }
        super.collectState(stateBuilder, surrogates);
        this.putState(stateBuilder, "mandatory", this.myMandatory);
        if (this.myDataType != null) {
            this.putState(stateBuilder, "type", this.myDataType.getSpecification());
        }
        if (this.mySequenceIdentity != null) {
            this.putState(stateBuilder, "identity", this.mySequenceIdentity.getSpecification());
        }
        this.putState(stateBuilder, "default_expression", this.myDefaultExpression);
        this.putState(stateBuilder, "comment", this.myComment);
    }

    @Nullable
    public String getDefault() {
        return this.myDefaultExpression;
    }
}

