/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasConstraint;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.dbm.common.DbmArgument;
import com.intellij.dbm.common.DbmCheck;
import com.intellij.dbm.common.DbmColumn;
import com.intellij.dbm.common.DbmComplex;
import com.intellij.dbm.common.DbmDatabase;
import com.intellij.dbm.common.DbmForeignKey;
import com.intellij.dbm.common.DbmIndex;
import com.intellij.dbm.common.DbmKey;
import com.intellij.dbm.common.DbmMatView;
import com.intellij.dbm.common.DbmModelListener;
import com.intellij.dbm.common.DbmNamespace;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.DbmRef;
import com.intellij.dbm.common.DbmSchema;
import com.intellij.dbm.common.DbmSequence;
import com.intellij.dbm.common.DbmSingleRoutine;
import com.intellij.dbm.common.DbmSynonym;
import com.intellij.dbm.common.DbmTable;
import com.intellij.dbm.common.DbmTrigger;
import com.intellij.dbm.common.DbmUtil;
import com.intellij.dbm.common.DbmView;
import com.intellij.dbm.common.Family;
import com.intellij.dbm.common.ObjectsRef;
import com.intellij.dbm.common.RootNamespaceFamily;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Couple;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.jdbc.UnknownDatabase;

public abstract class DbmModel<N extends DbmNamespace>
implements DasModel {
    protected static Logger LOG = Logger.getInstance(DbmModel.class);
    public static final MetaModel<DbmObject> DEFAULT_META_MODEL = MetaModel.builder().put(ObjectKind.NONE, ObjectKind.DATABASE, DbmDatabase.class).put(ObjectKind.DATABASE, ObjectKind.SCHEMA, DbmSchema.class).put(ObjectKind.SCHEMA, ObjectKind.TABLE, DbmTable.class).put(ObjectKind.SCHEMA, ObjectKind.VIEW, DbmView.class).put(ObjectKind.SCHEMA, ObjectKind.SEQUENCE, DbmSequence.class).put(ObjectKind.SCHEMA, ObjectKind.MAT_VIEW, DbmMatView.class).put(ObjectKind.SCHEMA, ObjectKind.ROUTINE, DbmSingleRoutine.class).put(ObjectKind.SCHEMA, ObjectKind.SYNONYM, DbmSynonym.class).put(ObjectKind.SCHEMA, ObjectKind.PACKAGE, DbmComplex.class).put(ObjectKind.TABLE, ObjectKind.COLUMN, DbmColumn.class).put(ObjectKind.TABLE, ObjectKind.INDEX, DbmIndex.class).put(ObjectKind.TABLE, ObjectKind.KEY, DbmKey.class).put(ObjectKind.TABLE, ObjectKind.FOREIGN_KEY, DbmForeignKey.class).put(ObjectKind.TABLE, ObjectKind.CHECK, DbmCheck.class).put(ObjectKind.TABLE, ObjectKind.TRIGGER, DbmTrigger.class).put(ObjectKind.VIEW, ObjectKind.COLUMN, DbmColumn.class).put(ObjectKind.ROUTINE, ObjectKind.ARGUMENT, DbmArgument.class).build();
    @NotNull
    public final MetaModel<DbmObject> metaModel;
    @NotNull
    private final Family<N> myRoots;
    final MultiMap<DbmObject, DbmRef.ResolvedRef<?, ?>> forwardRefs;
    final MultiMap<DbmObject, DbmRef.ResolvedRef<?, ?>> backwardRefs;
    final ConcurrentMap<ObjectsRef<?, ?>, ConcurrentMap<DbmRef<?>, DbmRef<?>>> objectsRefs;
    private final THashSet<DbmObject> myLastCreatedObjects;
    private final THashSet<DbmObject> myLastModifiedObjects;
    private final THashSet<DbmObject> myLastRemovedObjects;
    private final ReentrantReadWriteLock myLock;
    private volatile long myModificationThreadId;
    private final CopyOnWriteArrayList<DbmModelListener> myListeners;

    protected DbmModel() {
        this(DEFAULT_META_MODEL);
    }

    protected DbmModel(@NotNull MetaModel<DbmObject> meta) {
        if (meta == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meta", "com/intellij/dbm/common/DbmModel", "<init>"));
        }
        this.forwardRefs = MultiMap.createConcurrentSet();
        this.backwardRefs = MultiMap.createConcurrentSet();
        this.objectsRefs = ContainerUtil.newConcurrentMap();
        this.myLastCreatedObjects = new THashSet();
        this.myLastModifiedObjects = new THashSet();
        this.myLastRemovedObjects = new THashSet();
        this.myLock = new ReentrantReadWriteLock();
        this.myModificationThreadId = Long.MIN_VALUE;
        this.myListeners = new CopyOnWriteArrayList();
        this.metaModel = meta;
        Couple rootCouple = (Couple)meta.getKindCouples().iterator().next();
        this.myRoots = new RootNamespaceFamily<N>(this, meta.getObjectClass(rootCouple), (ObjectKind)rootCouple.second);
    }

    void doingObjectCreate(@NotNull DbmObject object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/dbm/common/DbmModel", "doingObjectCreate"));
        }
        this.doingAnyModification();
        this.myLastCreatedObjects.add((Object)object);
    }

    void doingObjectModify(@NotNull DbmObject object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/dbm/common/DbmModel", "doingObjectModify"));
        }
        this.doingAnyModification();
        this.myLastModifiedObjects.add((Object)object);
    }

    void doingRootsModify() {
        this.doingAnyModification();
    }

    void doingObjectRemove(@NotNull DbmObject object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/dbm/common/DbmModel", "doingObjectRemove"));
        }
        this.doingAnyModification();
        this.myLastRemovedObjects.add((Object)object);
    }

    private void doingAnyModification() {
    }

    public void startModifications() {
        this.myLock.writeLock().lock();
        this.clear();
        this.myModificationThreadId = Thread.currentThread().getId();
    }

    public void finishModifications() {
        this.myModificationThreadId = Long.MIN_VALUE;
        ReentrantReadWriteLock.WriteLock writeLock = this.myLock.writeLock();
        if (!writeLock.isHeldByCurrentThread()) {
            throw new IllegalStateException("The model is locked by another thread");
        }
        if (writeLock.getHoldCount() == 1) {
            this.processNotifications();
            this.clear();
            this.compact();
        }
        writeLock.unlock();
    }

    private void processNotifications() {
        this.myLastCreatedObjects.removeAll(this.myLastRemovedObjects);
        this.myLastModifiedObjects.removeAll(this.myLastRemovedObjects);
        this.myLastModifiedObjects.removeAll(this.myLastCreatedObjects);
        if (this.myLastCreatedObjects.isEmpty() && this.myLastModifiedObjects.isEmpty() && this.myLastRemovedObjects.isEmpty()) {
            return;
        }
        Set<DbmObject> lastCreatedObjects = Collections.unmodifiableSet(this.myLastCreatedObjects);
        Set<DbmObject> lastModifiedObjects = Collections.unmodifiableSet(this.myLastModifiedObjects);
        Set<DbmObject> lastRemovedObjects = Collections.unmodifiableSet(this.myLastRemovedObjects);
        for (DbmModelListener listener : this.myListeners) {
            try {
                listener.modified(lastCreatedObjects, lastModifiedObjects, lastRemovedObjects);
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        }
    }

    private void clear() {
        this.myLastCreatedObjects.clear();
        this.myLastModifiedObjects.clear();
        this.myLastRemovedObjects.clear();
    }

    private void compact() {
        this.myLastCreatedObjects.compact();
        this.myLastModifiedObjects.compact();
        this.myLastRemovedObjects.compact();
    }

    public void addListener(DbmModelListener listener) {
        this.myListeners.add(listener);
    }

    public void removeListener(DbmModelListener listener) {
        this.myListeners.remove(listener);
    }

    public boolean isInModifyingTransaction() {
        return this.myModificationThreadId != Long.MIN_VALUE;
    }

    @NotNull
    public Rdbms getRdbms() {
        Rdbms rdbms = UnknownDatabase.RDBMS;
        if (rdbms == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmModel", "getRdbms"));
        }
        return rdbms;
    }

    @NotNull
    public final Family<N> roots() {
        Family<N> family = this.myRoots;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmModel", "roots"));
        }
        return family;
    }

    @NotNull
    public JBIterable<DbmNamespace> getModelRoots() {
        JBIterable jBIterable = JBIterable.from(this.roots());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmModel", "getModelRoots"));
        }
        return jBIterable;
    }

    @Nullable
    public abstract N getCurrentRoot();

    public abstract void setCurrentRoot(@Nullable DbmNamespace var1);

    @Nullable
    public abstract DbmSchema getCurrentSchema();

    @NotNull
    public Casing getCasing(@NotNull ObjectKind kind, @Nullable DasObject context) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/dbm/common/DbmModel", "getCasing"));
        }
        DbmObject object = DbmUtil.getModelObjectOf(context);
        if (object == null) {
            Casing casing = DbmDatabase.UNKNOWN_CASING;
            if (casing == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmModel", "getCasing"));
            }
            return casing;
        }
        Casing casing = object.namespace().getCasing(kind, context);
        if (casing == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmModel", "getCasing"));
        }
        return casing;
    }

    @NotNull
    public abstract Iterable<? extends DbmSchema> getAllSchemas();

    @Nullable
    public DbmSchema findSchema(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/dbm/common/DbmModel", "findSchema"));
        }
        return (DbmSchema)DasUtil.getSchemas((DasModel)this).filter(DasUtil.byName((String)name, (CasingProvider)this)).first();
    }

    @NotNull
    public JBIterable<? extends DasConstraint> getExportedKeys(DasTable table) {
        if (!(table instanceof DbmTable)) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmModel", "getExportedKeys"));
            }
            return jBIterable;
        }
        JBIterable jBIterable = ((JBTreeTraverser)DbmUtil.dbmTraverser().withRoot((Object)((DbmTable)table))).traverse().flatten((Function)new Function<DbmObject, Iterable<Object>>(){

            public Iterable<Object> fun(DbmObject o) {
                return o.backwardReferences(DbmForeignKey.class).transform(DbmUtil.REF_SOURCE);
            }
        }).filter(DasConstraint.class);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmModel", "getExportedKeys"));
        }
        return jBIterable;
    }

    @NotNull
    public JBTreeTraverser<DasObject> traverser() {
        JBTreeTraverser jBTreeTraverser = (JBTreeTraverser)DasUtil.dasTraverser().withRoots(this.getModelRoots());
        if (jBTreeTraverser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmModel", "traverser"));
        }
        return jBTreeTraverser;
    }
}

