/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.google.common.collect.ImmutableList;
import com.intellij.database.model.MetaModel;
import com.intellij.dbm.common.DbmModel;
import com.intellij.dbm.common.DbmNamespace;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.DbmSchema;
import com.intellij.dbm.common.Family;
import com.intellij.util.containers.ConcurrentLongObjectMap;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DbmSingleDatabaseModel<S extends DbmSchema>
extends DbmModel<S> {
    @Nullable
    private S myCurrentSchema;
    private final ConcurrentLongObjectMap<DbmObject> myObjectsById;

    public DbmSingleDatabaseModel(@NotNull MetaModel<DbmObject> meta) {
        if (meta == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meta", "com/intellij/dbm/common/DbmSingleDatabaseModel", "<init>"));
        }
        super(meta);
        this.myObjectsById = ContainerUtil.createConcurrentLongObjectMap();
    }

    @NotNull
    public Family<S> schemas() {
        Family family = this.roots();
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmSingleDatabaseModel", "schemas"));
        }
        return family;
    }

    @Override
    @Nullable
    public S getCurrentRoot() {
        return this.myCurrentSchema;
    }

    @Override
    public void setCurrentRoot(@Nullable DbmNamespace namespace) {
        if (namespace != null) {
            if (namespace.model != this) {
                throw new IllegalStateException("Attempt to set current schema from an alien model");
            }
            if (!(namespace instanceof DbmSchema)) {
                throw new IllegalStateException("Attempt to set a wrong class object as a current schema");
            }
            this.myCurrentSchema = (DbmSchema)namespace;
        } else {
            this.myCurrentSchema = null;
        }
    }

    @Nullable
    public S getCurrentSchema() {
        return this.myCurrentSchema;
    }

    public void setCurrentSchema(@Nullable DbmSchema schema) {
        if (schema != null) assert (schema.model == this);
        this.myCurrentSchema = schema;
    }

    @NotNull
    public final List<S> getAllSchemas() {
        ImmutableList<S> immutableList = this.schemas().asList();
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmSingleDatabaseModel", "getAllSchemas"));
        }
        return immutableList;
    }

    public void justObjectIdChanged(DbmObject object, long oldId, long newId) {
        if (oldId != 0L) {
            this.myObjectsById.remove(oldId, (Object)object);
        }
        if (newId != 0L) {
            this.myObjectsById.put(newId, (Object)object);
        }
    }

    @Nullable
    public DbmObject getObjectById(long id) {
        return (DbmObject)this.myObjectsById.get(id);
    }
}

