/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.intellij.coding.CodeTextBuilder;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbElement;
import com.intellij.dbm.common.DbmElement;
import com.intellij.dbm.common.DbmModel;
import com.intellij.dbm.common.DbmNode;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.DbmRef;
import com.intellij.dbm.common.Family;
import com.intellij.dbm.common.RelativeReference;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DbmUtil {
    static final Logger LOG = Logger.getInstance((String)"com.intellij.dbm.DatabaseModel");
    public static final Function<DbmRef.ResolvedRef<?, ?>, Object> REF_SOURCE = new Function<DbmRef.ResolvedRef<?, ?>, Object>(){

        public Object fun(DbmRef.ResolvedRef<?, ?> ref) {
            return ref.source;
        }
    };
    public static final Function<DbmRef.ResolvedRef<?, ?>, Object> REF_TARGET = new Function<DbmRef.ResolvedRef<?, ?>, Object>(){

        public Object fun(DbmRef.ResolvedRef<?, ?> ref) {
            return ref.target;
        }
    };
    private static final JBTreeTraverser<DbmObject> DBM_TRAVERSER = new JBTreeTraverser((Function)new Function<DbmObject, Iterable<? extends DbmObject>>(){

        public Iterable<? extends DbmObject> fun(DbmObject o) {
            return Iterables.concat(o.families());
        }
    });

    public static <R extends DbmObject> Function<DbmRef.ResolvedRef<?, ?>, DbmRef.ResolvedRef<? extends R, ? extends DbmObject>> CAST_REF_SOURCE(final Class<R> clazz) {
        return new NullableFunction<DbmRef.ResolvedRef<?, ?>, DbmRef.ResolvedRef<? extends R, ?>>(){

            @Nullable
            public DbmRef.ResolvedRef<? extends R, ?> fun(DbmRef.ResolvedRef<?, ?> ref) {
                return clazz.isInstance(ref.source) ? ref : null;
            }
        };
    }

    public static <T extends DbmObject> Function<DbmRef.ResolvedRef<?, ?>, DbmRef.ResolvedRef<? extends DbmObject, ? extends T>> CAST_REF_TARGET(final Class<T> clazz) {
        return new NullableFunction<DbmRef.ResolvedRef<?, ?>, DbmRef.ResolvedRef<?, ? extends T>>(){

            @Nullable
            public DbmRef.ResolvedRef<?, ? extends T> fun(DbmRef.ResolvedRef<?, ?> ref) {
                return clazz.isInstance(ref.target) ? ref : null;
            }
        };
    }

    public static String[] branch(@NotNull DbmObject object1, @NotNull DbmObject object2, boolean useSurrogateNames) {
        if (object1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object1", "com/intellij/dbm/common/DbmUtil", "branch"));
        }
        if (object2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object2", "com/intellij/dbm/common/DbmUtil", "branch"));
        }
        LinkedList<String> list = new LinkedList<String>();
        DbmObject object = object2;
        while (object != object1) {
            list.add(0, object.identity(useSurrogateNames));
            if ((object = object.parent()) != null) continue;
            throw new IllegalArgumentException("The object2 must be a (sub)child of the object1");
        }
        list.add(0, object1.identity(useSurrogateNames));
        return ArrayUtil.toStringArray(list);
    }

    public static String[] fullPath(@NotNull DbmObject object, boolean useSurrogateNames) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/dbm/common/DbmUtil", "fullPath"));
        }
        LinkedList<String> list = new LinkedList<String>();
        for (DbmObject obj = object; obj != null; obj = obj.parent()) {
            list.add(0, obj.identity(useSurrogateNames));
        }
        return ArrayUtil.toStringArray(list);
    }

    public static String describe(@NotNull DbmObject element, boolean includeSurrogates) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/dbm/common/DbmUtil", "describe"));
        }
        CodeTextBuilder ctb = new CodeTextBuilder();
        ctb.setIndentation("    ");
        DbmUtil.describeRecursively(ctb, element, includeSurrogates);
        return ctb.getText();
    }

    public static String describe(@NotNull DbmModel<?> model, boolean includeSurrogates) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/dbm/common/DbmUtil", "describe"));
        }
        CodeTextBuilder ctb = new CodeTextBuilder();
        ctb.setIndentation("    ");
        DbmUtil.describeRecursively(ctb, model.roots(), includeSurrogates);
        return ctb.getText();
    }

    public static void describeRecursively(@NotNull CodeTextBuilder ctb, @NotNull DbmNode node, boolean includeSurrogates) {
        if (ctb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ctb", "com/intellij/dbm/common/DbmUtil", "describeRecursively"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/dbm/common/DbmUtil", "describeRecursively"));
        }
        if (node instanceof DbmObject) {
            DbmObject object = (DbmObject)node;
            DbmUtil.describeObjectRecursively(ctb, object, includeSurrogates);
        } else if (node instanceof Family) {
            Collection<? extends DbmNode> innerNodes = node.childNodes();
            for (DbmNode dbmNode : innerNodes) {
                DbmUtil.describeRecursively(ctb, dbmNode, includeSurrogates);
            }
        } else if (node instanceof DbmElement) {
            DbmUtil.describeElement(ctb, (DbmElement)((Object)node), includeSurrogates);
        } else {
            ctb.addText(node.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void describeObjectRecursively(@NotNull CodeTextBuilder ctb, @NotNull DbmObject object, boolean includeSurrogates) {
        if (ctb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ctb", "com/intellij/dbm/common/DbmUtil", "describeObjectRecursively"));
        }
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/dbm/common/DbmUtil", "describeObjectRecursively"));
        }
        DbmUtil.describeElement(ctb, object, includeSurrogates);
        String comment = object.getComment();
        if (comment != null && comment.length() > 0) {
            ctb.indent();
            try {
                String[] commentLines = comment.split("\n");
                for (String commentLine : commentLines) {
                    ctb.addText("--  " + commentLine);
                }
            }
            finally {
                ctb.unindent();
            }
        }
        ctb.indent();
        try {
            for (Family family : object.families()) {
                ArrayList children = new ArrayList(family);
                if (!includeSurrogates) {
                    for (int i = children.size() - 1; i >= 0; --i) {
                        DbmObject child = (DbmObject)children.get(i);
                        if (!child.isObjectSurrogate()) continue;
                        children.remove(i);
                    }
                }
                if (children.isEmpty()) continue;
                String sectionLine = "+ " + DbmUtil.pluralize(family.getChildKind().code());
                ctb.addText(sectionLine);
                ctb.indent();
                try {
                    for (DbmObject child : children) {
                        DbmUtil.describeObjectRecursively(ctb, child, includeSurrogates);
                    }
                }
                finally {
                    ctb.unindent();
                }
            }
        }
        finally {
            ctb.unindent();
        }
        List<DbmRef<DbmObject>> intDeps = object.internalDependencies().getAllRefs();
        if (!intDeps.isEmpty()) {
            ctb.indent();
            ctb.addText("+ dependencies");
            ctb.indent();
            try {
                for (DbmRef dep : intDeps) {
                    RelativeReference targetPath = dep.getRelativeReference();
                    if (targetPath == null) continue;
                    String targetStr = targetPath.toString();
                    Object target = dep.getResolvedObject();
                    if (target != null) {
                        targetStr = targetStr + ": " + ((DbmObject)target).kind();
                    }
                    ctb.addText(targetStr);
                }
            }
            finally {
                ctb.unindent();
                ctb.unindent();
            }
        }
    }

    private static void describeElement(@NotNull CodeTextBuilder ctb, @NotNull DbmElement element, boolean includeSurrogates) {
        if (ctb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ctb", "com/intellij/dbm/common/DbmUtil", "describeElement"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/dbm/common/DbmUtil", "describeElement"));
        }
        String id = element.identity(includeSurrogates);
        String desc = element.description(includeSurrogates);
        String elementLine = id + ":  " + desc;
        ctb.addText(elementLine);
    }

    private static String pluralize(String noun) {
        if (noun.equals("index")) {
            return "indices";
        }
        return StringUtil.pluralize((String)noun);
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static <T> List<T> freezeList(List<T> list) {
        if (list == null) {
            return null;
        }
        int n = list.size();
        switch (n) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (list instanceof ImmutableList) {
            return list;
        }
        return ImmutableList.copyOf(list);
    }

    public static JBTreeTraverser<DbmObject> dbmTraverser() {
        return DBM_TRAVERSER;
    }

    @Contract(value="null->null", pure=true)
    public static DbmObject getModelObjectOf(@Nullable DasObject dasObject) {
        Object x = dasObject;
        while (x != null) {
            if (x instanceof DbmObject) {
                return (DbmObject)x;
            }
            if (x instanceof DbElement) {
                x = ((DbElement)x).getDelegate();
                continue;
            }
            return null;
        }
        return null;
    }

    @Contract(value="!null->!null; null->null")
    public static String humanizeEnumName(String enumName) {
        return enumName != null ? enumName.toLowerCase(Locale.ROOT).replace('_', ' ') : null;
    }
}

