/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.intellij.dbm.common.IntrospectionScope;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public abstract class IntrospectionScopes {
    static final IntrospectionScope SCOPE_OF_CURRENT = new IntrospectionScope.SingleDBScope("@", (ImmutableSet<String>)ImmutableSet.of((Object)"@"), false);
    static final IntrospectionScope SCOPE_OF_NOTHING = new IntrospectionScope.EmptyScope();
    static final IntrospectionScope SCOPE_OF_ALL = new IntrospectionScope.AllScope();

    @NotNull
    public static IntrospectionScope scopeOf(@NotNull String database, @NotNull Collection<String> schemas) {
        if (database == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "database", "com/intellij/dbm/common/IntrospectionScopes", "scopeOf"));
        }
        if (schemas == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemas", "com/intellij/dbm/common/IntrospectionScopes", "scopeOf"));
        }
        boolean resolved = !IntrospectionScope.isWildcard(database) && !IntrospectionScope.containsWildcards(schemas);
        IntrospectionScope.SingleDBScope singleDBScope = new IntrospectionScope.SingleDBScope(database, (ImmutableSet<String>)ImmutableSet.copyOf(schemas), resolved);
        if (singleDBScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScopes", "scopeOf"));
        }
        return singleDBScope;
    }

    @NotNull
    public static IntrospectionScope scopeOf(@NotNull String database, @NotNull String schema) {
        boolean resolved;
        if (database == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "database", "com/intellij/dbm/common/IntrospectionScopes", "scopeOf"));
        }
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/common/IntrospectionScopes", "scopeOf"));
        }
        boolean bl = resolved = !IntrospectionScope.isWildcard(database) && !IntrospectionScope.isWildcard(schema);
        if (!resolved) {
            if (database.equals("@") && schema.equals("@")) {
                IntrospectionScope introspectionScope = IntrospectionScopes.scopeOfCurrent();
                if (introspectionScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScopes", "scopeOf"));
                }
                return introspectionScope;
            }
            if (database.equals("*") && schema.equals("*")) {
                IntrospectionScope introspectionScope = IntrospectionScopes.scopeOfAll();
                if (introspectionScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScopes", "scopeOf"));
                }
                return introspectionScope;
            }
        }
        IntrospectionScope.SingleDBScope singleDBScope = new IntrospectionScope.SingleDBScope(database, (ImmutableSet<String>)ImmutableSet.of((Object)schema), resolved);
        if (singleDBScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScopes", "scopeOf"));
        }
        return singleDBScope;
    }

    @NotNull
    public static IntrospectionScope scopeOf(@NotNull ImmutableMap<String, ImmutableSet<String>> databasesAndSchemas) {
        if (databasesAndSchemas == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databasesAndSchemas", "com/intellij/dbm/common/IntrospectionScopes", "scopeOf"));
        }
        boolean resolved = IntrospectionScope.containsWildcards((Collection<String>)databasesAndSchemas.keySet());
        if (resolved) {
            for (ImmutableSet schemas : databasesAndSchemas.values()) {
                if (!IntrospectionScope.containsWildcards((Collection<String>)schemas)) continue;
                resolved = false;
                break;
            }
        }
        IntrospectionScope.MultiDBScope multiDBScope = new IntrospectionScope.MultiDBScope(databasesAndSchemas, resolved);
        if (multiDBScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScopes", "scopeOf"));
        }
        return multiDBScope;
    }

    @NotNull
    public static IntrospectionScope scopeOf(MultiMap<String, String> databasesAndSchemas) {
        Set databases = databasesAndSchemas.keySet();
        if (databases.size() == 1) {
            String database = (String)databases.iterator().next();
            Collection schemas = databasesAndSchemas.get((Object)database);
            if (database.equals("*") && schemas.contains("*")) {
                IntrospectionScope introspectionScope = IntrospectionScopes.scopeOfAll();
                if (introspectionScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScopes", "scopeOf"));
                }
                return introspectionScope;
            }
            boolean resolved = !IntrospectionScope.isWildcard(database) && !IntrospectionScope.containsWildcards(schemas);
            IntrospectionScope.SingleDBScope singleDBScope = new IntrospectionScope.SingleDBScope(database, (ImmutableSet<String>)ImmutableSet.copyOf((Collection)schemas), resolved);
            if (singleDBScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScopes", "scopeOf"));
            }
            return singleDBScope;
        }
        boolean resolved = true;
        ImmutableMap.Builder b = ImmutableMap.builder();
        for (String database : databases) {
            Collection schemas = databasesAndSchemas.get((Object)database);
            b.put((Object)database, (Object)ImmutableSet.copyOf((Collection)schemas));
            if (resolved && IntrospectionScope.isWildcard(database)) {
                resolved = false;
            }
            if (!resolved || !IntrospectionScope.containsWildcards(schemas)) continue;
            resolved = false;
        }
        IntrospectionScope.MultiDBScope multiDBScope = new IntrospectionScope.MultiDBScope((ImmutableMap<String, ImmutableSet<String>>)b.build(), resolved);
        if (multiDBScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScopes", "scopeOf"));
        }
        return multiDBScope;
    }

    @NotNull
    @Contract(pure=true)
    public static IntrospectionScope scopeOfCurrent() {
        IntrospectionScope introspectionScope = SCOPE_OF_CURRENT;
        if (introspectionScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScopes", "scopeOfCurrent"));
        }
        return introspectionScope;
    }

    @NotNull
    @Contract(pure=true)
    public static IntrospectionScope scopeOfNothing() {
        IntrospectionScope introspectionScope = SCOPE_OF_NOTHING;
        if (introspectionScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScopes", "scopeOfNothing"));
        }
        return introspectionScope;
    }

    @NotNull
    @Contract(pure=true)
    public static IntrospectionScope scopeOfAll() {
        IntrospectionScope introspectionScope = SCOPE_OF_ALL;
        if (introspectionScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScopes", "scopeOfAll"));
        }
        return introspectionScope;
    }

    @NotNull
    @Contract(pure=true)
    public static IntrospectionScope importScope(@NotNull String string) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/dbm/common/IntrospectionScopes", "importScope"));
        }
        if (string.isEmpty()) {
            IntrospectionScope introspectionScope = SCOPE_OF_NOTHING;
            if (introspectionScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScopes", "importScope"));
            }
            return introspectionScope;
        }
        if (string.equals("@") || string.equals("@->@")) {
            IntrospectionScope introspectionScope = SCOPE_OF_CURRENT;
            if (introspectionScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScopes", "importScope"));
            }
            return introspectionScope;
        }
        if (string.equals("*") || string.equals("*->*")) {
            IntrospectionScope introspectionScope = SCOPE_OF_ALL;
            if (introspectionScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScopes", "importScope"));
            }
            return introspectionScope;
        }
        IntrospectionScope introspectionScope = IntrospectionScope.importState(string);
        if (introspectionScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScopes", "importScope"));
        }
        return introspectionScope;
    }
}

