/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.oracle;

import com.intellij.dbm.common.DbmSchema;
import com.intellij.dbm.common.DbmSequence;
import com.intellij.dbm.common.StateProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OraSequence
extends DbmSequence {
    @StateProperty
    public boolean myOrdered;
    @StateProperty
    @Nullable
    public Integer myCacheSize;

    public OraSequence(@NotNull DbmSchema schema, @Nullable String name) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/oracle/OraSequence", "<init>"));
        }
        super(schema, name);
    }

    @Override
    protected void descriptionRest(StringBuilder b) {
        if (this.myOrdered) {
            b.append("ordered ");
        }
        if (this.myCacheSize != null) {
            if (this.myCacheSize > 0) {
                b.append("cache ").append(this.myCacheSize).append(' ');
            }
            if (this.myCacheSize < 0) {
                b.append("nocache");
            }
        }
    }

    public boolean isOrdered() {
        return this.myOrdered;
    }

    public void setOrdered(boolean ordered) {
        this.myOrdered = ordered;
    }

    @Nullable
    public Integer getCacheSize() {
        return this.myCacheSize;
    }

    public void setCacheSize(@Nullable Integer cacheSize) {
        this.myCacheSize = cacheSize;
    }
}

