/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.postgres;

import com.intellij.dbm.common.DbmLikeTable;
import com.intellij.dbm.common.DbmTrigger;
import com.intellij.dbm.common.DbmUtil;
import com.intellij.dbm.common.StateProperty;
import com.intellij.dbm.common.TrigTurn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PostgresRuleOrTrigger
extends DbmTrigger {
    @StateProperty
    @Nullable
    public SubKind mySubKind;
    @StateProperty
    @NotNull
    public FireMode myFireMode;

    public PostgresRuleOrTrigger(@NotNull DbmLikeTable table, @Nullable String name) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/dbm/postgres/PostgresRuleOrTrigger", "<init>"));
        }
        super(table, name);
        this.myFireMode = FireMode.ORIGIN;
    }

    @Nullable
    public SubKind getSubKind() {
        return this.mySubKind;
    }

    public void setSubKind(@Nullable SubKind subKind) {
        if (this.mySubKind == subKind) {
            return;
        }
        this.modifying();
        this.mySubKind = subKind;
    }

    @NotNull
    public FireMode getFireMode() {
        FireMode fireMode = this.myFireMode;
        if (fireMode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/postgres/PostgresRuleOrTrigger", "getFireMode"));
        }
        return fireMode;
    }

    public void setFireMode(@NotNull FireMode fireMode) {
        if (fireMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fireMode", "com/intellij/dbm/postgres/PostgresRuleOrTrigger", "setFireMode"));
        }
        if (this.myFireMode == fireMode) {
            return;
        }
        this.modifying();
        this.myFireMode = fireMode;
    }

    @Override
    @NotNull
    public String description(boolean includeSurrogates) {
        StringBuilder b = new StringBuilder(60);
        SubKind subKind = this.mySubKind;
        if (subKind != null) {
            switch (subKind) {
                case RULE: {
                    b.append("rule");
                    TrigTurn turn = this.getTrigTurn();
                    if (turn != null) {
                        b.append(' ').append(DbmUtil.humanizeEnumName(turn.name()));
                    }
                    if (this.trigEvents.isNotEmpty()) {
                        b.append(" on ").append(this.trigEvents.toString());
                    }
                    FireMode fireMode = this.getFireMode();
                    if (fireMode.byDefault) break;
                    b.append(" fire ").append(DbmUtil.humanizeEnumName(fireMode.name()));
                    break;
                }
                case TRIGGER: {
                    b.append("trigger");
                    break;
                }
                default: {
                    b.append("???");
                }
            }
        }
        String string = b.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/postgres/PostgresRuleOrTrigger", "description"));
        }
        return string;
    }

    public static enum FireMode {
        ORIGIN('O', true),
        REPLICA('R', false),
        DISABLED('D', false),
        ALWAYS('A', false);

        public final char code;
        public final boolean byDefault;

        private FireMode(char code, boolean byDefault) {
            this.code = code;
            this.byDefault = byDefault;
        }

        public static FireMode of(char code) {
            switch (Character.toUpperCase(code)) {
                case 'O': {
                    return ORIGIN;
                }
                case 'R': {
                    return REPLICA;
                }
                case 'D': {
                    return DISABLED;
                }
                case 'A': {
                    return ALWAYS;
                }
            }
            return null;
        }
    }

    public static enum SubKind {
        RULE('R'),
        TRIGGER('T');

        public final char code;

        private SubKind(char code) {
            this.code = code;
        }

        @Nullable
        public static SubKind of(char code) {
            switch (code) {
                case 'R': 
                case 'r': {
                    return RULE;
                }
                case 'T': 
                case 't': {
                    return TRIGGER;
                }
            }
            return null;
        }
    }
}

