/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.serialization;

import com.intellij.database.model.DasModel;
import com.intellij.database.model.ModelSerializer;
import com.intellij.dbm.common.DbmModel;
import com.intellij.dbm.serialization.DbmExporter;
import com.intellij.dbm.serialization.DbmImporter;
import com.intellij.dbm.serialization.DbmModelMem;
import com.intellij.dbm.serialization.ImportException;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.jetbrains.annotations.NotNull;

public class DbmSerializer
implements ModelSerializer {
    private final DbmExporter myExporter = new DbmExporter();
    private final DbmImporter myImporter = new DbmImporter();

    @NotNull
    public DbmModel deserialize(@NotNull HierarchicalStreamReader reader) throws ImportException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/dbm/serialization/DbmSerializer", "deserialize"));
        }
        DbmModelMem modelMem = this.myImporter.deserializeModel(reader);
        DbmModel dbmModel = this.myImporter.buildModel(modelMem);
        if (dbmModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/serialization/DbmSerializer", "deserialize"));
        }
        return dbmModel;
    }

    public boolean canSerialize(DasModel model) {
        return model instanceof DbmModel;
    }

    public void serialize(@NotNull DasModel model, @NotNull HierarchicalStreamWriter writer) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/dbm/serialization/DbmSerializer", "serialize"));
        }
        if (writer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writer", "com/intellij/dbm/serialization/DbmSerializer", "serialize"));
        }
        this.myExporter.writeModel((DbmModel)model, writer);
    }
}

