/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.sybase;

import com.google.common.collect.ImmutableList;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DataType;
import com.intellij.database.model.DataTypeFactory;
import com.intellij.database.model.LengthUnit;
import com.intellij.dbm.common.BaseIntrospector;
import com.intellij.dbm.common.DbmArgument;
import com.intellij.dbm.common.DbmCheck;
import com.intellij.dbm.common.DbmColumn;
import com.intellij.dbm.common.DbmDatabase;
import com.intellij.dbm.common.DbmForeignKey;
import com.intellij.dbm.common.DbmIndex;
import com.intellij.dbm.common.DbmKey;
import com.intellij.dbm.common.DbmLikeColumn;
import com.intellij.dbm.common.DbmLikeTable;
import com.intellij.dbm.common.DbmMajor;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.DbmPositionedIndex;
import com.intellij.dbm.common.DbmRoutine;
import com.intellij.dbm.common.DbmSchema;
import com.intellij.dbm.common.DbmSourceAware;
import com.intellij.dbm.common.DbmTrigger;
import com.intellij.dbm.common.Family;
import com.intellij.dbm.common.MultiDatabaseIntrospector;
import com.intellij.dbm.common.QueryRewriters;
import com.intellij.dbm.common.SequenceIdentity;
import com.intellij.dbm.common.TrigEvent;
import com.intellij.dbm.common.TrigTurn;
import com.intellij.dbm.sybase.SybaseDatabase;
import com.intellij.dbm.sybase.SybaseIntroQueries;
import com.intellij.dbm.sybase.SybaseModel;
import com.intellij.dbm.sybase.SybaseProcedure;
import com.intellij.dbm.sybase.SybaseProcedureGroup;
import com.intellij.dbm.sybase.SybaseSchema;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Predicate;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.core.ConnectionInfo;
import org.jetbrains.dekaf.core.DBFacade;
import org.jetbrains.dekaf.core.DBTransaction;
import org.jetbrains.dekaf.util.StringOperator;
import org.jetbrains.dekaf.util.Strings;

public class SybaseIntrospector
extends MultiDatabaseIntrospector<SybaseDatabase, SybaseSchema, SybaseModel> {
    private final SybaseIntroQueries myQueries;
    private static final Logger LOG = Logger.getInstance(MultiDatabaseIntrospector.class);
    private static final short COLUMN_BITS1_IDENTITY = 128;
    private static final short COLUMN_BITS1_NULLABLE = 8;
    private static final short COLUMN_BITS2_COMPUTED = 16;
    private static final short COLUMN_BITS2_OUTPUT = 2;
    private static final short INDEX_BITS1_PRIMARY = 2048;
    private static final short INDEX_BITS1_CLUSTERED = 16;
    private static final short INDEX_BITS1_UNIQUE = 2;
    private static final short INDEX_BITS2_NAME_SURROGATE = 8;
    private static final short INDEX_BITS2_KEY = 2;
    private static final Set<String> EXACT_LENGTH_TYPES = ContainerUtil.immutableSet((Object[])new String[]{"char", "binary", "float", "numeric", "nchar", "decimal"});
    private static final SequenceIdentity ourSybaseIdentity = SequenceIdentity.of(1L, null, 1L, null);

    public SybaseIntrospector(@NotNull DBFacade facade) {
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "com/intellij/dbm/sybase/SybaseIntrospector", "<init>"));
        }
        super(facade);
        this.myQueries = SybaseIntroQueries.QUERIES;
    }

    @Override
    @NotNull
    protected SybaseModel createNewModel() {
        SybaseModel sybaseModel = new SybaseModel();
        if (sybaseModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/sybase/SybaseIntrospector", "createNewModel"));
        }
        return sybaseModel;
    }

    @Override
    @NotNull
    protected BaseIntrospector.SchemaRetriever createRetriever(SybaseSchema schema) {
        SybaseSchemaRetriever sybaseSchemaRetriever = new SybaseSchemaRetriever(schema);
        if (sybaseSchemaRetriever == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/sybase/SybaseIntrospector", "createRetriever"));
        }
        return sybaseSchemaRetriever;
    }

    @Override
    protected void retrieveSessionBriefInfo(DBTransaction tran) {
        super.retrieveSessionBriefInfo(tran);
        ConnectionInfo info = this.myFacade.getConnectionInfo();
        if (info.databaseName != null) {
            SybaseDatabase database = (SybaseDatabase)((SybaseModel)this.myModel).databases().getOrCreate(info.databaseName);
            ((SybaseModel)this.myModel).setCurrentDatabase(database);
            if (info.schemaName != null) {
                SybaseSchema schema = database.schemas().getOrCreate(info.schemaName);
                database.setCurrentSchema(schema);
            }
        }
    }

    @NotNull
    protected List<String> listAccessibleDatabases(@NotNull DBTransaction tran) {
        if (tran == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/sybase/SybaseIntrospector", "listAccessibleDatabases"));
        }
        List list = (List)tran.query(this.myQueries.listDatabaseNames).run();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/sybase/SybaseIntrospector", "listAccessibleDatabases"));
        }
        return list;
    }

    @Override
    protected Map<Integer, String> listAccessibleSchemasOfDatabase(@NotNull DBTransaction tran, DbmDatabase database) {
        if (tran == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/sybase/SybaseIntrospector", "listAccessibleSchemasOfDatabase"));
        }
        String catalogPrefix = '[' + database.getName() + "].dbo";
        return (Map)tran.query(this.myQueries.retrieveSchemas.rewrite(QueryRewriters.substitute("#CAT", catalogPrefix))).run();
    }

    @Override
    protected boolean isPossibleToIntrospectSchemaIncrementally(@NotNull SybaseSchema schema) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/sybase/SybaseIntrospector", "isPossibleToIntrospectSchemaIncrementally"));
        }
        return false;
    }

    private static boolean detectSurrogateName(@Nullable String name, int id) {
        if (name == null) {
            return false;
        }
        String idStr = '_' + Integer.toString(id);
        return name.length() > idStr.length() && name.endsWith(idStr);
    }

    private static int fixFloatPrecision(String type_name, int length) {
        if ("float".equals(type_name)) {
            if (length == 8) {
                return 22;
            }
            if (length == 4) {
                return 15;
            }
        }
        return length;
    }

    @Nullable
    private static DataType makeDataType(String type_name, int length, short precision, short scale, boolean variable) {
        DataType dt;
        LengthUnit u;
        short s;
        int p;
        if (type_name == null) {
            return null;
        }
        if (length == 0 && precision == 0 || !variable && !EXACT_LENGTH_TYPES.contains(type_name)) {
            p = -1;
            s = 0;
            u = LengthUnit.NONE;
        } else if (precision > 0) {
            p = precision;
            s = scale;
            u = LengthUnit.DIGIT;
        } else {
            p = SybaseIntrospector.fixFloatPrecision(type_name, length);
            s = 0;
            u = length > 0 ? LengthUnit.BYTE : LengthUnit.NONE;
        }
        try {
            dt = DataTypeFactory.of(null, type_name, p, s, u, null, false, false);
        }
        catch (Exception e) {
            LOG.warn(String.format("Failed to handle data type %s with length %d precision %d scale %d", type_name, length, precision, scale));
            dt = null;
        }
        return dt;
    }

    static short peek16(byte[] array, int offset) {
        byte b1 = array[offset];
        byte b2 = array[offset + 1];
        return (short)(((short)b2 & 0xFF) << 8 | (short)b1 & 0xFF);
    }

    private static void assignForeignKeyColumns(@NotNull DbmForeignKey foreignKey, @NotNull short[] columnPositions) {
        if (foreignKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foreignKey", "com/intellij/dbm/sybase/SybaseIntrospector", "assignForeignKeyColumns"));
        }
        if (columnPositions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnPositions", "com/intellij/dbm/sybase/SybaseIntrospector", "assignForeignKeyColumns"));
        }
        DasTable table = foreignKey.getTable();
        int n = columnPositions.length;
        ArrayList<DbmColumn> columns = new ArrayList<DbmColumn>(n);
        for (int i = 0; i < n; ++i) {
            DbmColumn column = table.columns().getByNaturalPosition(columnPositions[i]);
            if (column == null) continue;
            columns.add(column);
        }
        foreignKey.myColumns.setObjects(columns);
    }

    private final class SybaseSchemaRetriever
    extends BaseIntrospector.SchemaRetriever {
        private final int schemaId;
        private final Collection<DbmLikeTable> myTouchedTables;
        private final Collection<DbmRoutine> myTouchedRoutines;
        private final StringOperator rewriter;
        private boolean wasProcedures;

        public SybaseSchemaRetriever(SybaseSchema schema) {
            super((BaseIntrospector)SybaseIntrospector.this, (DbmSchema)schema);
            this.myTouchedTables = new ArrayList<DbmLikeTable>();
            this.myTouchedRoutines = new ArrayList<DbmRoutine>();
            this.wasProcedures = false;
            this.schemaId = (int)schema.myObjectId;
            String catalogPrefix = '[' + schema.database().getName() + "].dbo";
            this.rewriter = QueryRewriters.substitute("#CAT", catalogPrefix);
        }

        @Override
        protected void analyzeBriefInfo(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/sybase/SybaseIntrospector$SybaseSchemaRetriever", "analyzeBriefInfo"));
            }
            this.introspectionBeginTimestamp = (Timestamp)tran.query(((SybaseIntrospector)SybaseIntrospector.this).myQueries.now).run();
        }

        @Override
        protected void analyzeCurrentContent(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/sybase/SybaseIntrospector$SybaseSchemaRetriever", "analyzeCurrentContent"));
            }
            this.progress("determining dropped objects");
        }

        @Override
        protected void retrieveMajorNames(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/sybase/SybaseIntrospector$SybaseSchemaRetriever", "retrieveMajorNames"));
            }
            this.progress("listing major objects");
            List ms = (List)tran.query(((SybaseIntrospector)SybaseIntrospector.this).myQueries.retrieveMajorNames.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId}).run();
            block6: for (SybaseIntroQueries.OneMajorName m : ms) {
                Family<DbmMajor> family;
                switch (m.type) {
                    case 'S': 
                    case 'U': {
                        family = ((SybaseSchema)this.schema).tables();
                        break;
                    }
                    case 'V': {
                        family = ((SybaseSchema)this.schema).views();
                        break;
                    }
                    case 'F': {
                        family = ((SybaseSchema)this.schema).routines();
                        break;
                    }
                    case 'P': {
                        family = ((SybaseSchema)this.schema).procedureGroups();
                        this.wasProcedures = true;
                        break;
                    }
                    default: {
                        continue block6;
                    }
                }
                DbmMajor object = family.renew(m.id, m.name);
                object.setStateNumber(m.state_nr);
            }
            ((SybaseSchema)this.schema).tables().reorder();
            ((SybaseSchema)this.schema).views().reorder();
            ((SybaseSchema)this.schema).routines().reorder();
            ((SybaseSchema)this.schema).procedureGroups().reorder();
        }

        @Override
        protected void retrieveMainContent(final @NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/sybase/SybaseIntrospector$SybaseSchemaRetriever", "retrieveMainContent"));
            }
            this.work(new Runnable(){

                @Override
                public void run() {
                    SybaseSchemaRetriever.this.retrieveProcedures(tran);
                }
            });
            this.work(new Runnable(){

                @Override
                public void run() {
                    SybaseSchemaRetriever.this.retrieveColumnsAndArguments(tran);
                }
            });
            this.work(new Runnable(){

                @Override
                public void run() {
                    SybaseSchemaRetriever.this.retrieveDefaults(tran);
                }
            });
            this.work(new Runnable(){

                @Override
                public void run() {
                    SybaseSchemaRetriever.this.retrieveIndicesAndKeys(tran);
                }
            });
            this.work(new Runnable(){

                @Override
                public void run() {
                    SybaseSchemaRetriever.this.retrieveForeignKeys(tran);
                    SybaseSchemaRetriever.this.retrieveCheckConstraints(tran);
                }
            });
            this.work(new Runnable(){

                @Override
                public void run() {
                    SybaseSchemaRetriever.this.retrieveTriggers(tran);
                }
            });
            if (((SybaseIntrospector)SybaseIntrospector.this).myOptions.withSources) {
                this.work(new Runnable(){

                    @Override
                    public void run() {
                        SybaseSchemaRetriever.this.retrieveSources(tran);
                    }
                });
            }
            this.finishSchema();
        }

        private void retrieveProcedures(DBTransaction tran) {
            if (!this.wasProcedures) {
                return;
            }
            this.progress("retrieving procedure overloads");
            List ps = (List)tran.query(((SybaseIntrospector)SybaseIntrospector.this).myQueries.retrieveProcedures.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId}).run();
            if (ps.isEmpty()) {
                return;
            }
            HashSet<SybaseProcedureGroup> touchedGroups = new HashSet<SybaseProcedureGroup>(ps.size());
            for (SybaseIntroQueries.OneProcedure p : ps) {
                SybaseProcedureGroup group = ((SybaseSchema)this.schema).getObjectById(SybaseProcedureGroup.class, p.id);
                if (group == null) continue;
                group.getOrCreateOverload(p.procedure_position);
                touchedGroups.add(group);
            }
            for (SybaseProcedureGroup group : touchedGroups) {
                group.procedures().reorder();
            }
        }

        private void retrieveColumnsAndArguments(DBTransaction tran) {
            this.progress("retrieving columns and arguments");
            List cas = (List)tran.query(((SybaseIntrospector)SybaseIntrospector.this).myQueries.retrieveColumnsAndArguments.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId}).run();
            HashSet<DbmObject> touchedObjects = new HashSet<DbmObject>(cas.size() / 4);
            DbmObject object = null;
            int objectId = Integer.MIN_VALUE;
            for (SybaseIntroQueries.OneColumnOrArgument ca : cas) {
                if (object == null || objectId != ca.id) {
                    object = ((SybaseSchema)this.schema).database().getObjectById(ca.id);
                    objectId = ca.id;
                    if (object == null) continue;
                    touchedObjects.add(object);
                }
                DataType dt = SybaseIntrospector.makeDataType(ca.type_name, ca.length, ca.prec, ca.scale, ca.variable);
                if (object instanceof DbmLikeTable) {
                    DbmColumn column = ((DbmLikeTable)object).columns().getOrCreate(ca.name);
                    column.setPosition(ca.colid);
                    column.setDataType(dt);
                    column.setMandatory((ca.bits1 & 8) == 0);
                    column.setComputed((ca.bits2 & 0x10) != 0);
                    column.setSequenceIdentity((ca.bits1 & 0x80) != 0 ? ourSybaseIdentity : null);
                }
                if (object instanceof DbmRoutine) {
                    DbmRoutine function = (DbmRoutine)((Object)object);
                    this.addRoutineArgument(function, ca, dt);
                }
                if (!(object instanceof SybaseProcedureGroup)) continue;
                SybaseProcedureGroup group = (SybaseProcedureGroup)object;
                SybaseProcedure procedure = group.getOrCreateOverload(ca.procedure_position);
                this.addRoutineArgument(procedure, ca, dt);
                touchedObjects.add(procedure);
            }
            for (DbmObject obj : touchedObjects) {
                if (obj instanceof DbmLikeTable) {
                    ((DbmLikeTable)obj).columns().reorder();
                }
                if (obj instanceof DbmRoutine) {
                    ((DbmRoutine)((Object)obj)).arguments().reorder();
                }
                if (!(obj instanceof SybaseProcedureGroup)) continue;
                ((SybaseProcedureGroup)obj).procedures().reorder();
            }
        }

        private void addRoutineArgument(@NotNull DbmRoutine routine, @NotNull SybaseIntroQueries.OneColumnOrArgument ca, @Nullable DataType dt) {
            if (routine == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "routine", "com/intellij/dbm/sybase/SybaseIntrospector$SybaseSchemaRetriever", "addRoutineArgument"));
            }
            if (ca == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ca", "com/intellij/dbm/sybase/SybaseIntrospector$SybaseSchemaRetriever", "addRoutineArgument"));
            }
            boolean out = (ca.bits2 & 2) != 0;
            boolean result = out && Strings.eq((String)ca.name, (String)"Return Type", (boolean)false);
            DbmArgument argument = result ? routine.getOrCreateReturnArgument() : routine.arguments().getOrCreate(ca.name);
            argument.setPosition(ca.colid);
            argument.setDataType(dt);
            if (!result) {
                argument.setDirection(out ? DasArgument.Direction.OUT : DasArgument.Direction.IN);
            }
        }

        private void retrieveIndicesAndKeys(DBTransaction tran) {
            if (((SybaseSchema)this.schema).tables().isEmpty()) {
                return;
            }
            this.progress("retrieving indices");
            List inds = (List)tran.query(((SybaseIntrospector)SybaseIntrospector.this).myQueries.retrieveIndices.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId}).run();
            if (inds.isEmpty()) {
                return;
            }
            HashSet<DbmLikeTable> touchedTables = new HashSet<DbmLikeTable>(inds.size());
            DbmLikeTable table = null;
            int tableId = Integer.MIN_VALUE;
            for (SybaseIntroQueries.OneIndex ind : inds) {
                if (table == null || tableId != ind.id) {
                    DbmObject object = ((SybaseSchema)this.schema).database().getObjectById(ind.id);
                    if (object == null || !(object instanceof DbmLikeTable)) continue;
                    table = (DbmLikeTable)object;
                    tableId = ind.id;
                    touchedTables.add(table);
                }
                DbmPositionedIndex index = (DbmPositionedIndex)table.indices().getOrCreate(ind.name);
                index.setPosition(ind.position);
                index.setNameSurrogate((ind.bits2 & 8) != 0);
                index.setClustering((ind.bits1 & 0x10) != 0);
                index.setUnique((ind.bits1 & 2) != 0);
                if (ind.keys1 != null) {
                    byte[] keys;
                    byte[] keys1 = (byte[])ind.keys1;
                    if (ind.keys2 == null) {
                        keys = keys1;
                    } else {
                        byte[] keys2 = (byte[])ind.keys2;
                        keys = new byte[keys1.length + keys2.length];
                        System.arraycopy(keys1, 0, keys, 0, keys1.length);
                        System.arraycopy(keys2, 0, keys, keys1.length, keys2.length);
                    }
                    this.peekIndexColumns(index, keys);
                }
                if ((ind.bits2 & 2) == 0) continue;
                DbmKey key = table.keys().getOrCreate(ind.name);
                key.setNameSurrogate(index.isNameSurrogate());
                key.myUnderlyingIndex.set(index);
                key.setPrimary((ind.bits1 & 0x800) != 0);
                key.myColumns.setNames(index.myColumns.names());
            }
            for (DbmLikeTable touchedTable : touchedTables) {
                touchedTable.indices().reorder();
            }
        }

        private void peekIndexColumns(DbmIndex index, byte[] keys) {
            short[] positions = this.peekColumnPositions(keys);
            ImmutableList.Builder names = ImmutableList.builder();
            for (final short position : positions) {
                if (position == 0) break;
                DbmColumn column = index.table.columns().get((Predicate<? extends DbmColumn>)new Predicate<DbmColumn>(){

                    public boolean apply(DbmColumn column) {
                        return column.getPosition() == position;
                    }
                });
                if (column == null) continue;
                names.add((Object)column.getNameOrEmpty());
            }
            index.myColumns.setNames((Collection<String>)names.build());
        }

        private short[] peekColumnPositions(byte[] keys) {
            int n = (keys.length + 7) / 16;
            short[] positions = new short[n];
            for (int i = 0; i < n; i = (int)((short)(i + 1))) {
                short position;
                int offset = i << 4 | 4;
                positions[i] = position = SybaseIntrospector.peek16(keys, offset);
                if (position == 0) break;
            }
            return positions;
        }

        private void retrieveForeignKeys(DBTransaction tran) {
            short[] columnPositions;
            int n;
            if (((SybaseSchema)this.schema).tables().isEmpty()) {
                return;
            }
            this.progress("retrieving foreign keys");
            List fks = (List)tran.query(((SybaseIntrospector)SybaseIntrospector.this).myQueries.retrieveForeignKeys.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId}).run();
            if (fks.isEmpty()) {
                return;
            }
            HashSet<DbmLikeTable> touchedTables = new HashSet<DbmLikeTable>(fks.size());
            boolean wides = false;
            for (Object fk : fks) {
                DbmLikeTable table = ((SybaseSchema)this.schema).database().getObjectById(DbmLikeTable.class, ((SybaseIntroQueries.OneForeignKey)fk).source_table_id);
                if (table == null) continue;
                DbmForeignKey foreignKey = table.foreignKeys().renew(((SybaseIntroQueries.OneForeignKey)fk).source_constraint_id, ((SybaseIntroQueries.OneForeignKey)fk).source_constraint_name);
                foreignKey.setNameSurrogate(SybaseIntrospector.detectSurrogateName(((SybaseIntroQueries.OneForeignKey)fk).source_constraint_name, ((SybaseIntroQueries.OneForeignKey)fk).source_constraint_id));
                touchedTables.add(table);
                DbmLikeTable targetTable = ((SybaseSchema)this.schema).database().getObjectById(DbmLikeTable.class, ((SybaseIntroQueries.OneForeignKey)fk).target_table_id);
                if (targetTable != null) {
                    DbmKey targetKey = targetTable.keys().get((Predicate<? extends DbmKey>)new Predicate<DbmKey>((SybaseIntroQueries.OneForeignKey)fk){
                        final /* synthetic */ SybaseIntroQueries.OneForeignKey val$fk;
                        {
                            this.val$fk = oneForeignKey;
                        }

                        public boolean apply(DbmKey k) {
                            DbmIndex i = k.myUnderlyingIndex.getObject();
                            return i instanceof DbmPositionedIndex && ((DbmPositionedIndex)i).getPosition() == this.val$fk.target_index_position;
                        }
                    });
                    foreignKey.refKey.set(targetKey);
                }
                if ((n = ((SybaseIntroQueries.OneForeignKey)fk).involved_columns_count) <= 4) {
                    columnPositions = new short[n];
                    if (n >= 1) {
                        columnPositions[0] = ((SybaseIntroQueries.OneForeignKey)fk).column_position_1;
                    }
                    if (n >= 2) {
                        columnPositions[1] = ((SybaseIntroQueries.OneForeignKey)fk).column_position_2;
                    }
                    if (n >= 3) {
                        columnPositions[2] = ((SybaseIntroQueries.OneForeignKey)fk).column_position_3;
                    }
                    if (n >= 4) {
                        columnPositions[3] = ((SybaseIntroQueries.OneForeignKey)fk).column_position_4;
                    }
                    SybaseIntrospector.assignForeignKeyColumns(foreignKey, columnPositions);
                    continue;
                }
                wides = true;
            }
            if (wides) {
                List wfks = (List)tran.query(((SybaseIntrospector)SybaseIntrospector.this).myQueries.retrieveForeignKeysWideColumnLists.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId}).run();
                for (int[] wfk : wfks) {
                    int constraintId = wfk[0];
                    DbmForeignKey foreignKey = ((SybaseSchema)this.schema).database().getObjectById(DbmForeignKey.class, constraintId);
                    if (foreignKey == null) continue;
                    for (n = 0; n < 16 && wfk[n + 1] > 0; ++n) {
                    }
                    columnPositions = new short[n];
                    for (int i = 0; i < n; ++i) {
                        columnPositions[i] = (short)wfk[i + 1];
                    }
                    SybaseIntrospector.assignForeignKeyColumns(foreignKey, columnPositions);
                }
            }
            for (DbmLikeTable table : touchedTables) {
                table.foreignKeys().reorder();
            }
        }

        private void retrieveCheckConstraints(DBTransaction tran) {
            if (((SybaseSchema)this.schema).tables().isEmpty()) {
                return;
            }
            this.progress("retrieving check constraints");
            List cs = (List)tran.query(((SybaseIntrospector)SybaseIntrospector.this).myQueries.retrieveChecks.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId}).run();
            if (cs.isEmpty()) {
                return;
            }
            HashSet<DbmLikeTable> touchedTables = new HashSet<DbmLikeTable>(cs.size());
            for (final SybaseIntroQueries.OneCheck c : cs) {
                DbmLikeTable table = ((SybaseSchema)this.schema).database().getObjectById(DbmLikeTable.class, c.table_id);
                if (table == null) continue;
                DbmCheck check = table.checks().renew(c.constraint_id, c.constraint_name);
                check.setNameSurrogate(SybaseIntrospector.detectSurrogateName(c.constraint_name, c.constraint_id));
                if (c.definition != null) {
                    int p = c.definition.indexOf("CHECK");
                    p = p >= 0 ? p + 5 : 0;
                    String s = c.definition.substring(p).trim();
                    int len = s.length();
                    if (len >= 3 && s.charAt(0) == '(' && s.charAt(len - 1) == ')') {
                        s = s.substring(1, len - 1).trim();
                    }
                    check.setPredicate(s);
                } else {
                    check.setPredicate(null);
                }
                DbmColumn column = c.column_position > 0 ? check.getTable().columns().get((Predicate<? extends DbmColumn>)new Predicate<DbmColumn>(){

                    public boolean apply(DbmColumn column) {
                        return column.getPosition() == c.column_position;
                    }
                }) : null;
                if (column != null) {
                    check.myColumns.setObjects(new DbmLikeColumn[]{column});
                } else {
                    check.myColumns.clearState();
                }
                touchedTables.add(table);
            }
            for (DbmLikeTable table : touchedTables) {
                table.checks().reorder();
            }
        }

        private void retrieveDefaults(DBTransaction tran) {
            this.progress("retrieving defaults");
            List ds = (List)tran.query(((SybaseIntrospector)SybaseIntrospector.this).myQueries.retrieveDefaults.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId}).run();
            DbmObject object = null;
            int objectId = Integer.MIN_VALUE;
            for (final SybaseIntroQueries.OneDefault d : ds) {
                Family<? extends DbmColumn> columns;
                DbmColumn column;
                String def;
                if (object == null || objectId != d.id) {
                    object = ((SybaseSchema)this.schema).database().getObjectById(d.id);
                    objectId = d.id;
                    if (object == null) continue;
                }
                if ((def = d.text.trim()).startsWith("DEFAULT")) {
                    def = def.substring(8).trim();
                } else if (def.startsWith("AS")) {
                    def = def.substring(3).trim();
                }
                if (!(object instanceof DbmLikeTable) || (column = (columns = ((DbmLikeTable)object).columns()).get((Predicate<? extends DbmColumn>)new Predicate<DbmColumn>(){

                    public boolean apply(DbmColumn column) {
                        return column.getPosition() == d.position;
                    }
                })) == null) continue;
                column.setDefaultExpression(def);
            }
        }

        private void retrieveTriggers(DBTransaction tran) {
            if (((SybaseSchema)this.schema).tables().isEmpty() && ((SybaseSchema)this.schema).views().isEmpty()) {
                return;
            }
            this.progress("retrieving triggers");
            List ts = (List)tran.query(((SybaseIntrospector)SybaseIntrospector.this).myQueries.retrieveTriggers.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId, this.schemaId, this.schemaId}).run();
            if (ts.isEmpty()) {
                return;
            }
            HashSet<DbmLikeTable> touchedTables = new HashSet<DbmLikeTable>(ts.size());
            for (SybaseIntroQueries.OneTrigger t : ts) {
                DbmLikeTable table = ((SybaseSchema)this.schema).database().getObjectById(DbmLikeTable.class, t.table_id);
                if (table == null) continue;
                DbmTrigger trigger = table.triggers().renew(t.trig_id, t.trig_name);
                TrigEvent event = TrigEvent.of(t.event_code);
                if (event != null) {
                    trigger.trigEvents.add(event);
                }
                trigger.setTrigTurn(t.turn_code == 'I' ? TrigTurn.INSTEAD_OF : TrigTurn.ALSO);
                touchedTables.add(table);
            }
            for (DbmLikeTable table : touchedTables) {
                table.triggers().reorder();
            }
        }

        private void retrieveSources(DBTransaction tran) {
        }

        private void assignSourceCode(int id, @NotNull String text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/dbm/sybase/SybaseIntrospector$SybaseSchemaRetriever", "assignSourceCode"));
            }
            DbmSourceAware sa = ((SybaseSchema)this.schema).getObjectById(DbmSourceAware.class, id);
            if (sa != null) {
                sa.setSourceText(text);
            }
        }

        private void finishSchema() {
            ((SybaseSchema)this.schema).setIntrospectionActualPoint(0L, this.introspectionBeginTimestamp);
        }

        private void progress(@NotNull String what) {
            if (what == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "what", "com/intellij/dbm/sybase/SybaseIntrospector$SybaseSchemaRetriever", "progress"));
            }
            String mode = this.incremental ? "incrementally" : "completely";
            SybaseIntrospector.this.updateStatus(String.format("Introspecting schema %s (%s)", ((SybaseSchema)this.schema).getName(), mode), what);
        }
    }
}

