/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.sybase;

import com.intellij.database.model.ObjectKind;
import com.intellij.dbm.common.DbmComplex;
import com.intellij.dbm.common.DbmSchema;
import com.intellij.dbm.common.Family;
import com.intellij.dbm.sybase.SybaseProcedure;
import com.intellij.util.containers.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SybaseProcedureGroup
extends DbmComplex {
    final Family<SybaseProcedure> myProcedures;

    public SybaseProcedureGroup(@NotNull DbmSchema schema, @Nullable String name) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/sybase/SybaseProcedureGroup", "<init>"));
        }
        super(schema, name);
        this.myProcedures = Family.of(this, ObjectKind.ROUTINE);
        this.assignFamilies(this.myProcedures);
    }

    @NotNull
    public Family<SybaseProcedure> procedures() {
        Family<SybaseProcedure> family = this.myProcedures;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/sybase/SybaseProcedureGroup", "procedures"));
        }
        return family;
    }

    @Override
    @NotNull
    public ObjectKind kind() {
        ObjectKind objectKind = ObjectKind.PACKAGE;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/sybase/SybaseProcedureGroup", "kind"));
        }
        return objectKind;
    }

    @NotNull
    public SybaseProcedure getOrCreateOverload(final short position) {
        SybaseProcedure procedure = this.myProcedures.get(new Predicate<SybaseProcedure>(){

            public boolean apply(SybaseProcedure p) {
                return p.getPosition() == position;
            }
        });
        if (procedure == null) {
            procedure = this.myProcedures.create(null);
            procedure.setPosition(position);
            procedure.setName(Short.toString(position));
        }
        SybaseProcedure sybaseProcedure = procedure;
        if (sybaseProcedure == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/sybase/SybaseProcedureGroup", "getOrCreateOverload"));
        }
        return sybaseProcedure;
    }
}

