/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerFactoryBase;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlValuesParameterInfoHandler;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlInsertStatement;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlValuesExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlHighlightUsagesFactory
extends HighlightUsagesHandlerFactoryBase {
    @Nullable
    public HighlightUsagesHandlerBase createHighlightUsagesHandler(@NotNull Editor editor, @NotNull PsiFile file, @NotNull PsiElement target) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/sql/SqlHighlightUsagesFactory", "createHighlightUsagesHandler"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/sql/SqlHighlightUsagesFactory", "createHighlightUsagesHandler"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/sql/SqlHighlightUsagesFactory", "createHighlightUsagesHandler"));
        }
        MyValueToColumnHandler element = MyValueToColumnHandler.createForElement(editor, file, target);
        return element != null ? element : MyColumnToValueHandler.createForElement(editor, file, target);
    }

    private static class MyValueToColumnHandler
    extends HighlightUsagesHandlerBase<PsiElement> {
        final PsiElement myTarget;
        final int myIndex;

        private MyValueToColumnHandler(Editor editor, PsiFile file, PsiElement target, int index) {
            super(editor, file);
            this.myTarget = target;
            this.myIndex = index;
        }

        @NotNull
        public List<PsiElement> getTargets() {
            List list = ContainerUtil.newSmartList((Object)this.myTarget);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlHighlightUsagesFactory$MyValueToColumnHandler", "getTargets"));
            }
            return list;
        }

        protected void selectTargets(List<PsiElement> targets, @NotNull Consumer<List<PsiElement>> selectionConsumer) {
            if (selectionConsumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectionConsumer", "com/intellij/sql/SqlHighlightUsagesFactory$MyValueToColumnHandler", "selectTargets"));
            }
            selectionConsumer.consume(targets);
        }

        public void computeUsages(List<PsiElement> targets) {
            PsiElement element;
            SqlDmlInstruction instruction = (SqlDmlInstruction)PsiTreeUtil.getParentOfType((PsiElement)this.myTarget, SqlDmlInstruction.class, (boolean)true);
            if (instruction == null) {
                return;
            }
            int id = this.myIndex;
            SqlTableType targetType = instruction.getTargetType();
            for (int i = 0; i < targetType.getColumnCount(); ++i) {
                PsiElement columnElement;
                if (!StringUtil.isNotEmpty((String)targetType.getColumnType(i).getDisplayName()) || !((columnElement = targetType.getColumnElement(i)) instanceof DasColumn) || !DasUtil.isAutoVal((DasColumn)((DasColumn)columnElement))) continue;
                --id;
            }
            PsiElement psiElement = element = id >= 0 && id < targetType.getColumnCount() ? targetType.getColumnElement(id) : null;
            if (element != null) {
                this.addOccurrence(element);
            }
        }

        @Nullable
        public static MyValueToColumnHandler createForElement(@NotNull Editor editor, @NotNull PsiFile file, @NotNull PsiElement element) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/sql/SqlHighlightUsagesFactory$MyValueToColumnHandler", "createForElement"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/sql/SqlHighlightUsagesFactory$MyValueToColumnHandler", "createForElement"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/SqlHighlightUsagesFactory$MyValueToColumnHandler", "createForElement"));
            }
            SqlExpressionList list = SqlValuesParameterInfoHandler.findExpressions(element);
            if (list == null) {
                return null;
            }
            int offset = TargetElementUtil.adjustOffset((PsiFile)file, (Document)editor.getDocument(), (int)editor.getCaretModel().getOffset());
            int index = SqlValuesParameterInfoHandler.getCurrentParameterIndex(list, offset);
            if (index < 0) {
                return null;
            }
            return new MyValueToColumnHandler(editor, file, element, index);
        }
    }

    private static class MyColumnToValueHandler
    extends HighlightUsagesHandlerBase<PsiElement> {
        final PsiElement myTarget;
        final SqlDmlInstruction myDml;
        final int myIndex;

        protected MyColumnToValueHandler(Editor editor, PsiFile file, PsiElement element, SqlDmlInstruction dml, int index) {
            super(editor, file);
            this.myTarget = element;
            this.myDml = dml;
            this.myIndex = index;
        }

        @NotNull
        public List<PsiElement> getTargets() {
            List list = ContainerUtil.newSmartList((Object)this.myTarget);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlHighlightUsagesFactory$MyColumnToValueHandler", "getTargets"));
            }
            return list;
        }

        protected void selectTargets(List<PsiElement> targets, @NotNull Consumer<List<PsiElement>> selectionConsumer) {
            if (selectionConsumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectionConsumer", "com/intellij/sql/SqlHighlightUsagesFactory$MyColumnToValueHandler", "selectTargets"));
            }
            selectionConsumer.consume(targets);
        }

        public void computeUsages(List<PsiElement> targets) {
            SqlValuesExpression expression = (SqlValuesExpression)PsiTreeUtil.getChildOfType((PsiElement)this.myDml, SqlValuesExpression.class);
            if (expression == null) {
                return;
            }
            for (SqlExpression p : expression.getExpressions().filter(SqlParenthesizedExpression.class)) {
                PsiElement child = (PsiElement)SqlImplUtil.sqlChildren((PsiElement)p).filter(Conditions.instanceOf((Class[])new Class[]{PsiErrorElement.class, SqlExpression.class})).skip(this.myIndex).first();
                if (child == null) continue;
                this.addOccurrence(child);
            }
        }

        @Nullable
        public static HighlightUsagesHandlerBase createForElement(@NotNull Editor editor, @NotNull PsiFile file, @NotNull PsiElement element) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/sql/SqlHighlightUsagesFactory$MyColumnToValueHandler", "createForElement"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/sql/SqlHighlightUsagesFactory$MyColumnToValueHandler", "createForElement"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/SqlHighlightUsagesFactory$MyColumnToValueHandler", "createForElement"));
            }
            if (!(file instanceof SqlFile)) {
                return null;
            }
            SqlReferenceExpression ref = (SqlReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)element, SqlReferenceExpression.class);
            if (ref == null || ref.getReferenceElementType().getTargetKind() != ObjectKind.COLUMN) {
                return null;
            }
            SqlReferenceList refList = (SqlReferenceList)PsiTreeUtil.getParentOfType((PsiElement)ref, SqlReferenceList.class);
            if (refList == null) {
                return null;
            }
            SqlTableColumnsList tableColList = (SqlTableColumnsList)PsiTreeUtil.getParentOfType((PsiElement)refList, SqlTableColumnsList.class);
            if (tableColList == null) {
                return null;
            }
            SqlDmlInstruction dml = (SqlDmlInstruction)PsiTreeUtil.getParentOfType((PsiElement)tableColList, SqlDmlInstruction.class);
            if (dml == null || !(dml.getParent() instanceof SqlInsertStatement)) {
                return null;
            }
            List list = refList.getReferenceList();
            int id = list.indexOf(ref);
            return new MyColumnToValueHandler(editor, file, element, dml, id);
        }

        public boolean highlightReferences() {
            return true;
        }
    }
}

