/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.database.console.JdbcConsole;
import com.intellij.database.dataSource.DataSourceManagerEx;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.ide.scratch.LRUPopupBuilder;
import com.intellij.ide.scratch.ScratchFileActions;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.sql.dialects.SqlDialectMappings;
import com.intellij.sql.dialects.SqlDialectsConfigurable;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFileType;
import com.intellij.sql.psi.SqlLanguageSubstitutor;
import com.intellij.util.Consumer;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class ChangeDialectAction
extends ScratchFileActions.LanguageAction {
    @NotNull
    protected String getLanguageTerm() {
        if ("Dialect" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/ChangeDialectAction", "getLanguageTerm"));
        }
        return "Dialect";
    }

    @NotNull
    protected Condition<VirtualFile> fileFilter(Project project) {
        Condition<VirtualFile> condition = ChangeDialectAction.FILE_FILTER(project);
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/ChangeDialectAction", "fileFilter"));
        }
        return condition;
    }

    @NotNull
    public static Condition<VirtualFile> FILE_FILTER(final Project project) {
        Condition<VirtualFile> condition = new Condition<VirtualFile>(){
            PsiManager psiManager;
            {
                this.psiManager = PsiManager.getInstance((Project)project);
            }

            public boolean value(VirtualFile file) {
                if (file.getFileType() == SqlFileType.INSTANCE) {
                    return true;
                }
                if (JdbcConsole.getConsole(project, file) != null) {
                    return true;
                }
                if (ScratchRootType.getInstance().containsFile(file)) {
                    return false;
                }
                return this.psiManager.findFile(file) instanceof SqlFile && file.isInLocalFileSystem();
            }
        };
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/ChangeDialectAction", "FILE_FILTER"));
        }
        return condition;
    }

    @NotNull
    protected Function<VirtualFile, Language> fileLanguage(final Project project) {
        Function<VirtualFile, Language> function = new Function<VirtualFile, Language>(){

            public Language fun(VirtualFile virtualFile) {
                return SqlLanguageSubstitutor.getSqlLanguageDialect(virtualFile, project);
            }
        };
        if (function == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/ChangeDialectAction", "fileLanguage"));
        }
        return function;
    }

    protected void actionPerformedImpl(AnActionEvent e, Project project, JBIterable<VirtualFile> files) {
        ListPopup popup = ChangeDialectAction.buildDialectsPopup(project, files);
        popup.showInBestPositionFor(e.getDataContext());
    }

    @NotNull
    public static ListPopup buildDialectsPopup(final @NotNull Project project, final @NotNull JBIterable<VirtualFile> files) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/dialects/ChangeDialectAction", "buildDialectsPopup"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/sql/dialects/ChangeDialectAction", "buildDialectsPopup"));
        }
        LRUPopupBuilder builder = LRUPopupBuilder.languagePopupBuilder((Project)project, (String)"SQL Dialects").withComparator(LanguageUtil.LANGUAGE_COMPARATOR).forValues(SqlDialectMappings.getAvailableDialects());
        final ScratchRootType rootType = ScratchRootType.getInstance();
        builder.onChosen((Consumer)new Consumer<Language>(){

            public void consume(Language language) {
                if (language == Language.ANY) {
                    SqlDialectsConfigurable.openDialectsConfigurable(project, (VirtualFile)files.first());
                } else {
                    for (VirtualFile file : files) {
                        if (rootType.containsFile(file)) {
                            ScratchFileService.getInstance().getScratchesMapping().setMapping(file, (Object)language);
                            continue;
                        }
                        JdbcConsole console = JdbcConsole.getConsole(project, file);
                        if (console != null) {
                            LocalDataSource dataSource = (LocalDataSource)((Object)console.getTarget());
                            dataSource.setDefaultDialect(language.getID());
                            DataSourceManagerEx.getInstanceEx(project).updateDataSource(dataSource);
                            continue;
                        }
                        SqlDialectMappings.getInstance(project).setMapping(file, (SqlLanguageDialect)language);
                    }
                    FileContentUtilCore.reparseFiles((Collection)files.toList());
                }
            }
        });
        if (files.filter((Condition)new Condition<VirtualFile>(){

            public boolean value(VirtualFile file) {
                return rootType.containsFile(file) || JdbcConsole.getConsole(project, file) != null;
            }
        }).isEmpty()) {
            builder.withExtra((Object)Language.ANY, "SQL Dialects...", null);
        }
        ListPopup listPopup = builder.buildPopup();
        if (listPopup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/ChangeDialectAction", "buildDialectsPopup"));
        }
        return listPopup;
    }
}

