/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.h2;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasObject;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.dialects.h2.H2OptionalKeywords;
import com.intellij.sql.dialects.h2.H2ReservedKeywords;
import com.intellij.sql.dialects.h2.H2Tokens;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.sql.util.SqlTokenRegistry;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class H2Dialect
extends SqlLanguageDialectEx {
    public static final H2Dialect INSTANCE = new H2Dialect();

    public H2Dialect() {
        super("H2");
    }

    @Override
    @NotNull
    public DatabaseDialectEx getDatabaseDialect() {
        com.intellij.database.dialects.H2Dialect h2Dialect = com.intellij.database.dialects.H2Dialect.INSTANCE;
        if (h2Dialect == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/h2/H2Dialect", "getDatabaseDialect"));
        }
        return h2Dialect;
    }

    public boolean isReservedKeyword(IElementType tokenType) {
        return LazyData.ourReservedTokens.contains(tokenType);
    }

    @Override
    @NotNull
    public Map<String, SqlFunctionDefinition> getSupportedFunctions() {
        Map<String, SqlFunctionDefinition> map = LazyData.ourFunctionMap;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/h2/H2Dialect", "getSupportedFunctions"));
        }
        return map;
    }

    public boolean isOperatorSupported(IElementType tokenType) {
        return LazyData.ourSupportedOperators.contains(tokenType);
    }

    @NotNull
    public Set<String> getKeywords() {
        Set set = SqlTokenRegistry.getTokens(H2Tokens.class);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/h2/H2Dialect", "getKeywords"));
        }
        return set;
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/h2/H2Dialect", "getSystemVariables"));
        }
        return set;
    }

    @Override
    public boolean processReservedEntitiesWithType(@Nullable String name, @NotNull PsiElement element, boolean resolve, @NotNull SqlScopeProcessor processor) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/dialects/h2/H2Dialect", "processReservedEntitiesWithType"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/sql/dialects/h2/H2Dialect", "processReservedEntitiesWithType"));
        }
        if (!H2Dialect.processReservedEntitiesWithTypeDual(name, element, resolve, processor)) {
            return false;
        }
        return super.processReservedEntitiesWithType(name, element, resolve, processor);
    }

    @Override
    @Nullable
    public ProblemDescriptor checkIdentifierText(SqlIdentifier o, InspectionManager manager, boolean onTheFly) {
        return super.checkIdentifierText(o, manager, onTheFly);
    }

    public boolean isImportedAtPlace(@NotNull SqlFile sqlFile, @NotNull DasObject dbElement, PsiElement place) {
        if (sqlFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sqlFile", "com/intellij/sql/dialects/h2/H2Dialect", "isImportedAtPlace"));
        }
        if (dbElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dbElement", "com/intellij/sql/dialects/h2/H2Dialect", "isImportedAtPlace"));
        }
        if (super.isImportedAtPlace(sqlFile, dbElement, place)) {
            return true;
        }
        return Comparing.strEqual((String)dbElement.getName(), (String)"public", (boolean)false);
    }

    private static class LazyData {
        static final Map<String, SqlFunctionDefinition> ourFunctionMap = Collections.unmodifiableMap(SqlFunctionsUtil.loadFunctionDefinition(INSTANCE));
        static final Set<String> ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtil.loadSystemVars(INSTANCE));
        static final TokenSet ourReservedTokens = SqlTokenRegistry.getTokenSet(H2ReservedKeywords.class);
        static final TokenSet ourSupportedOperators = TokenSet.create((IElementType[])new IElementType[]{SqlTokens.SQL_OP_PLUS, SqlTokens.SQL_OP_MINUS, SqlTokens.SQL_OP_MUL, SqlTokens.SQL_OP_DIV, SqlTokens.SQL_OP_NEQ, SqlTokens.SQL_OP_LE, SqlTokens.SQL_OP_LT, SqlTokens.SQL_OP_GE, SqlTokens.SQL_OP_EQ, SqlTokens.SQL_OP_GT, SqlTokens.SQL_OP_CONCAT, SqlTokens.SQL_AND, SqlTokens.SQL_NOT, SqlTokens.SQL_OR, SqlTokens.SQL_IS, SqlTokens.SQL_LIKE, SqlTokens.SQL_COLLATE, SqlTokens.SQL_IN, SqlTokens.SQL_OP_NEQ2, SqlTokens.SQL_OP_MODULO, H2OptionalKeywords.H2_REGEXP});

        private LazyData() {
        }
    }
}

