/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mssql;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.dialects.mssql.MssqlElementTypes;
import com.intellij.sql.dialects.mssql.MssqlReservedKeywords;
import com.intellij.sql.dialects.mssql.MssqlTokens;
import com.intellij.sql.dialects.mssql.MssqlTypes;
import com.intellij.sql.editor.SqlCloseBlockProcessorImpl;
import com.intellij.sql.editor.SqlEnterHandlerImpl;
import com.intellij.sql.editor.SubstitutionDescriptorImpl;
import com.intellij.sql.psi.SqlCreateTriggerStatement;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.util.SqlTokenRegistry;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MssqlDialect
extends SqlLanguageDialectEx {
    public static final MssqlDialect INSTANCE = new MssqlDialect();

    public MssqlDialect() {
        super("TSQL");
    }

    @NotNull
    public String getDisplayName() {
        if ("SQL Server" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/mssql/MssqlDialect", "getDisplayName"));
        }
        return "SQL Server";
    }

    @Override
    @NotNull
    public DatabaseDialectEx getDatabaseDialect() {
        com.intellij.database.dialects.MssqlDialect mssqlDialect = com.intellij.database.dialects.MssqlDialect.INSTANCE;
        if (mssqlDialect == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/mssql/MssqlDialect", "getDatabaseDialect"));
        }
        return mssqlDialect;
    }

    public boolean isReservedKeyword(IElementType tokenType) {
        return LazyData.ourReservedTokens.contains(tokenType);
    }

    @Override
    @NotNull
    public Map<String, SqlFunctionDefinition> getSupportedFunctions() {
        Map<String, SqlFunctionDefinition> map = Collections.unmodifiableMap(LazyData.ourFunctionMap);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/mssql/MssqlDialect", "getSupportedFunctions"));
        }
        return map;
    }

    public boolean isOperatorSupported(IElementType tokenType) {
        return LazyData.ourSupportedOperators.contains(tokenType);
    }

    @NotNull
    public Set<String> getKeywords() {
        Set set = SqlTokenRegistry.getTokens(MssqlTokens.class);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/mssql/MssqlDialect", "getKeywords"));
        }
        return set;
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/mssql/MssqlDialect", "getSystemVariables"));
        }
        return set;
    }

    @Override
    public boolean processReservedEntitiesWithType(@Nullable String name, @NotNull PsiElement element, boolean resolve, @NotNull SqlScopeProcessor processor) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/dialects/mssql/MssqlDialect", "processReservedEntitiesWithType"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/sql/dialects/mssql/MssqlDialect", "processReservedEntitiesWithType"));
        }
        if ((SqlImplUtil.equalsInsensetiveOrTrue(name, LazyData.RE_INSERTED.name, resolve) || SqlImplUtil.equalsInsensetiveOrTrue(name, LazyData.RE_DELETED.name, resolve)) && MssqlDialect.isInsideTriggerBody(element)) {
            if (!processor.executeTarget((DasObject)LazyData.RE_INSERTED, element, (SqlType)SqlTableTypeBase.EMPTY_TABLE, false, ResolveState.initial())) {
                return false;
            }
            if (!processor.executeTarget((DasObject)LazyData.RE_DELETED, element, (SqlType)SqlTableTypeBase.EMPTY_TABLE, false, ResolveState.initial())) {
                return false;
            }
        }
        if (SqlImplUtil.equalsInsensetiveOrTrue(name, LazyData.RE_ACTION.name, resolve) && !processor.executeTarget((DasObject)LazyData.RE_ACTION, element, (SqlType)SqlType.STRING, false, ResolveState.initial())) {
            return false;
        }
        if (SqlImplUtil.equalsInsensetiveOrTrue(name, LazyData.RE_IDENTITY.name, resolve) && !processor.executeTarget((DasObject)LazyData.RE_IDENTITY, element, (SqlType)SqlType.STRING, false, ResolveState.initial())) {
            return false;
        }
        if (SqlImplUtil.equalsInsensetiveOrTrue(name, LazyData.RE_ROWGUID.name, resolve) && !processor.executeTarget((DasObject)LazyData.RE_ROWGUID, element, (SqlType)SqlType.STRING, false, ResolveState.initial())) {
            return false;
        }
        return super.processReservedEntitiesWithType(name, element, resolve, processor);
    }

    public boolean isImportedAtPlace(@NotNull SqlFile sqlFile, @NotNull DasObject dbElement, PsiElement place) {
        if (sqlFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sqlFile", "com/intellij/sql/dialects/mssql/MssqlDialect", "isImportedAtPlace"));
        }
        if (dbElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dbElement", "com/intellij/sql/dialects/mssql/MssqlDialect", "isImportedAtPlace"));
        }
        if (super.isImportedAtPlace(sqlFile, dbElement, place)) {
            return true;
        }
        return SqlDialectImplUtil.checkFileImports(sqlFile, dbElement, place);
    }

    @Override
    public TokenSet getStatementSeparators() {
        return LazyData.ourClosingTokens;
    }

    @Override
    public String quoteIdentifier(@NotNull SqlIdentifier identifier, @NotNull String newElementName) {
        ObjectKind type;
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/intellij/sql/dialects/mssql/MssqlDialect", "quoteIdentifier"));
        }
        if (newElementName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElementName", "com/intellij/sql/dialects/mssql/MssqlDialect", "quoteIdentifier"));
        }
        PsiElement parent = identifier.getParent();
        Object object = parent instanceof SqlReferenceExpression ? ((SqlReferenceExpression)parent).getReferenceElementType().getTargetKind() : (type = parent instanceof SqlDefinition ? ((SqlDefinition)parent).getKind() : null);
        if (type == SqlDbElementType.VARIABLE) {
            return newElementName.replace(' ', '_');
        }
        return super.quoteIdentifier(identifier, newElementName);
    }

    @Override
    public <T extends Collection<ObjectKind>> T getParentDbTypes(T result, ObjectKind type) {
        super.getParentDbTypes(result, type);
        if (type == ObjectKind.INDEX) {
            result.add((ObjectKind)ObjectKind.TABLE);
        }
        return result;
    }

    @Override
    public boolean shouldQuotedTypeReferenceBeChecked(@NotNull String ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/sql/dialects/mssql/MssqlDialect", "shouldQuotedTypeReferenceBeChecked"));
        }
        return !this.getKeywords().contains(ref);
    }

    @Override
    @Nullable
    public EnterHandlerDelegate getEnterHandler() {
        return LazyData.ENTER_HANDLER;
    }

    private static boolean isInsideTriggerBody(@NotNull PsiElement el) {
        if (el == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "el", "com/intellij/sql/dialects/mssql/MssqlDialect", "isInsideTriggerBody"));
        }
        PsiElement prev = null;
        for (PsiElement element : SyntaxTraverser.psiApi().parents((Object)el)) {
            if (element instanceof SqlCreateTriggerStatement && prev instanceof SqlStatement) {
                return true;
            }
            prev = element;
        }
        return false;
    }

    private static class LazyData {
        static final Map<String, SqlFunctionDefinition> ourFunctionMap = Collections.unmodifiableMap(SqlFunctionsUtil.loadFunctionDefinition(INSTANCE));
        static final Set<String> ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtil.loadSystemVars(INSTANCE));
        static final TokenSet ourReservedTokens = SqlTokenRegistry.getTokenSet(MssqlReservedKeywords.class);
        static final TokenSet ourClosingTokens = TokenSet.orSet((TokenSet[])new TokenSet[]{SqlTokens.STATEMENT_SEPARATORS, TokenSet.create((IElementType[])new IElementType[]{MssqlTypes.MSSQL_GO})});
        static final TokenSet ourSupportedOperators = TokenSet.create((IElementType[])new IElementType[]{SqlElementTypes.SQL_OP_PLUS, SqlElementTypes.SQL_OP_MINUS, SqlElementTypes.SQL_OP_MUL, SqlElementTypes.SQL_OP_DIV, SqlElementTypes.SQL_OP_NEQ, SqlElementTypes.SQL_OP_LE, SqlElementTypes.SQL_OP_LT, SqlElementTypes.SQL_OP_GE, SqlElementTypes.SQL_OP_EQ, SqlElementTypes.SQL_OP_GT, SqlElementTypes.SQL_OP_CONCAT, SqlElementTypes.SQL_AND, SqlElementTypes.SQL_NOT, SqlElementTypes.SQL_OR, SqlElementTypes.SQL_IS, SqlElementTypes.SQL_LIKE, SqlElementTypes.SQL_COLLATE, SqlElementTypes.SQL_IN, SqlElementTypes.SQL_OP_LOGICAL_AND, SqlElementTypes.SQL_OP_BITWISE_AND, SqlElementTypes.SQL_OP_BITWISE_NOT, SqlElementTypes.SQL_OP_BITWISE_OR, SqlElementTypes.SQL_OP_LOGICAL_OR, SqlElementTypes.SQL_OP_BITWISE_XOR, SqlElementTypes.SQL_OP_MODULO, SqlElementTypes.SQL_OP_NEQ2, SqlElementTypes.SQL_OP_NOT_LT, SqlElementTypes.SQL_OP_NOT_GT, SqlElementTypes.SQL_OP_PLUS_EQ, SqlElementTypes.SQL_OP_MINUS_EQ, SqlElementTypes.SQL_OP_MUL_EQ, SqlElementTypes.SQL_OP_DIV_EQ, SqlElementTypes.SQL_OP_MODULO_EQ, SqlElementTypes.SQL_OP_BITWISE_AND_EQ, SqlElementTypes.SQL_OP_BITWISE_OR_EQ, SqlElementTypes.SQL_OP_BITWISE_XOR_EQ});
        static final ReservedEntity RE_INSERTED = new ReservedEntity("INSERTED", ObjectKind.TABLE);
        static final ReservedEntity RE_DELETED = new ReservedEntity("DELETED", ObjectKind.TABLE);
        static final ReservedEntity RE_ACTION = new ReservedEntity("$action", ObjectKind.COLUMN);
        static final ReservedEntity RE_IDENTITY = new ReservedEntity("$IDENTITY", ObjectKind.COLUMN);
        static final ReservedEntity RE_ROWGUID = new ReservedEntity("$ROWGUID", ObjectKind.COLUMN);
        private static final EnterHandlerDelegate ENTER_HANDLER = new SqlEnterHandlerImpl(new SqlCloseBlockProcessorImpl(new SubstitutionDescriptorImpl(new IElementType[]{SqlElementTypes.SQL_BEGIN, SqlElementTypes.SQL_BLOCK_STATEMENT}, "", "end", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlElementTypes.SQL_END, SqlElementTypes.SQL_SEMICOLON}).mask(true, false)), new SubstitutionDescriptorImpl(new IElementType[]{MssqlTypes.MSSQL_TRY, MssqlElementTypes.MSSQL_TRY_CATCH_STATEMENT}, "", "end try\nbegin catch\nend catch", 1, SubstitutionDescriptorImpl.TailCheck.builder().man(new IElementType[]{SqlElementTypes.SQL_END}).man(MssqlTypes.MSSQL_TRY).opt(new IElementType[]{MssqlElementTypes.MSSQL_CATCH_CLAUSE, SqlElementTypes.SQL_SEMICOLON}).build()), new SubstitutionDescriptorImpl(new IElementType[]{MssqlTypes.MSSQL_CATCH, MssqlElementTypes.MSSQL_CATCH_CLAUSE}, "", "end catch", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlElementTypes.SQL_END, MssqlTypes.MSSQL_CATCH, SqlElementTypes.SQL_SEMICOLON}).mask(true, true, false))));

        private LazyData() {
        }
    }
}

