/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.oracle;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DbImplUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlMessages;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.dialects.oracle.OraConstructorDefinitionImpl;
import com.intellij.sql.dialects.oracle.OraTypes;
import com.intellij.sql.dialects.oracle.OracleElementTypes;
import com.intellij.sql.dialects.oracle.OracleOptionalKeywords;
import com.intellij.sql.dialects.oracle.OraclePlReservedKeywords;
import com.intellij.sql.dialects.oracle.OracleReservedKeywords;
import com.intellij.sql.dialects.oracle.OracleTokens;
import com.intellij.sql.dialects.oracle.psi.OraModelClauseImpl;
import com.intellij.sql.dialects.oracle.refactoring.OracleExtractVariableHelper;
import com.intellij.sql.editor.SqlCloseBlockProcessorImpl;
import com.intellij.sql.editor.SqlEnterHandlerImpl;
import com.intellij.sql.editor.SubstitutionDescriptorImpl;
import com.intellij.sql.highlighting.QuoteIdentifierQuickFix;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlPrimitiveType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.SqlUnaryExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.refactoring.SqlExtractVariableHelper;
import com.intellij.sql.util.SqlTokenRegistry;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OracleDialect
extends SqlLanguageDialectEx {
    public static final OracleDialect INSTANCE = new OracleDialect();

    public OracleDialect() {
        super("Oracle");
    }

    protected OracleDialect(@NonNls @NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/sql/dialects/oracle/OracleDialect", "<init>"));
        }
        super(id);
    }

    @Override
    @NotNull
    public DatabaseDialectEx getDatabaseDialect() {
        com.intellij.database.dialects.OracleDialect oracleDialect = com.intellij.database.dialects.OracleDialect.INSTANCE;
        if (oracleDialect == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/oracle/OracleDialect", "getDatabaseDialect"));
        }
        return oracleDialect;
    }

    public boolean isReservedKeyword(IElementType tokenType) {
        return LazyData.ourReservedTokens.contains(tokenType);
    }

    public boolean isReservedKeywordPL(IElementType tokenType) {
        return LazyData.ourPlReservedTokens.contains(tokenType);
    }

    @Override
    @NotNull
    public Map<String, SqlFunctionDefinition> getSupportedFunctions() {
        Map<String, SqlFunctionDefinition> map = LazyData.ourFunctionMap;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/oracle/OracleDialect", "getSupportedFunctions"));
        }
        return map;
    }

    public boolean isOperatorSupported(IElementType tokenType) {
        return LazyData.ourSupportedOperators.contains(tokenType);
    }

    public boolean processConnectByPseudoColumns(@NotNull PsiElement element, @NotNull SqlScopeProcessor processor) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/dialects/oracle/OracleDialect", "processConnectByPseudoColumns"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/sql/dialects/oracle/OracleDialect", "processConnectByPseudoColumns"));
        }
        if (processor.getExpectedTypes().contains(ObjectKind.COLUMN)) {
            for (DasObject entity : LazyData.CONNECT_BY_PSEUDO_COLUMNS.values()) {
                if (processor.executeTarget(entity, element, (SqlType)SqlType.INTEGER, null, ResolveState.initial())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean processReservedEntitiesWithType(@Nullable String name, @NotNull PsiElement element, boolean resolve, @NotNull SqlScopeProcessor processor) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/dialects/oracle/OracleDialect", "processReservedEntitiesWithType"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/sql/dialects/oracle/OracleDialect", "processReservedEntitiesWithType"));
        }
        if (!OracleDialect.processReservedEntitiesWithTypeDual(name, element, resolve, processor)) {
            return false;
        }
        if (!super.processReservedEntitiesWithType(name, element, resolve, processor)) {
            return false;
        }
        if (processor.getExpectedTypes().contains(ObjectKind.COLUMN)) {
            ObjectKind kind = SqlImplUtil.getQualifierKind(element);
            if (DbImplUtil.isDataTable(kind)) {
                for (DasObject entity : LazyData.PSEUDO_COLUMNS.values()) {
                    if (OracleDialect.processReservedEntitiesWithTypeSimple(entity, (SqlType)SqlType.INTEGER, name, element, resolve, processor, true, null)) continue;
                    return false;
                }
            }
            if (SqlImplUtil.getConcreteType(SqlImplUtil.getQualifierType(element)) == SqlType.COLLECTION || OracleDialect.isBulkUpdateAttribute(element)) {
                for (DasObject entity : LazyData.PL_TABLE_ATTRIBUTES.values()) {
                    if (OracleDialect.processReservedEntitiesWithTypeSimple(entity, (SqlType)SqlType.INTEGER, name, element, resolve, processor, true, null)) continue;
                    return false;
                }
            }
        }
        if (!OracleDialect.processSelf(element, processor)) {
            return false;
        }
        if (SqlImplUtil.equalsInsensetiveOrTrue(LazyData.RE_EXTEND.name, name, resolve) && SqlImplUtil.getConcreteType(SqlImplUtil.getQualifierType(element)) == SqlType.COLLECTION && !processor.executeTarget((DasObject)LazyData.RE_EXTEND, element, (SqlType)SqlType.REFERENCE, false, ResolveState.initial())) {
            return false;
        }
        return OracleDialect.processReservedEntitiesWithTypeSimple((DasObject)LazyData.RE_PROFILE_DEFAULT, (SqlType)SqlType.REFERENCE, name, element, resolve, processor, true, null);
    }

    private static boolean processSelf(PsiElement element, SqlScopeProcessor processor) {
        OraConstructorDefinitionImpl constructor;
        if (element instanceof SqlReferenceExpression && ((SqlReferenceExpression)element).getQualifierExpression() == null && (constructor = (OraConstructorDefinitionImpl)PsiTreeUtil.getParentOfType((PsiElement)element, OraConstructorDefinitionImpl.class)) != null) {
            SqlPrimitiveType sqlType;
            SqlTypeElement typeElement = constructor.getTypeElement();
            SqlReferenceExpression ref = (SqlReferenceExpression)PsiTreeUtil.getChildOfType((PsiElement)typeElement, SqlReferenceExpression.class);
            Object object = sqlType = ref != null ? ref.getSqlType() : SqlType.UNKNOWN;
            if (sqlType == SqlType.UNKNOWN) {
                sqlType = SqlTableTypeBase.EMPTY_TABLE;
            }
            if (!processor.executeTarget((DasObject)LazyData.RE_SELF, element, (SqlType)sqlType, null, ResolveState.initial())) {
                return false;
            }
        }
        return true;
    }

    private static boolean isBulkUpdateAttribute(PsiElement element) {
        PsiElement parent = element.getParent();
        if (!(parent instanceof SqlBinaryExpression)) {
            return false;
        }
        SqlUnaryExpression prev = (SqlUnaryExpression)PsiTreeUtil.getPrevSiblingOfType((PsiElement)element, SqlUnaryExpression.class);
        ASTNode node = prev == null ? null : prev.getNode();
        ASTNode bulkException = node == null ? null : node.findChildByType(OraTypes.ORA_BULK_EXCEPTIONS);
        return bulkException != null;
    }

    @NotNull
    public Set<String> getKeywords() {
        Set set = SqlTokenRegistry.getTokens(OracleTokens.class);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/oracle/OracleDialect", "getKeywords"));
        }
        return set;
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/oracle/OracleDialect", "getSystemVariables"));
        }
        return set;
    }

    @NotNull
    public Set<String> getExceptionNames() {
        Set<String> set = LazyData.ourExceptionNames;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/oracle/OracleDialect", "getExceptionNames"));
        }
        return set;
    }

    public boolean isImportedAtPlace(@NotNull SqlFile sqlFile, @NotNull DasObject dbElement, PsiElement place) {
        if (sqlFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sqlFile", "com/intellij/sql/dialects/oracle/OracleDialect", "isImportedAtPlace"));
        }
        if (dbElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dbElement", "com/intellij/sql/dialects/oracle/OracleDialect", "isImportedAtPlace"));
        }
        if (super.isImportedAtPlace(sqlFile, dbElement, place)) {
            return true;
        }
        if (dbElement.getKind() == ObjectKind.SCHEMA && Comparing.equal((String)dbElement.getName(), (String)"public", (boolean)false)) {
            return true;
        }
        return SqlDialectImplUtil.checkFileImports(sqlFile, dbElement, place);
    }

    public boolean isResolveTargetAccepted(@NotNull PsiElement element, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/dialects/oracle/OracleDialect", "isResolveTargetAccepted"));
        }
        if (expectedTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedTypes", "com/intellij/sql/dialects/oracle/OracleDialect", "isResolveTargetAccepted"));
        }
        if (type == SqlDbElementType.LOCAL_ALIAS && expectedTypes.contains(ObjectKind.COLUMN)) {
            return element.getParent() instanceof OraModelClauseImpl;
        }
        if (type == ObjectKind.VARIABLE && expectedTypes.contains(OracleElementTypes.Extra.COLLECTION)) {
            return true;
        }
        if (expectedTypes.contains(ObjectKind.ROUTINE)) {
            return true;
        }
        return super.isResolveTargetAccepted(element, type, expectedTypes);
    }

    @Override
    @Nullable
    public ProblemDescriptor checkIdentifierText(SqlIdentifier o, InspectionManager manager, boolean onTheFly) {
        ASTNode astNode = o.getNode();
        assert (astNode != null);
        String text = astNode.getText();
        if (text.length() > 0 && !Character.isLetter(text.charAt(0))) {
            return manager.createProblemDescriptor((PsiElement)o, SqlMessages.message("identifier.should.start.with.letter", new Object[0]), (LocalQuickFix)new QuoteIdentifierQuickFix(this), ProblemHighlightType.GENERIC_ERROR, onTheFly);
        }
        return super.checkIdentifierText(o, manager, onTheFly);
    }

    @Override
    public <T extends Collection<ObjectKind>> T getParentDbTypes(T result, ObjectKind type) {
        super.getParentDbTypes(result, type);
        if (type == ObjectKind.ROUTINE) {
            result.add((ObjectKind)ObjectKind.PACKAGE);
        }
        return result;
    }

    @Override
    public TokenSet getStatementSeparators() {
        return LazyData.ourClosingTokens;
    }

    @Override
    @Nullable
    public SqlExtractVariableHelper getExtractVariableHelper() {
        return new OracleExtractVariableHelper();
    }

    @Override
    @Nullable
    public EnterHandlerDelegate getEnterHandler() {
        return LazyData.ENTER_HANDLER;
    }

    private static class LazyData {
        static final Map<String, SqlFunctionDefinition> ourFunctionMap = SqlFunctionsUtil.loadFunctionDefinition(INSTANCE);
        static final Set<String> ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtil.loadSystemVars(INSTANCE));
        static final Set<String> ourExceptionNames = Collections.unmodifiableSet(SqlDialectImplUtil.loadTokens(INSTANCE, "exceptions.txt"));
        static final TokenSet ourReservedTokens = SqlTokenRegistry.getTokenSet(OracleReservedKeywords.class);
        static final TokenSet ourPlReservedTokens = SqlTokenRegistry.getTokenSet(OraclePlReservedKeywords.class);
        static final TokenSet ourClosingTokens = TokenSet.orSet((TokenSet[])new TokenSet[]{SqlTokens.STATEMENT_SEPARATORS, TokenSet.create((IElementType[])new IElementType[]{SqlTokens.SQL_OP_DIV, SqlTokens.ORAP_SLASH_DELIMITER_TOKEN, SqlTokens.ORAP_DELIMITER_TOKEN})});
        static final TokenSet ourSupportedOperators = TokenSet.create((IElementType[])new IElementType[]{SqlTokens.SQL_OP_PLUS, SqlTokens.SQL_OP_MINUS, SqlTokens.SQL_OP_MUL, SqlTokens.SQL_OP_DIV, SqlTokens.SQL_OP_NEQ, SqlTokens.SQL_OP_NEQ2, SqlTokens.SQL_OP_LE, SqlTokens.SQL_OP_LT, SqlTokens.SQL_OP_GE, SqlTokens.SQL_OP_EQ, SqlTokens.ORA_POWER, SqlTokens.SQL_OP_GT, SqlTokens.SQL_OP_CONCAT, SqlCommonKeywords.SQL_AND, SqlCommonKeywords.SQL_NOT, SqlCommonKeywords.SQL_OR, SqlCommonKeywords.SQL_IS, SqlCommonKeywords.SQL_LIKE, SqlCommonKeywords.SQL_COLLATE, SqlCommonKeywords.SQL_IN, SqlTokens.ORA_OP_JOIN, OracleReservedKeywords.ORA_PRIOR, OracleOptionalKeywords.ORA_LIKEC, OracleOptionalKeywords.ORA_LIKE2, OracleOptionalKeywords.ORA_LIKE4, OraTypes.ORA_AT, SqlTokens.SQL_OP_NEQ3, SqlTokens.SQL_OP_NEQ_WS, SqlTokens.SQL_OP_NEQ2_WS, SqlTokens.SQL_OP_NEQ3_WS, SqlCommonKeywords.SQL_YEAR, SqlCommonKeywords.SQL_DAY, SqlTokens.SQL_OP_ASSIGN, OraTypes.ORA_MEMBER, OraTypes.ORA_SUBMULTISET, OraTypes.ORA_CURSOR, OracleOptionalKeywords.ORA_MULTISET});
        static final Map<String, DasObject> PSEUDO_COLUMNS = SqlDialectImplUtil.buildEntities(ObjectKind.COLUMN, "BINARY_DOUBLE_INFINITY", "BINARY_DOUBLE_NAN", "BINARY_FLOAT_INFINITY", "BINARY_FLOAT_NAN", "COLUMN_VALUE", "OBJECT_ID", "OBJECT_VALUE", "ORA_ROWSCN", "VERSIONS_STARTTIME", "VERSIONS_STARTSCN", "VERSIONS_ENDTIME", "VERSIONS_ENDSCN", "VERSIONS_XID", "VERSIONS_OPERATION", "XMLDATA", "ROWID", "ROWNUM");
        static final Map<String, DasObject> CONNECT_BY_PSEUDO_COLUMNS = SqlDialectImplUtil.buildEntities(ObjectKind.COLUMN, "CONNECT_BY_ISCYCLE", "CONNECT_BY_ISLEAF", "LEVEL");
        static final Map<String, DasObject> PL_TABLE_ATTRIBUTES = SqlDialectImplUtil.buildEntities(ObjectKind.COLUMN, "EXISTS", "COUNT", "FIRST", "LAST", "PRIOR", "NEXT", "DELETE");
        static final ReservedEntity RE_SELF = new ReservedEntity("SELF", ObjectKind.OBJECT_TYPE);
        static final ReservedEntity RE_EXTEND = new ReservedEntity("extend", ObjectKind.OBJECT_TYPE);
        static final ReservedEntity RE_PROFILE_DEFAULT = new ReservedEntity("DEFAULT", SqlDbElementType.PROFILE);
        private static final EnterHandlerDelegate ENTER_HANDLER = new SqlEnterHandlerImpl(new SqlCloseBlockProcessorImpl(new SubstitutionDescriptorImpl(new IElementType[]{SqlCommonKeywords.SQL_BEGIN, SqlCompositeElementTypes.SQL_BLOCK_STATEMENT}, "", "end;", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlCommonKeywords.SQL_END, SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE, SqlTokens.SQL_SEMICOLON}).mask(true, false, false)), new SubstitutionDescriptorImpl(new IElementType[]{SqlCommonKeywords.SQL_LOOP, SqlCompositeElementTypes.SQL_LOOP_STATEMENT}, "", "end loop;", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlCommonKeywords.SQL_END, SqlCommonKeywords.SQL_LOOP, SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE, SqlTokens.SQL_SEMICOLON}).mask(true, true, false, false)), new SubstitutionDescriptorImpl(new IElementType[]{SqlCommonKeywords.SQL_THEN, SqlCompositeElementTypes.SQL_THEN_CLAUSE, SqlCompositeElementTypes.SQL_IF_STATEMENT}, "", "end if;", 2, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlCommonKeywords.SQL_END, SqlCommonKeywords.SQL_IF, SqlTokens.SQL_SEMICOLON}).mask(true, true, false))));

        private LazyData() {
        }
    }
}

