/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.oracle.formatter;

import com.intellij.codeInsight.editorActions.JoinLinesHandlerDelegate;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.oracle.plus.OrapDialect;
import com.intellij.sql.psi.IsExternal;
import com.intellij.sql.psi.SqlFile;

public class OrapJoinLinesHandler
implements JoinLinesHandlerDelegate {
    public static boolean isUnescapedSeparatorAtTheEnd(String text) {
        boolean result = false;
        for (int i = text.length() - 1; i >= 0 && text.charAt(i) == '-'; --i) {
            result = !result;
        }
        return result;
    }

    public int tryJoinLines(Document doc, PsiFile psiFile, int start, int end) {
        if (!(psiFile instanceof SqlFile)) {
            return -1;
        }
        SqlLanguageDialect language = ((SqlFile)psiFile).getSqlLanguage();
        if (!language.equals((Object)OrapDialect.INSTANCE)) {
            return -1;
        }
        PsiElement at = psiFile.findElementAt(start);
        if (SyntaxTraverser.psiApi().parents((Object)at).filter(IsExternal.class).isEmpty()) {
            return -1;
        }
        if (OrapJoinLinesHandler.isUnescapedSeparatorAtTheEnd(doc.getText().substring(0, start + 1))) {
            doc.deleteString(start, start + 1);
            --start;
        }
        return start + 1;
    }
}

