/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.codeInsight.template.impl.Variable;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.actions.DdlActions;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.intentions.RunQueryInConsoleIntentionAction;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiColumn;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbTable;
import com.intellij.database.script.PersistenceConsoleProvider;
import com.intellij.database.util.Case;
import com.intellij.database.util.DbImplUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlMessages;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.highlighting.SqlAnnotator;
import com.intellij.sql.inspections.SqlEditorAwareFix;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.JdbcProcedureCall;
import com.intellij.sql.psi.SqlAlterTableInstruction;
import com.intellij.sql.psi.SqlAlterTableStatement;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateTableStatement;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlDropStatement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlGrantStatement;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlParameter;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlRenameToClause;
import com.intellij.sql.psi.SqlRevokeStatement;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.NameChecker;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlResolveInspection
extends SqlInspectionBase {
    @NotNull
    public String getDisplayName() {
        String string = SqlMessages.message("inspection.name.resolve", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlResolveInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, final @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result, final boolean onTheFly) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/inspections/SqlResolveInspection", "createAnnotationVisitor"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/sql/inspections/SqlResolveInspection", "createAnnotationVisitor"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/sql/inspections/SqlResolveInspection", "createAnnotationVisitor"));
        }
        final SyntaxTraverser traverser = (SyntaxTraverser)SqlImplUtil.sqlTraverser().filter(Conditions.instanceOf(SqlReferenceExpression.class));
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result){
            List<DbDataSource> myDataSources;

            public void visitSqlReferenceExpression(@NotNull SqlReferenceExpression re) {
                if (re == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "re", "com/intellij/sql/inspections/SqlResolveInspection$1", "visitSqlReferenceExpression"));
                }
                for (PsiElement element : (SyntaxTraverser)traverser.withRoot((Object)re)) {
                    SqlReferenceExpression o = (SqlReferenceExpression)element;
                    if (this.shouldNotCheckElement((SqlElement)o)) {
                        return;
                    }
                    ObjectKind type = o.getReferenceElementType().getTargetKind();
                    if (!this.myDialect.shallResolve(type)) {
                        return;
                    }
                    SqlExpression qualifier = o.getQualifierExpression();
                    SqlIdentifier identifier = o.getIdentifier();
                    boolean afterIfExists = this.afterIfExistsClause(o);
                    if (qualifier instanceof SqlReferenceExpression) {
                        if (((SqlReferenceExpression)qualifier).resolve() == null) continue;
                        this.checkIdentifier(identifier, afterIfExists);
                        break;
                    }
                    this.checkIdentifier(identifier, afterIfExists);
                }
            }

            private void checkIdentifier(@Nullable SqlIdentifier identifier, boolean afterIfExists) {
                if (identifier == null || afterIfExists) {
                    return;
                }
                this.checkResolve(identifier);
            }

            private boolean afterIfExistsClause(@NotNull SqlReferenceExpression o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/sql/inspections/SqlResolveInspection$1", "afterIfExistsClause"));
                }
                PsiElement parent = o.getParent();
                return (parent instanceof SqlDropStatement || parent instanceof SqlAlterTableStatement || parent instanceof SqlAlterTableInstruction) && FormatterUtil.hasPrecedingSiblingOfType((ASTNode)o.getNode(), (IElementType)SqlCompositeElementTypes.SQL_IF_EXISTS_CLAUSE, (IElementType[])new IElementType[0]);
            }

            public void visitSqlIdentifier(@NotNull SqlIdentifier o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/sql/inspections/SqlResolveInspection$1", "visitSqlIdentifier"));
                }
                if (this.shouldNotCheckElement((SqlElement)o)) {
                    return;
                }
                if (o.getParent() instanceof SqlRenameToClause) {
                    return;
                }
                this.checkResolve(o);
            }

            public void visitSqlParameter(SqlParameter o) {
            }

            private boolean checkResolve(@Nullable SqlIdentifier o) {
                boolean isFunction;
                PsiElement parent;
                if (o == null || o.getTextLength() == 0) {
                    return false;
                }
                IElementType firstChildType = PsiUtilCore.getElementType((PsiElement)o.getFirstChild());
                if (firstChildType == SqlTokens.SQL_EXTERNAL_PARAM || firstChildType == SqlTokens.SQL_EXTERNAL_PARAM_PREFIX || firstChildType == SqlTokens.SQL_CUSTOM_PARAM_LQUOTE) {
                    return true;
                }
                if (o.getFirstChild() instanceof SqlParameter) {
                    return true;
                }
                if (o.getLastChild() instanceof SqlParameter) {
                    return true;
                }
                PsiElement target = SqlAnnotator.getTargetElement(o);
                if (target == (parent = o.getParent()) && "*".equals(o.getText()) && (!(parent instanceof SqlExpression) || SqlType.UNKNOWN == ((SqlExpression)parent).getSqlType())) {
                    SqlStatement st = (SqlStatement)PsiTreeUtil.getParentOfType((PsiElement)o, SqlStatement.class);
                    if (st instanceof SqlGrantStatement || st instanceof SqlRevokeStatement) {
                        return true;
                    }
                    this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)o, "unable to resolve * in this context", true, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly, new LocalQuickFix[0]));
                    return false;
                }
                if (target != null) {
                    return true;
                }
                ObjectKind expectedType = parent instanceof SqlReferenceExpression ? ((SqlReferenceExpression)parent).getReferenceElementType().getTargetKind() : SqlDbElementType.ANY;
                boolean bl = isFunction = expectedType == ObjectKind.ROUTINE;
                if (isFunction && parent.getParent().getParent() instanceof JdbcProcedureCall) {
                    return true;
                }
                String kindName = DbPresentation.getPresentableName((ObjectKind)expectedType, (DatabaseDialect)SqlImplUtil.getSqlDialectSafe((PsiElement)o).getDatabaseDialect());
                String message = isFunction ? SqlMessages.message("unknown.function", o.getName()) : (expectedType != SqlDbElementType.ANY ? SqlMessages.message("unable.to.resolve.symbol.0.1", kindName, o.getName()) : SqlMessages.message("unable.to.resolve.symbol.0", o.getName()));
                List<LocalQuickFix> fixesList = this.getAvailableFixes(o, parent, expectedType);
                this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)o, message, true, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly, onTheFly ? fixesList.toArray(new LocalQuickFix[fixesList.size()]) : LocalQuickFix.EMPTY_ARRAY));
                return false;
            }

            @NotNull
            private List<LocalQuickFix> getAvailableFixes(@NotNull SqlIdentifier o, @Nullable PsiElement parent, @NotNull ObjectKind expectedType) {
                ArrayList fixesList;
                block10: {
                    SmartPointerManager pm;
                    block11: {
                        PsiElement resolveResult;
                        block13: {
                            SqlExpression expression;
                            PsiElement resolve;
                            block12: {
                                block9: {
                                    if (o == null) {
                                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/sql/inspections/SqlResolveInspection$1", "getAvailableFixes"));
                                    }
                                    if (expectedType == null) {
                                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "com/intellij/sql/inspections/SqlResolveInspection$1", "getAvailableFixes"));
                                    }
                                    PsiLanguageInjectionHost host = SqlResolveInspection.getInjectionHost((PsiElement)o);
                                    if (host != null) {
                                        List<LocalQuickFix> list = Collections.emptyList();
                                        if (list == null) {
                                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlResolveInspection$1", "getAvailableFixes"));
                                        }
                                        return list;
                                    }
                                    fixesList = ContainerUtil.newArrayList();
                                    if (expectedType != ObjectKind.TABLE) break block9;
                                    fixesList.add(new AddSqlTableFix(o));
                                    fixesList.add(new AddDbTableFix());
                                    break block10;
                                }
                                if (expectedType != ObjectKind.COLUMN || !(parent instanceof SqlReferenceExpression)) break block10;
                                SqlExpression qualifierExpression = ((SqlReferenceExpression)parent).getQualifierExpression();
                                pm = SmartPointerManager.getInstance((Project)manager.getProject());
                                if (!(qualifierExpression instanceof SqlReferenceExpression)) break block11;
                                PsiReference reference = qualifierExpression.getReference();
                                PsiElement psiElement = resolve = reference != null ? reference.resolve() : null;
                                if (!(resolve instanceof DbTable)) break block12;
                                fixesList.add(new AddDbColumnFix((SmartPsiElementPointer<DbTable>)pm.createSmartPsiElementPointer((PsiElement)((DbTable)resolve))));
                                break block10;
                            }
                            if (!(resolve instanceof SqlAsExpression) || !((expression = ((SqlAsExpression)resolve).getExpression()) instanceof SqlReferenceExpression)) break block10;
                            PsiReference expressionReference = expression.getReference();
                            PsiElement psiElement = resolveResult = expressionReference != null ? expressionReference.resolve() : null;
                            if (!(resolveResult instanceof DbTable)) break block13;
                            fixesList.add(new AddDbColumnFix((SmartPsiElementPointer<DbTable>)pm.createSmartPsiElementPointer((PsiElement)((DbTable)resolveResult))));
                            break block10;
                        }
                        if (!(resolveResult instanceof SqlCreateTableStatement)) break block10;
                        fixesList.add(new AddSqlColumnFix(o, (SmartPsiElementPointer<SqlCreateTableStatement>)pm.createSmartPsiElementPointer((PsiElement)((SqlCreateTableStatement)resolveResult))));
                        break block10;
                    }
                    PsiPolyVariantReference reference = ((SqlReferenceExpression)parent).getReference();
                    if (reference instanceof SqlReferenceImpl) {
                        if (this.myDataSources == null) {
                            this.myDataSources = SqlImplUtil.getDataSources((PsiElement)parent.getContainingFile());
                        }
                        MyResolveContextProcessor processor = new MyResolveContextProcessor(this.myDialect, this.myDataSources);
                        ((SqlReferenceImpl)reference).processResolveVariants(processor);
                        Set<DbTable> dbTables = processor.getDbTables();
                        Set<SqlCreateTableStatement> sqlTables = processor.getSqlTables();
                        for (DbTable dbTable : dbTables) {
                            fixesList.add(new AddDbColumnFix((SmartPsiElementPointer<DbTable>)pm.createSmartPsiElementPointer((PsiElement)dbTable)));
                        }
                        for (SqlCreateTableStatement sqlCreateTableStatement : sqlTables) {
                            fixesList.add(new AddSqlColumnFix(o, (SmartPsiElementPointer<SqlCreateTableStatement>)pm.createSmartPsiElementPointer((PsiElement)sqlCreateTableStatement)));
                        }
                    }
                }
                ArrayList arrayList = fixesList;
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlResolveInspection$1", "getAvailableFixes"));
                }
                return arrayList;
            }
        };
    }

    @Nullable
    private static PsiLanguageInjectionHost getInjectionHost(@NotNull PsiElement o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/sql/inspections/SqlResolveInspection", "getInjectionHost"));
        }
        return InjectedLanguageManager.getInstance((Project)o.getProject()).getInjectionHost(o);
    }

    @NotNull
    private static Collection<String> collectColumnNames(@NotNull SqlIdentifier element, @NotNull SqlStatement statement) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/inspections/SqlResolveInspection", "collectColumnNames"));
        }
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/sql/inspections/SqlResolveInspection", "collectColumnNames"));
        }
        SqlLanguageDialectEx sqlLanguage = SqlImplUtil.getSqlDialectSafe((PsiElement)statement);
        DatabaseDialectEx dialect = sqlLanguage.getDatabaseDialect();
        CasingProvider casingProvider = SqlImplUtil.getCasingProvider(sqlLanguage, SqlImplUtil.getDataSources((PsiElement)statement));
        SqlAsExpression asExpression = (SqlAsExpression)PsiTreeUtil.getParentOfType((PsiElement)element, SqlAsExpression.class);
        LinkedHashSet columnsNames = ContainerUtil.newLinkedHashSet();
        JBIterable iterable = SqlImplUtil.sqlTraverser((PsiElement)statement).filter(SqlReferenceExpression.class);
        for (SqlReferenceExpression e : iterable) {
            String qualifierText;
            ObjectKind type = e.getReferenceElementType().getTargetKind();
            PsiPolyVariantReference reference = e.getReference();
            SqlIdentifier identifier = e.getIdentifier();
            if (type != ObjectKind.COLUMN || identifier == null || reference.resolve() != null) continue;
            boolean isPlain = SqlImplUtil.hasPlainIdentifier(e, dialect);
            Case casing = casingProvider.getCasing(ObjectKind.COLUMN, null).choose(isPlain);
            SqlExpression qualifier = e.getQualifierExpression();
            PsiReference qualifierReference = qualifier != null ? qualifier.getReference() : null;
            String string = qualifierText = qualifier != null ? qualifier.getText() : null;
            if (asExpression != null && qualifierReference != null && !asExpression.equals(qualifierReference.resolve()) && !new NameChecker(qualifierText, casing, isPlain, sqlLanguage, casingProvider).checkName(element.getParent(), false)) continue;
            columnsNames.add(identifier.getText());
        }
        LinkedHashSet linkedHashSet = columnsNames;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlResolveInspection", "collectColumnNames"));
        }
        return linkedHashSet;
    }

    private static class MyResolveContextProcessor
    extends SqlScopeProcessor {
        private final Set<DbTable> myMyDbTables = new HashSet();
        private final Set<SqlCreateTableStatement> myMySqlTables = new HashSet();

        public MyResolveContextProcessor(SqlLanguageDialectEx dialect, Iterable<DbDataSource> dataSources) {
            super(true, dialect, dataSources);
        }

        @Override
        public boolean isResultEmpty() {
            return this.myMyDbTables.isEmpty() && this.myMySqlTables.isEmpty();
        }

        @Override
        public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object context) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/sql/inspections/SqlResolveInspection$MyResolveContextProcessor", "handleEvent"));
            }
            if (event != SqlScopeProcessor.RESOLVE_CONTEXT) {
                return;
            }
            if (!(context instanceof PsiElement)) {
                return;
            }
            if (context instanceof SqlDmlInstruction) {
                SqlExpression targetExpression = ((SqlDmlInstruction)context).getTargetExpression();
                this.processReference(targetExpression == null ? null : targetExpression.getReference());
            }
            PsiElement contextParent = ((PsiElement)context).getParent();
            PsiRecursiveElementVisitor visitor = new PsiRecursiveElementVisitor(){

                public void visitElement(PsiElement o) {
                    if (o instanceof SqlReferenceExpression) {
                        this.processReference(o.getReference());
                        return;
                    }
                    super.visitElement(o);
                }
            };
            if (contextParent instanceof SqlQueryExpression) {
                SqlTableExpression tableExpression = ((SqlQueryExpression)contextParent).getTableExpression();
                if (tableExpression != null) {
                    tableExpression.accept((PsiElementVisitor)visitor);
                }
            } else if (contextParent instanceof SqlTableColumnsList) {
                SqlReferenceExpression tableReference = ((SqlTableColumnsList)contextParent).getTableReference();
                this.processReference((PsiReference)(tableReference == null ? null : tableReference.getReference()));
            } else if (contextParent instanceof SqlTableExpression) {
                contextParent.accept((PsiElementVisitor)visitor);
            }
        }

        private void processReference(@Nullable PsiReference ref) {
            PsiElement resolve;
            PsiElement psiElement = resolve = ref != null ? ref.resolve() : null;
            if (resolve instanceof DbTable) {
                this.myMyDbTables.add((DbTable)resolve);
            } else if (resolve instanceof SqlCreateTableStatement) {
                this.myMySqlTables.add((SqlCreateTableStatement)resolve);
            }
        }

        @Override
        public boolean executeTarget(@Nullable DasObject target, @NotNull PsiElement element, @Nullable SqlType sqlType, Boolean forcedCaseSens, @NotNull ResolveState state) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/inspections/SqlResolveInspection$MyResolveContextProcessor", "executeTarget"));
            }
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/sql/inspections/SqlResolveInspection$MyResolveContextProcessor", "executeTarget"));
            }
            return true;
        }

        @NotNull
        public Set<DbTable> getDbTables() {
            Set<DbTable> set = this.myMyDbTables;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlResolveInspection$MyResolveContextProcessor", "getDbTables"));
            }
            return set;
        }

        @NotNull
        public Set<SqlCreateTableStatement> getSqlTables() {
            Set<SqlCreateTableStatement> set = this.myMySqlTables;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlResolveInspection$MyResolveContextProcessor", "getSqlTables"));
            }
            return set;
        }
    }

    private static class AddDbColumnFix
    extends DbQuickFix {
        private final SmartPsiElementPointer<DbTable> myTable;

        public AddDbColumnFix(SmartPsiElementPointer<DbTable> table) {
            this.myTable = table;
        }

        @NotNull
        public String getName() {
            DbTable element = (DbTable)this.myTable.getElement();
            String name = element == null ? "" : element.getName();
            String string = "Add column to '" + name + "' table";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlResolveInspection$AddDbColumnFix", "getName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/inspections/SqlResolveInspection$AddDbColumnFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/sql/inspections/SqlResolveInspection$AddDbColumnFix", "applyFix"));
            }
            final PsiElement element = descriptor.getPsiElement();
            if (element == null) {
                return;
            }
            final DbTable table = (DbTable)this.myTable.getElement();
            if (table == null) {
                return;
            }
            DbDataSource dataSource = DbImplUtil.getForcedDataSource(element.getContainingFile());
            if (dataSource == null) {
                return;
            }
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    DdlActions.AddColumnAction.perform(table, element.getText());
                }
            });
        }
    }

    private static class AddDbTableFix
    extends DbQuickFix {
        @NotNull
        public String getName() {
            if ("Add table to data source" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlResolveInspection$AddDbTableFix", "getName"));
            }
            return "Add table to data source";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            List strings;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/inspections/SqlResolveInspection$AddDbTableFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/sql/inspections/SqlResolveInspection$AddDbTableFix", "applyFix"));
            }
            final PsiElement element = descriptor.getPsiElement();
            if (element == null) {
                return;
            }
            DbDataSource dataSource = DbImplUtil.getForcedDataSource(element.getContainingFile());
            SqlStatement statement = (SqlStatement)PsiTreeUtil.getParentOfType((PsiElement)element, SqlStatement.class);
            Collection collection = strings = statement == null ? ContainerUtil.emptyList() : SqlResolveInspection.collectColumnNames((SqlIdentifier)element, statement);
            if (dataSource != null) {
                AddDbTableFix.showDialog(dataSource, element, strings);
            } else {
                Editor editor = PsiUtilBase.findEditor((PsiElement)element);
                if (editor != null) {
                    ArrayList runners = ContainerUtil.newArrayList();
                    for (final DbDataSource source : DbPsiFacade.getInstance((Project)project).getDataSources()) {
                        runners.add(new PersistenceConsoleProvider.Runner(){

                            public String getDisplayName() {
                                return source.getName();
                            }

                            public Icon getIcon() {
                                return source.getIcon();
                            }

                            public boolean isAlreadyRunning() {
                                return false;
                            }

                            public void run() {
                                AddDbTableFix.showDialog(source, element, strings);
                            }
                        });
                    }
                    RunQueryInConsoleIntentionAction.chooseAndRunRunners(runners, editor, null, "Choose Data Source");
                }
            }
        }

        private static void showDialog(final @NotNull DbDataSource source, final @NotNull PsiElement element, final @NotNull Collection<String> strings) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/sql/inspections/SqlResolveInspection$AddDbTableFix", "showDialog"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/inspections/SqlResolveInspection$AddDbTableFix", "showDialog"));
            }
            if (strings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings", "com/intellij/sql/inspections/SqlResolveInspection$AddDbTableFix", "showDialog"));
            }
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    DdlActions.AddTableAction.showAddTableDialogAndRun(source, null, element.getText(), strings);
                }
            });
        }
    }

    private static class AddSqlTableFix
    extends SqlEditorAwareFix<SqlIdentifier> {
        public AddSqlTableFix(SqlIdentifier o) {
            super(o);
        }

        @Override
        @NotNull
        public String getText() {
            String string = SqlMessages.message("quickfix.name.create.table.definition", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlResolveInspection$AddSqlTableFix", "getText"));
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull SqlIdentifier element, @Nullable Editor editor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/inspections/SqlResolveInspection$AddSqlTableFix", "applyFix"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/inspections/SqlResolveInspection$AddSqlTableFix", "applyFix"));
            }
            if (editor == null) {
                return;
            }
            SqlStatement placeForInsertBefore = (SqlStatement)PsiTreeUtil.getTopmostParentOfType((PsiElement)element, SqlStatement.class);
            SqlStatement statement = (SqlStatement)PsiTreeUtil.getParentOfType((PsiElement)element, SqlStatement.class);
            if (statement == null || placeForInsertBefore == null) {
                return;
            }
            Collection columnsNames = SqlResolveInspection.collectColumnNames(element, statement);
            int offset = placeForInsertBefore.getTextRange().getStartOffset();
            TemplateManager templateManager = TemplateManager.getInstance((Project)project);
            Template template = AddSqlTableFix.getTemplate(templateManager, (PsiElement)element, columnsNames);
            if (template == null) {
                return;
            }
            editor.getCaretModel().moveToOffset(offset);
            templateManager.startTemplate(editor, template);
        }

        @Nullable
        private static Template getTemplate(@NotNull TemplateManager templateManager, @NotNull PsiElement element, @NotNull Collection<String> columnsNames) {
            if (templateManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateManager", "com/intellij/sql/inspections/SqlResolveInspection$AddSqlTableFix", "getTemplate"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/inspections/SqlResolveInspection$AddSqlTableFix", "getTemplate"));
            }
            if (columnsNames == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnsNames", "com/intellij/sql/inspections/SqlResolveInspection$AddSqlTableFix", "getTemplate"));
            }
            if (columnsNames.isEmpty()) {
                TemplateImpl template = TemplateSettings.getInstance().getTemplate("tab", "SQL");
                if (template == null) {
                    return null;
                }
                TemplateImpl copy = template.copy();
                Variable variable = (Variable)copy.getVariables().get(0);
                assert ("table".equals(variable.getName()));
                variable.setDefaultValueString("\"" + element.getText() + "\"");
                variable.setAlwaysStopAt(false);
                return copy;
            }
            Template template = templateManager.createTemplate("", "");
            template.setToReformat(true);
            template.addTextSegment("create table " + element.getText() + " (\n");
            int size = columnsNames.size();
            int i = 0;
            for (String name : columnsNames) {
                template.addTextSegment(name);
                template.addTextSegment(" ");
                template.addVariable("type" + i, (Expression)new ConstantNode("int"), true);
                template.addTextSegment(" ");
                template.addVariable("not_null" + i, (Expression)new ConstantNode("not null"), true);
                if (i != size - 1) {
                    template.addTextSegment(",");
                }
                template.addTextSegment("\n");
                ++i;
            }
            template.addTextSegment(");\n");
            return template;
        }
    }

    private static class AddSqlColumnFix
    extends SqlEditorAwareFix<SqlIdentifier> {
        private final SmartPsiElementPointer<SqlCreateTableStatement> myTable;

        public AddSqlColumnFix(SqlIdentifier o, SmartPsiElementPointer<SqlCreateTableStatement> table) {
            super(o);
            this.myTable = table;
        }

        @Override
        @NotNull
        public String getText() {
            SqlCreateTableStatement element = (SqlCreateTableStatement)this.myTable.getElement();
            String name = element == null ? "" : element.getName();
            String string = "Add column to '" + name + "' table";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlResolveInspection$AddSqlColumnFix", "getText"));
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull SqlIdentifier element, @Nullable Editor editor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/inspections/SqlResolveInspection$AddSqlColumnFix", "applyFix"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/inspections/SqlResolveInspection$AddSqlColumnFix", "applyFix"));
            }
            if (editor == null) {
                return;
            }
            SqlCreateTableStatement table = (SqlCreateTableStatement)this.myTable.getElement();
            if (table == null) {
                return;
            }
            PsiColumn last = (PsiColumn)ContainerUtil.getLastItem((List)table.getColumns());
            int offset = -1;
            boolean insertComma = true;
            if (last == null) {
                ASTNode lParen = table.getNode().findChildByType((IElementType)SqlTokens.SQL_LEFT_PAREN);
                if (lParen != null) {
                    offset = lParen.getTextRange().getEndOffset();
                    insertComma = false;
                }
            } else {
                offset = last.getTextRange().getEndOffset();
            }
            if (offset == -1) {
                return;
            }
            TemplateManager instance = TemplateManager.getInstance((Project)project);
            TemplateImpl template = TemplateSettings.getInstance().getTemplate("col", "SQL");
            if (template == null) {
                return;
            }
            TemplateImpl copy = template.copy();
            Variable variable = (Variable)copy.getVariables().get(0);
            assert ("col".equals(variable.getName()));
            variable.setDefaultValueString("\"" + element.getText() + "\"");
            variable.setAlwaysStopAt(false);
            editor.getCaretModel().moveToOffset(offset);
            String newLine = (insertComma ? "," : "") + "\n";
            editor.getDocument().insertString(offset, (CharSequence)newLine);
            editor.getCaretModel().moveToOffset(offset + newLine.length());
            instance.startTemplate(editor, (Template)copy);
        }
    }

    private static abstract class DbQuickFix
    implements LocalQuickFix {
        private DbQuickFix() {
        }

        @NotNull
        public String getFamilyName() {
            if ("SQL" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlResolveInspection$DbQuickFix", "getFamilyName"));
            }
            return "SQL";
        }
    }
}

