/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.model.DasRoutine;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlInfoElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlSignatureInspection
extends SqlInspectionBase {
    @Override
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result, final boolean onTheFly) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/inspections/SqlSignatureInspection", "createAnnotationVisitor"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/sql/inspections/SqlSignatureInspection", "createAnnotationVisitor"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/sql/inspections/SqlSignatureInspection", "createAnnotationVisitor"));
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result){

            public void visitSqlFunctionCallExpression(SqlFunctionCallExpression o) {
                super.visitSqlFunctionCallExpression(o);
                if (this.shouldNotCheckElement((SqlElement)o)) {
                    return;
                }
                SqlReferenceExpression nameElement = o.getNameElement();
                if (nameElement == null) {
                    return;
                }
                BuiltinFunction def = o.getFunctionDefinition();
                SqlExpressionList params = o.getParameterList();
                if (params == null) {
                    return;
                }
                List nonPredefSigs = SqlSignatureInspection.getNonPredefSignatures(o);
                if (def != null && nameElement.getQualifierExpression() == null) {
                    if (SqlSignatureInspection.getSignatureNumber(o) != null) {
                        return;
                    }
                    if (nonPredefSigs.isEmpty()) {
                        this.reportProblem(o, def.getName());
                        return;
                    }
                }
                if (!nonPredefSigs.isEmpty() && SqlSignatureInspection.findSignature(o.getParameterList(), nonPredefSigs) == null) {
                    this.reportProblem(o, ((DasRoutine)nonPredefSigs.get(0)).getName());
                }
            }

            private void reportProblem(@NotNull SqlFunctionCallExpression ex, @NotNull String name) {
                if (ex == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ex", "com/intellij/sql/inspections/SqlSignatureInspection$1", "reportProblem"));
                }
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/sql/inspections/SqlSignatureInspection$1", "reportProblem"));
                }
                SqlReferenceExpression nameElement = ex.getNameElement();
                PsiElement el = (PsiElement)ObjectUtils.chooseNotNull((Object)(nameElement == null ? null : nameElement.getIdentifier()), (Object)ex);
                this.addDescriptor(this.myManager.createProblemDescriptor(el, name + " could not take such arguments", (LocalQuickFix)null, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, onTheFly));
            }
        };
    }

    @Nullable
    private static Number getSignatureNumber(@NotNull SqlFunctionCallExpression o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/sql/inspections/SqlSignatureInspection", "getSignatureNumber"));
        }
        SyntaxTraverser.ApiEx api = SyntaxTraverser.psiApiReversed();
        SqlExpressionList params = o.getParameterList();
        PsiElement element = params == null ? null : (PsiElement)api.children((Object)params).filter((Condition)new Condition<PsiElement>(){

            public boolean value(PsiElement element) {
                return SqlInfoElementType.getValue(element) instanceof Number;
            }
        }).first();
        return (Number)ObjectUtils.tryCast((Object)SqlInfoElementType.getValue(element), Number.class);
    }

    @NotNull
    private static List<DasRoutine> getNonPredefSignatures(@NotNull SqlFunctionCallExpression o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/sql/inspections/SqlSignatureInspection", "getNonPredefSignatures"));
        }
        List nonPredefSigs = ContainerUtil.newSmartList();
        SqlReferenceExpression nameElement = o.getNameElement();
        if (nameElement != null) {
            for (ResolveResult resolve : nameElement.multiResolve(false)) {
                if (resolve.getElement() == o) continue;
                ContainerUtil.addIfNotNull((Collection)nonPredefSigs, (Object)ObjectUtils.tryCast((Object)resolve.getElement(), DasRoutine.class));
            }
        }
        List list = nonPredefSigs;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlSignatureInspection", "getNonPredefSignatures"));
        }
        return list;
    }

    @Nullable
    private static DasRoutine findSignature(@Nullable SqlExpressionList args, @NotNull List<DasRoutine> protos) {
        if (protos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "protos", "com/intellij/sql/inspections/SqlSignatureInspection", "findSignature"));
        }
        return (DasRoutine)ContainerUtil.getFirstItem(protos);
    }
}

