/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections.suppression;

import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.lang.Commenter;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.inspections.suppression.SqlFileSuppressInspectionFix;
import com.intellij.sql.inspections.suppression.SqlSuppressInspectionFix;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.util.ObjectUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlInspectionSuppressor
implements InspectionSuppressor {
    private static final Pattern SUPPRESS_PATTERN = Pattern.compile("\\s*noinspection\\s+([a-zA-Z_0-9.-]+(\\s*,\\s*[a-zA-Z_0-9.-]+)*)\\s*\\w*");

    public boolean isSuppressedFor(@NotNull PsiElement element, @NotNull String toolId) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/inspections/suppression/SqlInspectionSuppressor", "isSuppressedFor"));
        }
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "com/intellij/sql/inspections/suppression/SqlInspectionSuppressor", "isSuppressedFor"));
        }
        if (!(element instanceof SqlElement) || !toolId.startsWith("Sql")) {
            return false;
        }
        if (SqlInspectionSuppressor.isSuppressedForFile(element.getContainingFile(), toolId)) {
            return true;
        }
        SqlStatement statement = (SqlStatement)PsiTreeUtil.getParentOfType((PsiElement)element, SqlStatement.class);
        return statement != null && SqlInspectionSuppressor.isSuppressedForStatement((PsiElement)statement, toolId);
    }

    private static boolean isSuppressedForFile(@NotNull PsiFile file, @NotNull String id) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/sql/inspections/suppression/SqlInspectionSuppressor", "isSuppressedForFile"));
        }
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/sql/inspections/suppression/SqlInspectionSuppressor", "isSuppressedForFile"));
        }
        PsiElement e = PsiTreeUtil.findChildOfAnyType((PsiElement)file, (Class[])new Class[]{PsiComment.class, SqlStatement.class});
        while (e instanceof PsiComment || e instanceof PsiWhiteSpace) {
            if (SqlInspectionSuppressor.isSuppressedInComment(e, id + "ForFile", SqlInspectionSuppressor.prefixLength(e))) {
                return true;
            }
            e = e.getNextSibling();
        }
        return false;
    }

    @NotNull
    public SuppressQuickFix[] getSuppressActions(@Nullable PsiElement element, @NotNull String toolId) {
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "com/intellij/sql/inspections/suppression/SqlInspectionSuppressor", "getSuppressActions"));
        }
        SuppressQuickFix[] suppressQuickFixArray = new SuppressQuickFix[]{new SqlSuppressInspectionFix(toolId, SqlStatement.class), new SqlFileSuppressInspectionFix(toolId)};
        if (suppressQuickFixArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/suppression/SqlInspectionSuppressor", "getSuppressActions"));
        }
        return suppressQuickFixArray;
    }

    private static boolean isSuppressedForStatement(@NotNull PsiElement element, @NotNull String toolId) {
        PsiElement parent;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/inspections/suppression/SqlInspectionSuppressor", "isSuppressedForStatement"));
        }
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "com/intellij/sql/inspections/suppression/SqlInspectionSuppressor", "isSuppressedForStatement"));
        }
        int prefixLength = SqlInspectionSuppressor.prefixLength(element);
        PsiElement prevSibling = element.getPrevSibling();
        if (prevSibling == null && (parent = element.getParent()) != null) {
            prevSibling = parent.getPrevSibling();
        }
        while (prevSibling instanceof PsiComment || prevSibling instanceof PsiWhiteSpace) {
            if (SqlInspectionSuppressor.isSuppressedInComment(prevSibling, toolId, prefixLength)) {
                return true;
            }
            prevSibling = prevSibling.getPrevSibling();
        }
        return false;
    }

    private static boolean isSuppressedInComment(@Nullable PsiElement e, @NotNull String toolId, int prefixLength) {
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "com/intellij/sql/inspections/suppression/SqlInspectionSuppressor", "isSuppressedInComment"));
        }
        if (!(e instanceof PsiComment)) {
            return false;
        }
        for (String line : StringUtil.splitByLines((String)e.getText())) {
            Matcher m;
            if (line.length() < prefixLength || !(m = SUPPRESS_PATTERN.matcher(line.substring(prefixLength))).matches() || !SuppressionUtil.isInspectionToolIdMentioned((String)m.group(1), (String)toolId)) continue;
            return true;
        }
        return false;
    }

    private static int prefixLength(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/inspections/suppression/SqlInspectionSuppressor", "prefixLength"));
        }
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(element.getContainingFile().getLanguage());
        String prefix = (String)ObjectUtils.notNull((Object)(commenter == null ? null : commenter.getLineCommentPrefix()), (Object)"");
        return prefix.length();
    }
}

