/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.intentions.SqlIntentionActionBase;
import com.intellij.sql.intentions.SqlIntentionUtil;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlResolveResult;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlQualifyIdentifierIntention
extends SqlIntentionActionBase {
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/intentions/SqlQualifyIdentifierIntention", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Qualify identifier" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/intentions/SqlQualifyIdentifierIntention", "getFamilyName"));
        }
        return "Qualify identifier";
    }

    @Nullable
    private static SqlIdentifier getTopmostIdentifier(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/intentions/SqlQualifyIdentifierIntention", "getTopmostIdentifier"));
        }
        SqlIdentifier identifier = SqlIntentionUtil.getIdentifier(element);
        if (identifier == null) {
            return null;
        }
        SqlReferenceExpression ref = (SqlReferenceExpression)ObjectUtils.tryCast((Object)identifier.getParent(), SqlReferenceExpression.class);
        while (ref != null && ref.getQualifierExpression() != null) {
            ref = (SqlReferenceExpression)ObjectUtils.tryCast((Object)ref.getQualifierExpression(), SqlReferenceExpression.class);
        }
        return ref == null ? identifier : ref.getIdentifier();
    }

    @Nullable
    private static String getName(@Nullable Object object) {
        DasObject obj = (DasObject)ObjectUtils.tryCast((Object)object, DasObject.class);
        if (obj != null && obj.getKind() != ObjectKind.NONE) {
            return StringUtil.nullize((String)obj.getName());
        }
        return null;
    }

    @NotNull
    private static Collection<String> getParentObjects(@Nullable SqlIdentifier identifier) {
        DasObject res;
        if (identifier == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/intentions/SqlQualifyIdentifierIntention", "getParentObjects"));
            }
            return list;
        }
        LinkedHashSet parents = ContainerUtil.newLinkedHashSet();
        PsiElement parent = identifier.getParent();
        PsiPolyVariantReference ref = (PsiPolyVariantReference)ObjectUtils.tryCast((Object)parent.getReference(), PsiPolyVariantReference.class);
        if (ref != null) {
            ResolveResult[] results;
            for (ResolveResult result : results = ref.multiResolve(false)) {
                SqlResolveResult sqlResult = (SqlResolveResult)ObjectUtils.tryCast((Object)result, SqlResolveResult.class);
                if (sqlResult == null) continue;
                if (sqlResult.getQualifier() != null) {
                    ContainerUtil.addIfNotNull((Collection)parents, (Object)SqlQualifyIdentifierIntention.getName(sqlResult.getQualifier()));
                    continue;
                }
                DasObject object = (DasObject)ObjectUtils.tryCast((Object)sqlResult.getElement(), DasObject.class);
                if (object != null) {
                    object = object.getDbParent();
                }
                ContainerUtil.addIfNotNull((Collection)parents, (Object)SqlQualifyIdentifierIntention.getName(object));
            }
        }
        if ((res = (DasObject)ObjectUtils.tryCast((Object)parent, DasObject.class)) != null) {
            res = res.getDbParent();
        }
        if (res != null) {
            ContainerUtil.addIfNotNull((Collection)parents, (Object)SqlQualifyIdentifierIntention.getName(res));
        }
        LinkedHashSet linkedHashSet = parents;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/intentions/SqlQualifyIdentifierIntention", "getParentObjects"));
        }
        return linkedHashSet;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/intentions/SqlQualifyIdentifierIntention", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/intentions/SqlQualifyIdentifierIntention", "isAvailable"));
        }
        SqlIdentifier identifier = SqlQualifyIdentifierIntention.getTopmostIdentifier(element);
        Collection<String> objects = SqlQualifyIdentifierIntention.getParentObjects(identifier);
        return !objects.isEmpty();
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/intentions/SqlQualifyIdentifierIntention", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/intentions/SqlQualifyIdentifierIntention", "invoke"));
        }
        final SqlIdentifier identifier = SqlQualifyIdentifierIntention.getTopmostIdentifier(element);
        ArrayList objects = ContainerUtil.newArrayList(SqlQualifyIdentifierIntention.getParentObjects(identifier));
        if (objects.isEmpty() || identifier == null) {
            return;
        }
        if (objects.size() == 1) {
            this.qualifyReference((String)objects.get(0), identifier);
            return;
        }
        JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<String>("Choose qualifier", (List)objects){

            public PopupStep onChosen(String selectedValue, boolean finalChoice) {
                SqlQualifyIdentifierIntention.this.qualifyReference(selectedValue, identifier);
                return FINAL_CHOICE;
            }
        }).showInBestPositionFor(editor);
    }

    private void qualifyReference(@NotNull String name, final @NotNull SqlIdentifier identifier) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/sql/intentions/SqlQualifyIdentifierIntention", "qualifyReference"));
        }
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/intellij/sql/intentions/SqlQualifyIdentifierIntention", "qualifyReference"));
        }
        SqlLanguageDialectEx dialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)identifier);
        final String quoted = dialectEx.quoteIdentifier(identifier.getProject(), name);
        PsiFile file = identifier.getContainingFile();
        if (file == null) {
            return;
        }
        final Document document = PsiDocumentManager.getInstance((Project)identifier.getProject()).getDocument(file);
        if (document == null) {
            return;
        }
        WriteCommandAction.runWriteCommandAction((Project)identifier.getProject(), (String)this.getText(), null, (Runnable)new Runnable(){

            @Override
            public void run() {
                document.insertString(identifier.getTextRange().getStartOffset(), (CharSequence)(quoted + "."));
            }
        }, (PsiFile[])new PsiFile[]{file});
    }
}

