/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi;

import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.LanguageSubstitutor;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.sql.dialects.SqlDialectMappings;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.testFramework.LightVirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlLanguageSubstitutor
extends LanguageSubstitutor {
    public Language getLanguage(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/sql/psi/SqlLanguageSubstitutor", "getLanguage"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/psi/SqlLanguageSubstitutor", "getLanguage"));
        }
        return SqlLanguageSubstitutor.getSqlLanguageDialectImpl(file, project);
    }

    @NotNull
    public static SqlLanguageDialect getSqlLanguageDialect(@Nullable VirtualFile file, @Nullable Project project) {
        Language language;
        FileType fileType = file == null ? null : file.getFileType();
        SqlLanguage fileLang = fileType instanceof LanguageFileType ? ((LanguageFileType)fileType).getLanguage() : SqlLanguage.INSTANCE;
        Language language2 = language = file == null || project == null ? null : LanguageSubstitutors.INSTANCE.substituteLanguage((Language)fileLang, file, project);
        if (language instanceof SqlLanguageDialect) {
            SqlLanguageDialect sqlLanguageDialect = (SqlLanguageDialect)language;
            if (sqlLanguageDialect == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/SqlLanguageSubstitutor", "getSqlLanguageDialect"));
            }
            return sqlLanguageDialect;
        }
        SqlLanguageDialect sqlLanguageDialect = SqlDialectMappings.getMapping(project, file);
        if (sqlLanguageDialect == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/SqlLanguageSubstitutor", "getSqlLanguageDialect"));
        }
        return sqlLanguageDialect;
    }

    @NotNull
    private static SqlLanguageDialect getSqlLanguageDialectImpl(@Nullable VirtualFile file, @Nullable Project project) {
        VirtualFile originalFile;
        while (file instanceof LightVirtualFile && (originalFile = ((LightVirtualFile)file).getOriginalFile()) != null) {
            file = originalFile;
        }
        Object language = file instanceof LightVirtualFile ? ((LightVirtualFile)file).getLanguage() : (file instanceof DatabaseElementVirtualFileImpl ? ((DatabaseElementVirtualFileImpl)file).getLanguage() : SqlDialectMappings.getMapping(project, file));
        if (language instanceof SqlLanguageDialect) {
            SqlLanguageDialect sqlLanguageDialect = (SqlLanguageDialect)language;
            if (sqlLanguageDialect == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/SqlLanguageSubstitutor", "getSqlLanguageDialectImpl"));
            }
            return sqlLanguageDialect;
        }
        VirtualFile hostFile = file instanceof VirtualFileWindow ? ((VirtualFileWindow)file).getDelegate() : null;
        SqlLanguageDialect sqlLanguageDialect = SqlDialectMappings.getMapping(project, hostFile);
        if (sqlLanguageDialect == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/SqlLanguageSubstitutor", "getSqlLanguageDialectImpl"));
        }
        return sqlLanguageDialect;
    }
}

