/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiColumn;
import com.intellij.database.util.DasUtil;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.sql.psi.SqlColumnAliasDefinition;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateViewStatement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.stubs.SqlStubbedDefinitionImpl;
import com.intellij.sql.psi.stubs.SqlTableStub;
import com.intellij.util.containers.JBIterable;
import icons.DatabaseIcons;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlCreateViewStatementImpl
extends SqlStubbedDefinitionImpl<SqlTableStub>
implements SqlCreateViewStatement {
    public SqlCreateViewStatementImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/psi/impl/SqlCreateViewStatementImpl", "<init>"));
        }
        super(node);
    }

    public SqlCreateViewStatementImpl(SqlTableStub stub) {
        super(stub, stub.getStubType());
    }

    @Override
    public void accept(SqlVisitor visitor) {
        visitor.visitSqlCreateViewStatement((SqlCreateViewStatement)this);
    }

    public SqlReferenceExpression getNameElement() {
        return (SqlReferenceExpression)super.getNameElement();
    }

    @Override
    protected SqlReferenceElementType getExpectedNameReferenceElementType() {
        return SqlCompositeElementTypes.SQL_TABLE_REFERENCE;
    }

    public DatabaseSystem getDataSource() {
        return null;
    }

    @Override
    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.VIEW;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlCreateViewStatementImpl", "getKind"));
        }
        return objectKind;
    }

    @Override
    @NotNull
    public <C> JBIterable<C> getDbChildren(@NotNull Class<C> clazz, @NotNull ObjectKind kind) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/sql/psi/impl/SqlCreateViewStatementImpl", "getDbChildren"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/sql/psi/impl/SqlCreateViewStatementImpl", "getDbChildren"));
        }
        JBIterable result = JBIterable.empty();
        if (kind == ObjectKind.COLUMN || kind == ObjectKind.NONE) {
            result = result.append(this.getColumns());
        }
        JBIterable jBIterable = result.filter(clazz);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlCreateViewStatementImpl", "getDbChildren"));
        }
        return jBIterable;
    }

    @NotNull
    public SqlColumnAliasDefinition[] getColumnAliases() {
        SqlColumnAliasDefinition[] sqlColumnAliasDefinitionArray = (SqlColumnAliasDefinition[])this.getStubOrPsiChildren(SqlCompositeElementTypes.SQL_COLUMN_ALIAS_DEFINITION, SqlColumnAliasDefinition.ARRAY_FACTORY);
        if (sqlColumnAliasDefinitionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlCreateViewStatementImpl", "getColumnAliases"));
        }
        return sqlColumnAliasDefinitionArray;
    }

    @NotNull
    public List<PsiColumn> getColumns() {
        List list = (List)CachedValuesManager.getCachedValue((PsiElement)this, (CachedValueProvider)new CachedValueProvider<List<PsiColumn>>(){

            public CachedValueProvider.Result<List<PsiColumn>> compute() {
                return CachedValueProvider.Result.create((Object)SqlCreateViewStatementImpl.this.calcColumns(), (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlCreateViewStatementImpl", "getColumns"));
        }
        return list;
    }

    @NotNull
    private List<PsiColumn> calcColumns() {
        SqlType type;
        SqlExpression expression = this.getExpression();
        SqlType sqlType = type = expression == null ? null : expression.getSqlType();
        if (!(type instanceof SqlTableType)) {
            List<PsiColumn> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlCreateViewStatementImpl", "calcColumns"));
            }
            return list;
        }
        SqlTableType tableType = (SqlTableType)type;
        SqlColumnAliasDefinition[] aliases = this.getColumnAliases();
        List<PsiColumn> list = SqlImplUtil.createColumnInfos((DasTable)this, tableType.alias(this.getName(), (PsiElement)this, Arrays.asList(aliases)));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlCreateViewStatementImpl", "calcColumns"));
        }
        return list;
    }

    @Nullable
    public SqlExpression getExpression() {
        SqlTableStub stub = (SqlTableStub)this.getStub();
        if (stub != null) {
            return stub.getExpression();
        }
        SqlExpression last = (SqlExpression)SqlImplUtil.childrenIt((PsiElement)this).filter(SqlExpression.class).last();
        return last == this.getNameElement() ? null : last;
    }

    @Override
    public Icon getIcon() {
        return DatabaseIcons.View;
    }

    public boolean isSystem() {
        return false;
    }

    public boolean isTemporary() {
        return false;
    }

    @NotNull
    public Set<DasColumn.Attribute> getColumnAttrs(@Nullable DasColumn columnInfo) {
        Set set = DasUtil.NO_ATTRS;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlCreateViewStatementImpl", "getColumnAttrs"));
        }
        return set;
    }
}

