/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl.lexer;

import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.TokenPattern;
import com.intellij.database.util.TokenPatternCache;
import com.intellij.lang.Language;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.lexer.PreprocessingLexer;
import com.intellij.util.PairFunction;
import java.util.regex.MatchResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlPreprocessingLexer
extends PreprocessingLexer {
    private int myMatchedStep;
    private int myNameGroup;

    public SqlPreprocessingLexer(Lexer lexer, TokenPattern pattern) {
        super(lexer, pattern);
    }

    @Override
    protected boolean skipToken(IElementType tokenType, boolean strict) {
        return SqlTokens.COMMENT_TOKENS.contains(tokenType) && strict || SqlTokens.STRING_TOKENS.contains(tokenType) || tokenType == SqlTokens.SQL_IDENT_DELIMITED;
    }

    @Override
    protected void onNextMatched() {
        this.myNameGroup = 0;
        this.myMatchedStep = 0;
        MatchResult match = this.getMatch();
        for (int i = match.groupCount(); i > 0; --i) {
            if (match.start(i) == -1) continue;
            this.myNameGroup = i;
            this.myMatchedStep = match.end(i) == match.end() ? 4 : 1;
        }
    }

    @Override
    protected boolean advanceInMatched() {
        if (this.myNameGroup == 0 || this.myMatchedStep == 3 || this.myMatchedStep == 5) {
            return false;
        }
        ++this.myMatchedStep;
        return true;
    }

    @Override
    protected IElementType getMatchedTokenType() {
        if (this.myNameGroup == 0) {
            return SqlTokens.SQL_EXTERNAL_PARAM;
        }
        switch (this.myMatchedStep) {
            case 1: {
                return SqlTokens.SQL_CUSTOM_PARAM_LQUOTE;
            }
            case 2: {
                return SqlTokens.SQL_IDENT;
            }
            case 3: {
                return SqlTokens.SQL_CUSTOM_PARAM_RQUOTE;
            }
            case 4: {
                return SqlTokens.SQL_EXTERNAL_PARAM_PREFIX;
            }
            case 5: {
                return SqlTokens.SQL_IDENT;
            }
        }
        throw new AssertionError();
    }

    @Override
    protected int getMatchedTokenStart() {
        if (this.myNameGroup == 0) {
            return super.getMatchedTokenStart();
        }
        switch (this.myMatchedStep) {
            case 1: 
            case 4: {
                return super.getMatchedTokenStart();
            }
            case 2: 
            case 5: {
                return this.getMatch().start(this.myNameGroup);
            }
            case 3: {
                return this.getMatch().end(this.myNameGroup);
            }
        }
        throw new AssertionError();
    }

    @Override
    protected int getMatchedTokenEnd() {
        if (this.myNameGroup == 0) {
            return super.getMatchedTokenEnd();
        }
        switch (this.myMatchedStep) {
            case 1: 
            case 4: {
                return this.getMatch().start(this.myNameGroup);
            }
            case 2: 
            case 5: {
                return this.getMatch().end(this.myNameGroup);
            }
            case 3: {
                return super.getMatchedTokenEnd();
            }
        }
        throw new AssertionError();
    }

    @NotNull
    public static Lexer withPreprocessingIfNeeded(@Nullable Project project, @NotNull ParserDefinition parserDefinition, @Nullable PsiElement injectionHost) {
        if (parserDefinition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parserDefinition", "com/intellij/sql/psi/impl/lexer/SqlPreprocessingLexer", "withPreprocessingIfNeeded"));
        }
        Lexer lexer = SqlPreprocessingLexer.withPreprocessingIfNeeded(parserDefinition.createLexer(project), parserDefinition.getFileNodeType().getLanguage(), SqlPreprocessingLexer.getHostLanguage(injectionHost), DatabaseSettings.getSettings());
        if (lexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/lexer/SqlPreprocessingLexer", "withPreprocessingIfNeeded"));
        }
        return lexer;
    }

    @Nullable
    public static Language getHostLanguage(@Nullable PsiElement injectionHost) {
        if (injectionHost == null) {
            return null;
        }
        Language language = injectionHost.getLanguage();
        if (language != SqlLanguage.getInstance()) {
            return language;
        }
        return SqlImplUtil.getSqlDialectSafe(injectionHost);
    }

    @NotNull
    public static Lexer withPreprocessingIfNeeded(@NotNull Lexer lexer, @NotNull Language language, @Nullable Language hostLanguage, @Nullable DatabaseSettings settings) {
        if (lexer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexer", "com/intellij/sql/psi/impl/lexer/SqlPreprocessingLexer", "withPreprocessingIfNeeded"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/sql/psi/impl/lexer/SqlPreprocessingLexer", "withPreprocessingIfNeeded"));
        }
        Lexer lexer2 = SqlPreprocessingLexer.withPreprocessingIfNeeded(lexer, language, hostLanguage, settings, (PairFunction<Lexer, TokenPattern, ? extends PreprocessingLexer>)new PairFunction<Lexer, TokenPattern, PreprocessingLexer>(){

            public PreprocessingLexer fun(Lexer t, TokenPattern v) {
                return new SqlPreprocessingLexer(t, v);
            }
        });
        if (lexer2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/lexer/SqlPreprocessingLexer", "withPreprocessingIfNeeded"));
        }
        return lexer2;
    }

    @NotNull
    public static Lexer withPreprocessingIfNeeded(@NotNull Lexer lexer, @NotNull Language language, @Nullable Language hostLanguage, @Nullable DatabaseSettings settings, @NotNull PairFunction<Lexer, TokenPattern, ? extends PreprocessingLexer> factory) {
        if (lexer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexer", "com/intellij/sql/psi/impl/lexer/SqlPreprocessingLexer", "withPreprocessingIfNeeded"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/sql/psi/impl/lexer/SqlPreprocessingLexer", "withPreprocessingIfNeeded"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/sql/psi/impl/lexer/SqlPreprocessingLexer", "withPreprocessingIfNeeded"));
        }
        if (settings != null) {
            TokenPattern pattern;
            lexer = hostLanguage != null ? ((pattern = TokenPatternCache.getPattern(settings, true, hostLanguage)) == null ? lexer : (Lexer)factory.fun((Object)lexer, (Object)pattern)) : ((pattern = TokenPatternCache.getPattern(settings, false, language)) == null ? lexer : (Lexer)factory.fun((Object)lexer, (Object)pattern));
        }
        Lexer lexer2 = lexer;
        if (lexer2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/lexer/SqlPreprocessingLexer", "withPreprocessingIfNeeded"));
        }
        return lexer2;
    }
}

