/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.psi.SqlAlterTableInstruction;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.stubs.SqlAlterTableInstructionElementStub;
import com.intellij.sql.psi.stubs.SqlStubElementType;
import com.intellij.sql.psi.stubs.SqlSynonymDefinitionElementType;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.NotNullFunction;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SqlAlterTableInstructionStubElementType
extends SqlStubElementType<SqlAlterTableInstructionElementStub, SqlAlterTableInstruction> {
    public static final NotNullFunction<String, SqlAlterTableInstructionStubElementType> FACTORY = new NotNullFunction<String, SqlAlterTableInstructionStubElementType>(){

        @NotNull
        public SqlAlterTableInstructionStubElementType fun(String name) {
            SqlAlterTableInstructionStubElementType sqlAlterTableInstructionStubElementType = new SqlAlterTableInstructionStubElementType(name);
            if (sqlAlterTableInstructionStubElementType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/stubs/SqlAlterTableInstructionStubElementType$1", "fun"));
            }
            return sqlAlterTableInstructionStubElementType;
        }
    };

    public SqlAlterTableInstructionStubElementType(@NonNls @NotNull String debugName) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "com/intellij/sql/psi/stubs/SqlAlterTableInstructionStubElementType", "<init>"));
        }
        super(debugName);
    }

    public SqlAlterTableInstructionElementStub createStub(@NotNull SqlAlterTableInstruction psi, StubElement parentStub) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/sql/psi/stubs/SqlAlterTableInstructionStubElementType", "createStub"));
        }
        return new SqlAlterTableInstructionElementStub(parentStub, psi.getInstructionType());
    }

    public void serialize(@NotNull SqlAlterTableInstructionElementStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/sql/psi/stubs/SqlAlterTableInstructionStubElementType", "serialize"));
        }
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/sql/psi/stubs/SqlAlterTableInstructionStubElementType", "serialize"));
        }
        IElementType instructionType = stub.getInstructionType();
        dataStream.writeUTFFast(instructionType == null ? "" : instructionType.toString());
    }

    @NotNull
    public SqlAlterTableInstructionElementStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/sql/psi/stubs/SqlAlterTableInstructionStubElementType", "deserialize"));
        }
        String name = StringUtil.notNullize((String)dataStream.readUTFFast());
        IElementType type = SqlTokenRegistry.findType((String)name);
        SqlAlterTableInstructionElementStub sqlAlterTableInstructionElementStub = new SqlAlterTableInstructionElementStub(parentStub, type);
        if (sqlAlterTableInstructionElementStub == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/stubs/SqlAlterTableInstructionStubElementType", "deserialize"));
        }
        return sqlAlterTableInstructionElementStub;
    }

    @Override
    public boolean shouldCreateStub(ASTNode node) {
        IElementType instructionType;
        if (!super.shouldCreateStub(node)) {
            return false;
        }
        ASTNode firstChild = node.getFirstChildNode();
        IElementType iElementType = instructionType = firstChild != null ? firstChild.getElementType() : null;
        if (instructionType == SqlCommonKeywords.SQL_ADD) {
            return true;
        }
        ASTNode lastChildNode = node.getLastChildNode();
        return lastChildNode != null && lastChildNode.getElementType() instanceof SqlSynonymDefinitionElementType;
    }
}

