/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.stubs;

import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.impl.SqlForeignKeyDefinitionImpl;
import com.intellij.sql.psi.stubs.SqlForeignKeyStub;
import com.intellij.sql.psi.stubs.SqlStubElementType;
import com.intellij.sql.psi.stubs.SqlTableKeyElementType;
import com.intellij.util.NotNullFunction;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SqlForeignKeyElementType
extends SqlStubElementType<SqlForeignKeyStub, SqlForeignKeyDefinitionImpl> {
    public static final NotNullFunction<String, SqlForeignKeyElementType> FACTORY = new NotNullFunction<String, SqlForeignKeyElementType>(){

        @NotNull
        public SqlForeignKeyElementType fun(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/sql/psi/stubs/SqlForeignKeyElementType$1", "fun"));
            }
            SqlForeignKeyElementType sqlForeignKeyElementType = new SqlForeignKeyElementType(name);
            if (sqlForeignKeyElementType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/stubs/SqlForeignKeyElementType$1", "fun"));
            }
            return sqlForeignKeyElementType;
        }
    };

    public SqlForeignKeyElementType(@NonNls @NotNull String debugName) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "com/intellij/sql/psi/stubs/SqlForeignKeyElementType", "<init>"));
        }
        super(debugName);
    }

    public SqlForeignKeyStub createStub(@NotNull SqlForeignKeyDefinitionImpl psi, StubElement parentStub) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/sql/psi/stubs/SqlForeignKeyElementType", "createStub"));
        }
        String tableName = psi.getTableName();
        Iterable columnNames = psi.getColumnsRef().names();
        String keyText = tableName == null ? null : SqlTableKeyElementType.tableColumnList(tableName, columnNames);
        SqlTableColumnsList tableColumnsList = (SqlTableColumnsList)PsiTreeUtil.getChildOfType((PsiElement)psi, SqlTableColumnsList.class);
        return new SqlForeignKeyStub(parentStub, this, SqlForeignKeyElementType.asStringRef((PsiElement)psi.getNameElement()), keyText == null ? null : StringRef.fromString((String)keyText), tableColumnsList == null ? null : StringRef.fromString((String)tableColumnsList.getText()));
    }

    public void serialize(@NotNull SqlForeignKeyStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/sql/psi/stubs/SqlForeignKeyElementType", "serialize"));
        }
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/sql/psi/stubs/SqlForeignKeyElementType", "serialize"));
        }
        dataStream.writeName(stub.getName());
        dataStream.writeName(stub.getKeyText());
        dataStream.writeName(stub.getRefKeyText());
    }

    @NotNull
    public SqlForeignKeyStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/sql/psi/stubs/SqlForeignKeyElementType", "deserialize"));
        }
        SqlForeignKeyStub sqlForeignKeyStub = new SqlForeignKeyStub(parentStub, this, dataStream.readName(), dataStream.readName(), dataStream.readName());
        if (sqlForeignKeyStub == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/stubs/SqlForeignKeyElementType", "deserialize"));
        }
        return sqlForeignKeyStub;
    }
}

