/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.script;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ReadOnlyASTNode
extends UserDataHolderBase
implements ASTNode {
    private final ReadOnlyASTNode myParent;
    private final int myIndex;

    public ReadOnlyASTNode(ReadOnlyASTNode parent, int index) {
        this.myParent = parent;
        this.myIndex = index;
    }

    public abstract List<ASTNode> getChildList();

    public ReadOnlyASTNode getTreeParent() {
        return this.myParent;
    }

    public <T extends PsiElement> T getPsi(@NotNull Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/sql/script/ReadOnlyASTNode", "getPsi"));
        }
        return (T)((PsiElement)ObjectUtils.tryCast((Object)this.getPsi(), clazz));
    }

    public ASTNode getFirstChildNode() {
        return (ASTNode)ContainerUtil.getFirstItem(this.getChildList());
    }

    public ASTNode getLastChildNode() {
        return (ASTNode)ContainerUtil.getLastItem(this.getChildList());
    }

    public ASTNode getTreeNext() {
        List<ASTNode> list = this.getTreeParent().getChildList();
        return list.size() > this.myIndex + 1 ? list.get(this.myIndex + 1) : null;
    }

    public ASTNode getTreePrev() {
        return this.myIndex > 0 ? this.getTreeParent().getChildList().get(this.myIndex - 1) : null;
    }

    @NotNull
    public ASTNode[] getChildren(@Nullable TokenSet filter) {
        List<ASTNode> list = this.getChildList();
        if (list.isEmpty()) {
            if (EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/script/ReadOnlyASTNode", "getChildren"));
            }
            return EMPTY_ARRAY;
        }
        if (filter != null) {
            int count = 0;
            for (ASTNode node : list) {
                if (!filter.contains(node.getElementType())) continue;
                ++count;
            }
            ASTNode[] result = new ASTNode[count];
            count = 0;
            for (ASTNode node : list) {
                if (!filter.contains(node.getElementType())) continue;
                result[count++] = node;
            }
            if (result == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/script/ReadOnlyASTNode", "getChildren"));
            }
            return result;
        }
        ASTNode[] aSTNodeArray = list.toArray(new ASTNode[list.size()]);
        if (aSTNodeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/script/ReadOnlyASTNode", "getChildren"));
        }
        return aSTNodeArray;
    }

    @NotNull
    public String getText() {
        String string = this.getChars().toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/script/ReadOnlyASTNode", "getText"));
        }
        return string;
    }

    public boolean textContains(char c) {
        return StringUtil.indexOf((CharSequence)this.getChars(), (char)c) >= 0;
    }

    public int getStartOffset() {
        return this.getTextRange().getStartOffset();
    }

    public int getTextLength() {
        return this.getTextRange().getLength();
    }

    @NotNull
    public ReadOnlyASTNode clone() {
        ReadOnlyASTNode readOnlyASTNode = this;
        if (readOnlyASTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/script/ReadOnlyASTNode", "clone"));
        }
        return readOnlyASTNode;
    }

    public void addChild(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/sql/script/ReadOnlyASTNode", "addChild"));
        }
        throw new UnsupportedOperationException();
    }

    public void addChild(@NotNull ASTNode child, @Nullable ASTNode anchorBefore) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/sql/script/ReadOnlyASTNode", "addChild"));
        }
        throw new UnsupportedOperationException();
    }

    public void addLeaf(@NotNull IElementType leafType, CharSequence leafText, @Nullable ASTNode anchorBefore) {
        if (leafType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leafType", "com/intellij/sql/script/ReadOnlyASTNode", "addLeaf"));
        }
        throw new UnsupportedOperationException();
    }

    public void removeChild(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/sql/script/ReadOnlyASTNode", "removeChild"));
        }
        throw new UnsupportedOperationException();
    }

    public void removeRange(@NotNull ASTNode firstNodeToRemove, ASTNode firstNodeToKeep) {
        if (firstNodeToRemove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "firstNodeToRemove", "com/intellij/sql/script/ReadOnlyASTNode", "removeRange"));
        }
        throw new UnsupportedOperationException();
    }

    public void replaceChild(@NotNull ASTNode oldChild, @NotNull ASTNode newChild) {
        if (oldChild == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldChild", "com/intellij/sql/script/ReadOnlyASTNode", "replaceChild"));
        }
        if (newChild == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newChild", "com/intellij/sql/script/ReadOnlyASTNode", "replaceChild"));
        }
        throw new UnsupportedOperationException();
    }

    public void replaceAllChildrenToChildrenOf(ASTNode anotherParent) {
        throw new UnsupportedOperationException();
    }

    public void addChildren(ASTNode firstChild, ASTNode firstChildToNotAdd, ASTNode anchorBefore) {
        throw new UnsupportedOperationException();
    }

    public ASTNode copyElement() {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public ASTNode findLeafElementAt(int offset) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public ASTNode findChildByType(IElementType type) {
        return this.findChildByType(type, null);
    }

    @Nullable
    public ASTNode findChildByType(IElementType type, @Nullable ASTNode anchor) {
        boolean flag = anchor == null;
        for (ASTNode node : this.getChildren(null)) {
            if (!flag && node.equals(anchor)) {
                flag = true;
            }
            if (!flag || node.getElementType() != type) continue;
            return node;
        }
        return null;
    }

    @Nullable
    public ASTNode findChildByType(@NotNull TokenSet typesSet) {
        if (typesSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typesSet", "com/intellij/sql/script/ReadOnlyASTNode", "findChildByType"));
        }
        return this.findChildByType(typesSet, null);
    }

    @Nullable
    public ASTNode findChildByType(@NotNull TokenSet typesSet, @Nullable ASTNode anchor) {
        if (typesSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typesSet", "com/intellij/sql/script/ReadOnlyASTNode", "findChildByType"));
        }
        boolean flag = anchor == null;
        for (ASTNode node : this.getChildren(null)) {
            if (!flag && node.equals(anchor)) {
                flag = true;
            }
            if (!flag || !typesSet.contains(node.getElementType())) continue;
            return node;
        }
        return null;
    }
}

