/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.script;

import com.intellij.database.script.TooLongStatementException;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.LightPsiParser;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.IsExternal;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.impl.lexer.SqlPreprocessingLexer;
import com.intellij.sql.psi.stubs.SqlFileElementType;
import com.intellij.sql.script.ReadOnlySqlFile;
import com.intellij.sql.script.SqlReader;
import com.intellij.sql.script.TraverserBasedASTNode;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.TreeTraversal;
import com.intellij.util.text.CharArrayCharSequence;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlReaderImpl
extends SqlReader {
    private static final Logger LOG = Logger.getInstance(SqlReaderImpl.class);
    private static final int READER_BUF_SIZE = 102400;
    private static final int PARSER_CHUNK = 1024000;
    private final Project myProject;
    private final Language myHostLanguage;

    public SqlReaderImpl(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/script/SqlReaderImpl", "<init>"));
        }
        this(project, null);
    }

    public SqlReaderImpl(@NotNull Project project, @Nullable Language hostLanguage) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/script/SqlReaderImpl", "<init>"));
        }
        this.myProject = project;
        this.myHostLanguage = hostLanguage;
    }

    @NotNull
    public SqlFile getReadOnlyPsi(@NotNull SqlLanguageDialect language, @NotNull CharSequence text) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/sql/script/SqlReaderImpl", "getReadOnlyPsi"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/sql/script/SqlReaderImpl", "getReadOnlyPsi"));
        }
        SqlFile sqlFile = SqlReaderImpl.asPsi(SqlReaderImpl.sqlTraverser(this.myProject, language, text, null, this.myHostLanguage), PsiManager.getInstance((Project)this.myProject));
        if (sqlFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/script/SqlReaderImpl", "getReadOnlyPsi"));
        }
        return sqlFile;
    }

    @NotNull
    public static SqlFile asPsi(@NotNull SyntaxTraverser<LighterASTNode> traverser, @NotNull PsiManager manager) {
        if (traverser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traverser", "com/intellij/sql/script/SqlReaderImpl", "asPsi"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/sql/script/SqlReaderImpl", "asPsi"));
        }
        LighterASTNode root = (LighterASTNode)ObjectUtils.assertNotNull((Object)traverser.getRoot());
        Language language = root.getTokenType().getLanguage();
        SingleRootFileViewProvider viewProvider = new SingleRootFileViewProvider(manager, (VirtualFile)new LightVirtualFile("x", language, (CharSequence)""), false);
        final Ref fileRef = Ref.create();
        FileASTNode fileNode = TraverserBasedASTNode.createFileNode(traverser, root, new Getter<PsiFile>(){

            public PsiFile get() {
                return (PsiFile)fileRef.get();
            }
        });
        ReadOnlySqlFile file = new ReadOnlySqlFile(viewProvider, fileNode);
        fileRef.set((Object)file);
        file.putUserData(PART_OFFSET, traverser.getUserData(PART_OFFSET));
        file.putUserData(PART_INDEX, traverser.getUserData(PART_INDEX));
        ReadOnlySqlFile readOnlySqlFile = file;
        if (readOnlySqlFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/script/SqlReaderImpl", "asPsi"));
        }
        return readOnlySqlFile;
    }

    @NotNull
    public SyntaxTraverser<LighterASTNode> parseSql(@NotNull SqlLanguageDialect language, @NotNull CharSequence charSequence) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/sql/script/SqlReaderImpl", "parseSql"));
        }
        if (charSequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charSequence", "com/intellij/sql/script/SqlReaderImpl", "parseSql"));
        }
        SyntaxTraverser<LighterASTNode> syntaxTraverser = SqlReaderImpl.sqlTraverser(this.myProject, language, charSequence, null, this.myHostLanguage);
        if (syntaxTraverser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/script/SqlReaderImpl", "parseSql"));
        }
        return syntaxTraverser;
    }

    private static SyntaxTraverser<LighterASTNode> sqlTraverser(@NotNull Project project, @NotNull SqlLanguageDialect language, @NotNull CharSequence charSequence, @Nullable IElementType forcedRootType, @Nullable Language hostLanguage) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/script/SqlReaderImpl", "sqlTraverser"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/sql/script/SqlReaderImpl", "sqlTraverser"));
        }
        if (charSequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charSequence", "com/intellij/sql/script/SqlReaderImpl", "sqlTraverser"));
        }
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((Language)language);
        Lexer lexer = SqlPreprocessingLexer.withPreprocessingIfNeeded(parserDefinition.createLexer(project), (Language)language, hostLanguage, DatabaseSettings.getSettings());
        LightPsiParser parser = (LightPsiParser)parserDefinition.createParser(project);
        PsiBuilder builder = PsiBuilderFactory.getInstance().createBuilder(parserDefinition, lexer, charSequence);
        IElementType rootType = (IElementType)ObjectUtils.notNull((Object)forcedRootType, (Object)parserDefinition.getFileNodeType());
        parser.parseLight(rootType, builder);
        return SyntaxTraverser.lightTraverser((PsiBuilder)builder);
    }

    public JBIterable<SyntaxTraverser<LighterASTNode>> parseSql(final @NotNull SqlLanguageDialect language, final @NotNull VirtualFile virtualFile, final @NotNull Disposable disposable) {
        Document document;
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/sql/script/SqlReaderImpl", "parseSql"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/sql/script/SqlReaderImpl", "parseSql"));
        }
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/sql/script/SqlReaderImpl", "parseSql"));
        }
        Document document2 = document = SingleRootFileViewProvider.isTooLargeForIntelligence((VirtualFile)virtualFile) ? null : FileDocumentManager.getInstance().getDocument(virtualFile);
        if (document != null) {
            return JBIterable.of((Object[])new SyntaxTraverser[]{SqlReaderImpl.getStatementTraverser(this.parseSql(language, document.getText()))});
        }
        return new JBIterable<SyntaxTraverser<LighterASTNode>>(){

            @NotNull
            public Iterator<SyntaxTraverser<LighterASTNode>> iterator() {
                Iterator iterator;
                try {
                    long length = virtualFile.getLength();
                    final InputStreamReader reader = new InputStreamReader(virtualFile.getInputStream(), virtualFile.getCharset());
                    Disposable inputDisposable = new Disposable(){

                        public void dispose() {
                            try {
                                reader.close();
                            }
                            catch (Exception e) {
                                LOG.warn((Throwable)e);
                            }
                        }
                    };
                    Disposer.register((Disposable)disposable, (Disposable)inputDisposable);
                    iterator = SqlReaderImpl.processSyntaxImpl(SqlReaderImpl.this.myProject, (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((Language)language), reader, length, inputDisposable);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
                if (iterator == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/script/SqlReaderImpl$2", "iterator"));
                }
                return iterator;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private static Iterator<SyntaxTraverser<LighterASTNode>> processSyntaxImpl(final @NotNull Project project, final @NotNull ParserDefinition parserDefinition, final @NotNull Reader reader, final long fileSize, @NotNull Disposable disposable) throws IOException {
        void inputDisposable;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/script/SqlReaderImpl", "processSyntaxImpl"));
        }
        if (parserDefinition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parserDefinition", "com/intellij/sql/script/SqlReaderImpl", "processSyntaxImpl"));
        }
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/sql/script/SqlReaderImpl", "processSyntaxImpl"));
        }
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputDisposable", "com/intellij/sql/script/SqlReaderImpl", "processSyntaxImpl"));
        }
        return new Iterator<SyntaxTraverser<LighterASTNode>>((Disposable)inputDisposable){
            long myMaxMemory = Runtime.getRuntime().maxMemory();
            int myChunkSize = 1024000;
            Lexer lexer = parserDefinition.createLexer(project);
            LightPsiParser parser = (LightPsiParser)parserDefinition.createParser(project);
            PsiBuilderFactory psiBuilderFactory = PsiBuilderFactory.getInstance();
            StringBuilder text = new StringBuilder(this.myChunkSize);
            char[] buf = new char[Math.min(102400, this.myChunkSize)];
            CharArrayCharSequence seq = new CharArrayCharSequence(this.buf);
            Exception error;
            boolean bufferPrepared;
            int partIndex;
            long partOffset;
            final /* synthetic */ Disposable val$inputDisposable;
            {
                this.val$inputDisposable = disposable;
            }

            @Override
            public boolean hasNext() {
                return this.bufferPrepared || this.prepareBuffer();
            }

            @Override
            public SyntaxTraverser<LighterASTNode> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                while (true) {
                    try {
                        SyntaxTraverser<LighterASTNode> s = this.buildTraverser();
                        this.bufferPrepared = false;
                        return s;
                    }
                    catch (TooLongStatementException e) {
                        if ((long)this.myChunkSize > this.myMaxMemory / 16L) {
                            throw e;
                        }
                        LOG.info(e.getMessage());
                        LOG.info("increasing parser buffer to: " + StringUtil.formatFileSize((long)this.myChunkSize) + " (file size " + StringUtil.formatFileSize((long)fileSize) + ")");
                        this.myChunkSize *= 2;
                        this.prepareBuffer();
                        continue;
                    }
                    break;
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            boolean prepareBuffer() {
                int read;
                do {
                    try {
                        read = reader.read(this.buf);
                    }
                    catch (IOException e) {
                        this.error = e;
                        return false;
                    }
                    if ((read > 0 || this.text.length() <= 0) && (read <= 0 || this.text.append(this.seq.subSequence(0, read)).length() < this.myChunkSize)) continue;
                    this.bufferPrepared = true;
                    return true;
                } while (read > 0);
                Disposer.dispose((Disposable)this.val$inputDisposable);
                return false;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private SyntaxTraverser<LighterASTNode> buildTraverser() {
                int lastOffset;
                boolean isLast = this.text.length() < this.myChunkSize;
                String str = this.text.toString();
                SyntaxTraverser<LighterASTNode> traverser = this.parseImpl(str);
                int firstOffset = 0;
                if (!isLast) {
                    LighterASTNode lastToSkip = (LighterASTNode)traverser.getRawDeepestLast();
                    if (lastToSkip != null && traverser.api.typeOf((Object)lastToSkip) == SqlCompositeElementTypes.SQL_INSERT_STATEMENT && traverser.api.rangeOf((Object)lastToSkip).getStartOffset() == 0) {
                        SyntaxTraverser s = (SyntaxTraverser)traverser.reset();
                        LighterASTNode valuesExpr = (LighterASTNode)s.filterTypes(Conditions.equalTo((Object)SqlCompositeElementTypes.SQL_VALUES_EXPRESSION)).traverse().first();
                        LighterASTNode valuesNode = (LighterASTNode)s.filterTypes(Conditions.equalTo((Object)SqlCommonKeywords.SQL_VALUES)).traverse().first();
                        Condition isParExpr = Conditions.compose((Function)s.api.TO_TYPE(), (Condition)Conditions.equalTo((Object)SqlCompositeElementTypes.SQL_PARENTHESIZED_EXPRESSION));
                        JBIterable parExprs = ((SyntaxTraverser)((SyntaxTraverser)((SyntaxTraverser)s.withRoot((Object)valuesExpr)).expand(Conditions.equalTo((Object)valuesExpr))).filter(isParExpr)).traverse();
                        LighterASTNode last = null;
                        LighterASTNode prev = null;
                        for (LighterASTNode expr : parExprs) {
                            prev = last;
                            last = expr;
                        }
                        if (valuesNode == null || last == null || prev == null) throw this.tooLongStatement(traverser, lastToSkip);
                        lastToSkip = last;
                        firstOffset = traverser.api.rangeOf((Object)valuesNode).getEndOffset() + 1;
                        traverser = this.parseImpl(str.substring(0, traverser.api.rangeOf((Object)prev).getEndOffset()));
                    } else {
                        if (lastToSkip == null || traverser.api.rangeOf((Object)lastToSkip).getStartOffset() == 0) {
                            throw this.tooLongStatement(traverser, lastToSkip);
                        }
                        final LighterASTNode forceIgnore = lastToSkip;
                        traverser = (SyntaxTraverser<LighterASTNode>)traverser.forceIgnore((Condition)new Condition<LighterASTNode>(){

                            public boolean value(LighterASTNode input) {
                                return input == forceIgnore;
                            }
                        });
                    }
                    lastOffset = traverser.api.rangeOf((Object)lastToSkip).getStartOffset();
                    this.text = this.text.delete(firstOffset, lastOffset);
                } else {
                    lastOffset = this.text.length();
                    this.text.setLength(0);
                }
                traverser.putUserData(SqlReader.PART_INDEX, (Object)this.partIndex++);
                traverser.putUserData(SqlReader.PART_OFFSET, (Object)this.partOffset);
                this.partOffset += (long)lastOffset;
                return traverser;
            }

            @NotNull
            private SyntaxTraverser<LighterASTNode> parseImpl(String s) {
                PsiBuilder builder = this.psiBuilderFactory.createBuilder(parserDefinition, this.lexer, (CharSequence)s);
                this.parser.parseLight((IElementType)parserDefinition.getFileNodeType(), builder);
                SyntaxTraverser syntaxTraverser = SqlReaderImpl.getStatementTraverser(SyntaxTraverser.lightTraverser((PsiBuilder)builder));
                if (syntaxTraverser == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/script/SqlReaderImpl$3", "parseImpl"));
                }
                return syntaxTraverser;
            }

            @NotNull
            private TooLongStatementException tooLongStatement(SyntaxTraverser<LighterASTNode> traverser, LighterASTNode lastToSkip) {
                TooLongStatementException tooLongStatementException = new TooLongStatementException((lastToSkip == null ? "<unknown>" : traverser.api.typeOf((Object)lastToSkip)) + " statement is longer than " + StringUtil.formatFileSize((long)this.myChunkSize));
                if (tooLongStatementException == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/script/SqlReaderImpl$3", "tooLongStatement"));
                }
                return tooLongStatementException;
            }
        };
    }

    @NotNull
    public static <E> SyntaxTraverser<E> getStatementTraverser(@NotNull SyntaxTraverser<E> s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/sql/script/SqlReaderImpl", "getStatementTraverser"));
        }
        SyntaxTraverser syntaxTraverser = (SyntaxTraverser)((SyntaxTraverser)s.forceDisregardTypes(Conditions.equalTo((Object)SqlElementTypes.SQL_DUMMY_BLOCK)).expand(Conditions.alwaysFalse())).filterTypes(SqlReaderImpl.sqlTypesCondition()).withTraversal(TreeTraversal.LEAVES_DFS);
        if (syntaxTraverser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/script/SqlReaderImpl", "getStatementTraverser"));
        }
        return syntaxTraverser;
    }

    @NotNull
    public static Condition<IElementType> sqlTypesCondition() {
        Condition<IElementType> condition = new Condition<IElementType>(){

            public boolean value(IElementType t) {
                if (t instanceof IsExternal) {
                    return false;
                }
                return t instanceof SqlCompositeElementType || t instanceof IStubElementType || t instanceof SqlFileElementType;
            }
        };
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/script/SqlReaderImpl", "sqlTypesCondition"));
        }
        return condition;
    }
}

