/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.css.rename;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.css.CssFile;
import com.intellij.psi.css.CssIdSelector;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.refactoring.rename.naming.AutomaticRenamerFactory;
import com.intellij.usageView.UsageInfo;
import java.util.Collection;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.css.refs.JavaFxCSSReferenceContributor;
import org.jetbrains.plugins.javaFX.css.rename.JavaFxCssRefactoringsSettings;
import org.jetbrains.plugins.javaFX.fxml.JavaFxFileTypeFactory;
import org.jetbrains.plugins.javaFX.indexing.JavaFxControllerClassIndex;

public class JavaFxCssIdAutomaticRenamerFactory
implements AutomaticRenamerFactory {
    public boolean isApplicable(PsiElement element) {
        String qualifiedName;
        PsiField field;
        PsiClass containingClass;
        if (element instanceof PsiField && (containingClass = (field = (PsiField)element).getContainingClass()) != null && (qualifiedName = containingClass.getQualifiedName()) != null) {
            return !JavaFxControllerClassIndex.findFxmlWithController(containingClass.getProject(), qualifiedName).isEmpty();
        }
        if (element instanceof XmlAttributeValue && JavaFxFileTypeFactory.isFxml(element.getContainingFile())) {
            PsiElement parent = element.getParent();
            return parent instanceof XmlAttribute && "fx:id".equals(((XmlAttribute)parent).getName());
        }
        return false;
    }

    @Nullable
    public String getOptionName() {
        return "Rename id selector in css";
    }

    public boolean isEnabled() {
        return JavaFxCssRefactoringsSettings.getInstance().RENAME_ID_SELECTOR;
    }

    public void setEnabled(boolean enabled) {
        JavaFxCssRefactoringsSettings.getInstance().RENAME_ID_SELECTOR = enabled;
    }

    public AutomaticRenamer createRenamer(PsiElement element, String newName, Collection<UsageInfo> usages) {
        if (element instanceof XmlAttributeValue) {
            return new JavaFxCssIdAutomaticRenamer((XmlAttributeValue)element, newName);
        }
        return new JavaFxCssIdAutomaticRenamer((PsiField)element, newName);
    }

    private static class JavaFxCssIdAutomaticRenamer
    extends AutomaticRenamer {
        private static final Logger LOG = Logger.getInstance((String)("#" + JavaFxCssIdAutomaticRenamer.class.getName()));

        public JavaFxCssIdAutomaticRenamer(PsiField field, String newName) {
            String fieldName = field.getName();
            PsiClass containingClass = field.getContainingClass();
            LOG.assertTrue(containingClass != null);
            String qualifiedName = containingClass.getQualifiedName();
            LOG.assertTrue(qualifiedName != null);
            this.collectAllNames((PsiElement)field, newName, fieldName);
        }

        public JavaFxCssIdAutomaticRenamer(XmlAttributeValue element, String newName) {
            this.collectAllNames((PsiElement)element, newName, element.getValue());
        }

        private void collectAllNames(PsiElement element, String newName, String oldName) {
            Collection<VirtualFile> cssFiles = JavaFxCSSReferenceContributor.getMyCss(element);
            PsiManager psiManager = element.getManager();
            for (VirtualFile file : cssFiles) {
                PsiFile psiFile = psiManager.findFile(file);
                if (!(psiFile instanceof CssFile)) continue;
                CssStylesheet stylesheet = ((CssFile)psiFile).getStylesheet();
                Collection selectors = PsiTreeUtil.findChildrenOfType((PsiElement)stylesheet, CssIdSelector.class);
                for (CssIdSelector selector : selectors) {
                    if (!oldName.equals(selector.getName())) continue;
                    this.myElements.add(selector);
                }
            }
            this.suggestAllNames(oldName, newName);
        }

        public String getDialogTitle() {
            return "Rename JavaFX CSS Id Selectors";
        }

        public String getDialogDescription() {
            return "Rename css id selectors with the following names to:";
        }

        public String entityName() {
            return "CSS id selector";
        }
    }
}

