/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.psi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.psi.GherkinElementTypes;
import org.jetbrains.plugins.cucumber.psi.GherkinTokenTypes;

public class GherkinParser
implements PsiParser {
    @NotNull
    public ASTNode parse(IElementType root, PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        GherkinParser.parseFileTopLevel(builder);
        marker.done((IElementType)GherkinElementTypes.GHERKIN_FILE);
        ASTNode aSTNode = builder.getTreeBuilt();
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/psi/GherkinParser", "parse"));
        }
        return aSTNode;
    }

    private static void parseFileTopLevel(PsiBuilder builder) {
        while (!builder.eof()) {
            IElementType tokenType = builder.getTokenType();
            if (tokenType == GherkinTokenTypes.FEATURE_KEYWORD) {
                GherkinParser.parseFeature(builder);
                continue;
            }
            if (tokenType == GherkinTokenTypes.TAG) {
                GherkinParser.parseTags(builder);
                continue;
            }
            builder.advanceLexer();
        }
    }

    private static void parseFeature(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        assert (builder.getTokenType() == GherkinTokenTypes.FEATURE_KEYWORD);
        int featureEnd = builder.getCurrentOffset() + GherkinParser.getTokenLength(builder.getTokenText());
        PsiBuilder.Marker descMarker = null;
        do {
            IElementType tokenType;
            if ((tokenType = builder.getTokenType()) == GherkinTokenTypes.TEXT && descMarker == null && GherkinParser.hadLineBreakBefore(builder, featureEnd)) {
                descMarker = builder.mark();
            }
            if (tokenType == GherkinTokenTypes.SCENARIO_KEYWORD || tokenType == GherkinTokenTypes.BACKGROUND_KEYWORD || tokenType == GherkinTokenTypes.SCENARIO_OUTLINE_KEYWORD || tokenType == GherkinTokenTypes.TAG) {
                if (descMarker != null) {
                    descMarker.done(GherkinElementTypes.FEATURE_HEADER);
                    descMarker = null;
                }
                GherkinParser.parseFeatureElements(builder);
                if (builder.getTokenType() == GherkinTokenTypes.FEATURE_KEYWORD) break;
            }
            builder.advanceLexer();
        } while (!builder.eof());
        if (descMarker != null) {
            descMarker.done(GherkinElementTypes.FEATURE_HEADER);
        }
        marker.done(GherkinElementTypes.FEATURE);
    }

    private static boolean hadLineBreakBefore(PsiBuilder builder, int prevTokenEnd) {
        if (prevTokenEnd < 0) {
            return false;
        }
        String precedingText = builder.getOriginalText().subSequence(prevTokenEnd, builder.getCurrentOffset()).toString();
        return precedingText.contains("\n");
    }

    private static void parseTags(PsiBuilder builder) {
        while (builder.getTokenType() == GherkinTokenTypes.TAG) {
            PsiBuilder.Marker tagMarker = builder.mark();
            builder.advanceLexer();
            tagMarker.done(GherkinElementTypes.TAG);
        }
    }

    private static void parseFeatureElements(PsiBuilder builder) {
        while (builder.getTokenType() != GherkinTokenTypes.FEATURE_KEYWORD && !builder.eof()) {
            PsiBuilder.Marker marker = builder.mark();
            GherkinParser.parseTags(builder);
            IElementType startTokenType = builder.getTokenType();
            boolean outline = startTokenType == GherkinTokenTypes.SCENARIO_OUTLINE_KEYWORD;
            builder.advanceLexer();
            GherkinParser.parseScenario(builder, outline);
            marker.done(outline ? GherkinElementTypes.SCENARIO_OUTLINE : GherkinElementTypes.SCENARIO);
        }
    }

    private static void parseScenario(PsiBuilder builder, boolean outline) {
        while (!GherkinParser.atScenarioEnd(builder)) {
            if (builder.getTokenType() == GherkinTokenTypes.TAG) {
                PsiBuilder.Marker marker = builder.mark();
                builder.advanceLexer();
                if (GherkinParser.atScenarioEnd(builder)) {
                    marker.rollbackTo();
                    break;
                }
                marker.drop();
            }
            if (builder.getTokenType() == GherkinTokenTypes.STEP_KEYWORD) {
                GherkinParser.parseStep(builder);
                continue;
            }
            if (builder.getTokenType() == GherkinTokenTypes.EXAMPLES_KEYWORD && outline) {
                GherkinParser.parseExamplesBlock(builder);
                continue;
            }
            builder.advanceLexer();
        }
    }

    private static boolean atScenarioEnd(PsiBuilder builder) {
        int i = 0;
        while (builder.lookAhead(i) == GherkinTokenTypes.TAG) {
            ++i;
        }
        IElementType tokenType = builder.lookAhead(i);
        return tokenType == null || tokenType == GherkinTokenTypes.BACKGROUND_KEYWORD || tokenType == GherkinTokenTypes.SCENARIO_KEYWORD || tokenType == GherkinTokenTypes.SCENARIO_OUTLINE_KEYWORD || tokenType == GherkinTokenTypes.FEATURE_KEYWORD;
    }

    private static void parseStep(PsiBuilder builder) {
        IElementType tokenTypeAfterName;
        PsiBuilder.Marker marker = builder.mark();
        builder.advanceLexer();
        int prevTokenEnd = -1;
        while (builder.getTokenType() == GherkinTokenTypes.TEXT || builder.getTokenType() == GherkinTokenTypes.STEP_PARAMETER_BRACE || builder.getTokenType() == GherkinTokenTypes.STEP_PARAMETER_TEXT) {
            String tokenText = builder.getTokenText();
            if (GherkinParser.hadLineBreakBefore(builder, prevTokenEnd)) break;
            prevTokenEnd = builder.getCurrentOffset() + GherkinParser.getTokenLength(tokenText);
            if (builder.getTokenType() == GherkinTokenTypes.STEP_PARAMETER_TEXT) {
                PsiBuilder.Marker stepParameterMarker = builder.mark();
                builder.advanceLexer();
                stepParameterMarker.done(GherkinElementTypes.STEP_PARAMETER);
                continue;
            }
            builder.advanceLexer();
        }
        if ((tokenTypeAfterName = builder.getTokenType()) == GherkinTokenTypes.PIPE) {
            GherkinParser.parseTable(builder);
        } else if (tokenTypeAfterName == GherkinTokenTypes.PYSTRING) {
            GherkinParser.parsePystring(builder);
        }
        marker.done(GherkinElementTypes.STEP);
    }

    private static void parsePystring(PsiBuilder builder) {
        if (!builder.eof()) {
            PsiBuilder.Marker marker = builder.mark();
            builder.advanceLexer();
            while (!builder.eof() && builder.getTokenType() != GherkinTokenTypes.PYSTRING) {
                if (builder.getTokenType() == GherkinTokenTypes.STEP_PARAMETER_TEXT) {
                    PsiBuilder.Marker stepParameterMarker = builder.mark();
                    builder.advanceLexer();
                    stepParameterMarker.done(GherkinElementTypes.STEP_PARAMETER);
                    continue;
                }
                builder.advanceLexer();
            }
            if (!builder.eof()) {
                builder.advanceLexer();
            }
            marker.done(GherkinElementTypes.PYSTRING);
        }
    }

    private static void parseExamplesBlock(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        builder.advanceLexer();
        if (builder.getTokenType() == GherkinTokenTypes.COLON) {
            builder.advanceLexer();
        }
        while (builder.getTokenType() == GherkinTokenTypes.TEXT) {
            builder.advanceLexer();
        }
        if (builder.getTokenType() == GherkinTokenTypes.PIPE) {
            GherkinParser.parseTable(builder);
        }
        marker.done(GherkinElementTypes.EXAMPLES_BLOCK);
    }

    private static void parseTable(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        PsiBuilder.Marker rowMarker = builder.mark();
        int prevCellEnd = -1;
        boolean isHeaderRow = true;
        PsiBuilder.Marker cellMarker = null;
        IElementType prevToken = null;
        while (builder.getTokenType() == GherkinTokenTypes.PIPE || builder.getTokenType() == GherkinTokenTypes.TABLE_CELL) {
            IElementType tokenType = builder.getTokenType();
            boolean hasLineBreakBefore = GherkinParser.hadLineBreakBefore(builder, prevCellEnd);
            if (prevToken == GherkinTokenTypes.PIPE && !hasLineBreakBefore) {
                cellMarker = builder.mark();
            }
            if (tokenType == GherkinTokenTypes.PIPE && cellMarker != null) {
                GherkinParser.closeCell(cellMarker);
                cellMarker = null;
            }
            if (hasLineBreakBefore) {
                GherkinParser.closeRowMarker(rowMarker, isHeaderRow);
                isHeaderRow = false;
                rowMarker = builder.mark();
            }
            prevCellEnd = builder.getCurrentOffset() + GherkinParser.getTokenLength(builder.getTokenText());
            prevToken = tokenType;
            builder.advanceLexer();
        }
        if (cellMarker != null) {
            GherkinParser.closeCell(cellMarker);
        }
        GherkinParser.closeRowMarker(rowMarker, isHeaderRow);
        marker.done(GherkinElementTypes.TABLE);
    }

    private static void closeCell(PsiBuilder.Marker cellMarker) {
        cellMarker.done(GherkinElementTypes.TABLE_CELL);
    }

    private static void closeRowMarker(PsiBuilder.Marker rowMarker, boolean headerRow) {
        rowMarker.done(headerRow ? GherkinElementTypes.TABLE_HEADER_ROW : GherkinElementTypes.TABLE_ROW);
    }

    private static int getTokenLength(@Nullable String tokenText) {
        return tokenText != null ? tokenText.length() : 0;
    }
}

