/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.psi.annotator;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.psi.GherkinElementVisitor;
import org.jetbrains.plugins.cucumber.psi.GherkinExamplesBlock;
import org.jetbrains.plugins.cucumber.psi.GherkinHighlighter;
import org.jetbrains.plugins.cucumber.psi.GherkinPsiUtil;
import org.jetbrains.plugins.cucumber.psi.GherkinPystring;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;
import org.jetbrains.plugins.cucumber.psi.GherkinStepsHolder;
import org.jetbrains.plugins.cucumber.psi.GherkinTable;
import org.jetbrains.plugins.cucumber.psi.GherkinTableCell;
import org.jetbrains.plugins.cucumber.psi.GherkinTableRow;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinExamplesBlockImpl;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinExamplesNavigator;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinScenarioOutlineImpl;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinTableHeaderRowImpl;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinTableImpl;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinTableNavigator;
import org.jetbrains.plugins.cucumber.steps.AbstractStepDefinition;
import org.jetbrains.plugins.cucumber.steps.reference.CucumberStepReference;

public class GherkinAnnotatorVisitor
extends GherkinElementVisitor {
    private final AnnotationHolder myHolder;

    public GherkinAnnotatorVisitor(@NotNull AnnotationHolder holder) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/cucumber/psi/annotator/GherkinAnnotatorVisitor", "<init>"));
        }
        this.myHolder = holder;
    }

    private void highlight(PsiElement element, TextAttributesKey colorKey) {
        this.myHolder.createInfoAnnotation(element, null).setTextAttributes(colorKey);
    }

    private void highlight(PsiElement element, TextRange range, TextAttributesKey colorKey) {
        range = range.shiftRight(element.getTextOffset());
        this.myHolder.createInfoAnnotation(range, null).setTextAttributes(colorKey);
    }

    public void visitElement(PsiElement element) {
        ProgressManager.checkCanceled();
        super.visitElement(element);
    }

    @Override
    public void visitStep(GherkinStep step) {
        PsiReference[] references = step.getReferences();
        if (references.length != 1 || !(references[0] instanceof CucumberStepReference)) {
            return;
        }
        CucumberStepReference reference = (CucumberStepReference)references[0];
        AbstractStepDefinition definition = reference.resolveToDefinition();
        if (definition != null) {
            List<TextRange> parameterRanges = GherkinPsiUtil.buildParameterRanges(step, definition, reference.getRangeInElement().getStartOffset());
            if (parameterRanges == null) {
                return;
            }
            for (TextRange range : parameterRanges) {
                if (range.getLength() <= 0) continue;
                this.highlight(step, range, GherkinHighlighter.REGEXP_PARAMETER);
            }
            this.highlightOutlineParams(step, reference);
        }
    }

    @Override
    public void visitTableHeaderRow(GherkinTableHeaderRowImpl row) {
        GherkinExamplesBlockImpl examplesSection;
        super.visitTableRow(row);
        ProgressManager.checkCanceled();
        GherkinTableImpl table = GherkinTableNavigator.getTableByRow(row);
        GherkinExamplesBlockImpl gherkinExamplesBlockImpl = examplesSection = table != null ? GherkinExamplesNavigator.getExamplesByTable(table) : null;
        if (examplesSection == null) {
            return;
        }
        List<GherkinTableCell> cells = row.getPsiCells();
        for (PsiElement psiElement : cells) {
            this.highlight(psiElement, GherkinHighlighter.TABLE_HEADER_CELL);
        }
    }

    private void highlightOutlineParams(@NotNull GherkinStep step, @NotNull CucumberStepReference reference) {
        if (step == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "step", "org/jetbrains/plugins/cucumber/psi/annotator/GherkinAnnotatorVisitor", "highlightOutlineParams"));
        }
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/jetbrains/plugins/cucumber/psi/annotator/GherkinAnnotatorVisitor", "highlightOutlineParams"));
        }
        List<String> realSubstitutions = GherkinAnnotatorVisitor.getRealSubstitutions(step);
        if (realSubstitutions != null && !realSubstitutions.isEmpty()) {
            GherkinTable table;
            StringBuilder regexp = new StringBuilder();
            regexp.append("<(");
            for (String substitution : realSubstitutions) {
                if (regexp.length() > 2) {
                    regexp.append("|");
                }
                regexp.append(Pattern.quote(substitution));
            }
            regexp.append(")>");
            Pattern pattern = Pattern.compile(regexp.toString());
            int textStartOffset = reference.getRangeInElement().getStartOffset();
            this.highlightOutlineParamsForText(step.getStepName(), textStartOffset, pattern, step);
            GherkinPystring pystring = step.getPystring();
            if (pystring != null) {
                int textOffset = pystring.getTextOffset() - step.getTextOffset();
                this.highlightOutlineParamsForText(pystring.getText(), textOffset, pattern, step);
            }
            if ((table = step.getTable()) != null) {
                int textOffset = table.getTextOffset() - step.getTextOffset();
                this.highlightOutlineParamsForText(table.getText(), textOffset, pattern, step);
            }
        }
    }

    private void highlightOutlineParamsForText(String text, int textStartInElementOffset, Pattern pattern, GherkinStep step) {
        if (StringUtil.isEmpty((String)text)) {
            return;
        }
        Matcher matcher = pattern.matcher(text);
        boolean result = matcher.find();
        if (result) {
            do {
                String substitution;
                if (StringUtil.isEmpty((String)(substitution = matcher.group(1)))) continue;
                int start = matcher.start(1);
                int end = matcher.end(1);
                TextRange range = new TextRange(start, end).shiftRight(textStartInElementOffset);
                this.highlight(step, range, GherkinHighlighter.OUTLINE_PARAMETER_SUBSTITUTION);
            } while (result = matcher.find());
        }
    }

    @Nullable
    private static List<String> getRealSubstitutions(@NotNull GherkinStep step) {
        GherkinStepsHolder holder;
        if (step == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "step", "org/jetbrains/plugins/cucumber/psi/annotator/GherkinAnnotatorVisitor", "getRealSubstitutions"));
        }
        List<String> possibleSubstitutions = step.getParamsSubstitutions();
        if (!possibleSubstitutions.isEmpty() && (holder = step.getStepHolder()) instanceof GherkinScenarioOutlineImpl) {
            GherkinScenarioOutlineImpl outline = (GherkinScenarioOutlineImpl)holder;
            List<GherkinExamplesBlock> examplesBlocks = outline.getExamplesBlocks();
            if (examplesBlocks.isEmpty()) {
                return null;
            }
            GherkinTable table = examplesBlocks.get(0).getTable();
            if (table == null) {
                return null;
            }
            GherkinTableRow header = table.getHeaderRow();
            assert (header != null);
            List<GherkinTableCell> headerCells = header.getPsiCells();
            ArrayList<String> headers = new ArrayList<String>(headerCells.size() + 1);
            for (PsiElement psiElement : headerCells) {
                headers.add(psiElement.getText().trim());
            }
            ArrayList<String> realSubstitutions = new ArrayList<String>(possibleSubstitutions.size() + 1);
            for (String substitution : possibleSubstitutions) {
                if (!headers.contains(substitution)) continue;
                realSubstitutions.add(substitution);
            }
            return realSubstitutions.isEmpty() ? null : realSubstitutions;
        }
        return null;
    }
}

