/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCheckedRenameElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.psi.GherkinElementTypes;
import org.jetbrains.plugins.cucumber.psi.GherkinElementVisitor;
import org.jetbrains.plugins.cucumber.psi.GherkinExamplesBlock;
import org.jetbrains.plugins.cucumber.psi.GherkinPystring;
import org.jetbrains.plugins.cucumber.psi.GherkinScenarioOutline;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;
import org.jetbrains.plugins.cucumber.psi.GherkinStepsHolder;
import org.jetbrains.plugins.cucumber.psi.GherkinTable;
import org.jetbrains.plugins.cucumber.psi.GherkinTableCell;
import org.jetbrains.plugins.cucumber.psi.GherkinTableRow;
import org.jetbrains.plugins.cucumber.psi.GherkinTokenTypes;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinPsiElementBase;
import org.jetbrains.plugins.cucumber.psi.refactoring.GherkinChangeUtil;
import org.jetbrains.plugins.cucumber.steps.AbstractStepDefinition;
import org.jetbrains.plugins.cucumber.steps.reference.CucumberStepReference;

public class GherkinStepImpl
extends GherkinPsiElementBase
implements GherkinStep,
PsiCheckedRenameElement {
    private static final TokenSet TEXT_FILTER = TokenSet.create((IElementType[])new IElementType[]{GherkinTokenTypes.TEXT, GherkinElementTypes.STEP_PARAMETER, TokenType.WHITE_SPACE, GherkinTokenTypes.STEP_PARAMETER_TEXT, GherkinTokenTypes.STEP_PARAMETER_BRACE});
    private static final Pattern PARAMETER_SUBSTITUTION_PATTERN = Pattern.compile("<([^>\n\r]+)>");
    private final Object LOCK;
    private List<String> mySubstitutions;

    public GherkinStepImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/plugins/cucumber/psi/impl/GherkinStepImpl", "<init>"));
        }
        super(node);
        this.LOCK = new Object();
    }

    public String toString() {
        return "GherkinStep:" + this.getStepName();
    }

    @Override
    @Nullable
    public ASTNode getKeyword() {
        return this.getNode().findChildByType((IElementType)GherkinTokenTypes.STEP_KEYWORD);
    }

    @Override
    @Nullable
    public String getStepName() {
        return this.getElementText();
    }

    @Override
    @NotNull
    protected String getElementText() {
        ASTNode node = this.getNode();
        Object[] children = node.getChildren(TEXT_FILTER);
        String string = StringUtil.join((Object[])children, (Function)new Function<ASTNode, String>(){

            public String fun(ASTNode astNode) {
                return astNode.getText();
            }
        }, (String)"").trim();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/psi/impl/GherkinStepImpl", "getElementText"));
        }
        return string;
    }

    @Override
    @Nullable
    public GherkinPystring getPystring() {
        return (GherkinPystring)PsiTreeUtil.findChildOfType((PsiElement)this, GherkinPystring.class);
    }

    @Override
    @Nullable
    public GherkinTable getTable() {
        ASTNode tableNode = this.getNode().findChildByType(GherkinElementTypes.TABLE);
        return tableNode == null ? null : (GherkinTable)tableNode.getPsi();
    }

    @Override
    protected String getPresentableText() {
        ASTNode keywordNode = this.getKeyword();
        String prefix = keywordNode != null ? keywordNode.getText() + ": " : "Step: ";
        return prefix + this.getStepName();
    }

    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this, GherkinStepImpl.class);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/psi/impl/GherkinStepImpl", "getReferences"));
        }
        return psiReferenceArray;
    }

    @Override
    protected void acceptGherkin(GherkinElementVisitor gherkinElementVisitor) {
        gherkinElementVisitor.visitStep(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public List<String> getParamsSubstitutions() {
        Object object = this.LOCK;
        // MONITORENTER : object
        if (this.mySubstitutions == null) {
            GherkinTable table;
            String tableText;
            String pystringText;
            ArrayList<String> substitutions = new ArrayList<String>();
            String text = this.getStepName();
            if (StringUtil.isEmpty((String)text)) {
                List<String> list = Collections.emptyList();
                // MONITOREXIT : object
                if (list != null) return list;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/psi/impl/GherkinStepImpl", "getParamsSubstitutions"));
            }
            GherkinStepImpl.addSubstitutionFromText(text, substitutions);
            GherkinPystring pystring = this.getPystring();
            String string = pystringText = pystring != null ? pystring.getText() : null;
            if (!StringUtil.isEmpty((String)pystringText)) {
                GherkinStepImpl.addSubstitutionFromText(pystringText, substitutions);
            }
            String string2 = tableText = (table = this.getTable()) == null ? null : table.getText();
            if (tableText != null) {
                GherkinStepImpl.addSubstitutionFromText(tableText, substitutions);
            }
            this.mySubstitutions = substitutions.isEmpty() ? Collections.emptyList() : substitutions;
        }
        List<String> list = this.mySubstitutions;
        // MONITOREXIT : object
        if (list != null) return list;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/psi/impl/GherkinStepImpl", "getParamsSubstitutions"));
    }

    private static void addSubstitutionFromText(String text, ArrayList<String> substitutions) {
        Matcher matcher = PARAMETER_SUBSTITUTION_PATTERN.matcher(text);
        boolean result = matcher.find();
        if (!result) {
            return;
        }
        do {
            String substitution;
            if (StringUtil.isEmpty((String)(substitution = matcher.group(1))) || substitutions.contains(substitution)) continue;
            substitutions.add(substitution);
        } while (result = matcher.find());
    }

    public void subtreeChanged() {
        super.subtreeChanged();
        this.clearCaches();
    }

    @Override
    @Nullable
    public GherkinStepsHolder getStepHolder() {
        PsiElement parent = this.getParent();
        return parent != null ? (GherkinStepsHolder)parent : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCaches() {
        Object object = this.LOCK;
        synchronized (object) {
            this.mySubstitutions = null;
        }
    }

    @Override
    @Nullable
    public String getSubstitutedName() {
        ArrayList<String> sustitutedNameList = new ArrayList<String>(this.getSubstitutedNameList(1));
        return sustitutedNameList.size() > 0 ? (String)sustitutedNameList.get(0) : this.getStepName();
    }

    public Set<String> getSubstitutedNameList(int maxCount) {
        HashSet result = new HashSet();
        GherkinStepsHolder holder = this.getStepHolder();
        String stepName = this.getStepName();
        if (stepName != null && holder instanceof GherkinScenarioOutline) {
            GherkinScenarioOutline outline = (GherkinScenarioOutline)holder;
            List<GherkinExamplesBlock> examplesBlocks = outline.getExamplesBlocks();
            for (GherkinExamplesBlock examplesBlock : examplesBlocks) {
                GherkinTable table = examplesBlock.getTable();
                if (table == null) continue;
                List<GherkinTableRow> rows = table.getDataRows();
                for (GherkinTableRow row : rows) {
                    result.add(GherkinStepImpl.substituteText(stepName, table.getHeaderRow(), row));
                    if (result.size() != maxCount) continue;
                    return result;
                }
            }
        }
        if (result.size() == 0 && stepName != null) {
            result.add(stepName);
        }
        return result;
    }

    @Override
    @NotNull
    public Set<String> getSubstitutedNameList() {
        Set<String> set = this.getSubstitutedNameList(Integer.MAX_VALUE);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/psi/impl/GherkinStepImpl", "getSubstitutedNameList"));
        }
        return set;
    }

    private static String substituteText(String stepName, GherkinTableRow headerRow, GherkinTableRow row) {
        List<GherkinTableCell> headerCells = headerRow.getPsiCells();
        List<GherkinTableCell> dataCells = row.getPsiCells();
        int headerCellsNumber = headerCells.size();
        int dataCellsNumber = dataCells.size();
        for (int i = 0; i < headerCellsNumber && i < dataCellsNumber; ++i) {
            String cellText = headerCells.get(i).getText().trim();
            stepName = stepName.replace("<" + cellText + ">", dataCells.get(i).getText().trim());
        }
        return stepName;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/cucumber/psi/impl/GherkinStepImpl", "setName"));
        }
        GherkinStep newStep = GherkinChangeUtil.createStep(this.getKeyword().getText() + " " + name, this.getProject());
        this.replace(newStep);
        return newStep;
    }

    public String getName() {
        ASTNode keyword = this.getKeyword();
        int keywordLength = keyword != null ? keyword.getTextLength() : 0;
        return this.getText().substring(keywordLength).trim();
    }

    @Override
    @NotNull
    public Collection<AbstractStepDefinition> findDefinitions() {
        ArrayList<AbstractStepDefinition> result = new ArrayList<AbstractStepDefinition>();
        for (PsiReference reference : this.getReferences()) {
            if (!(reference instanceof CucumberStepReference)) continue;
            result.addAll(((CucumberStepReference)reference).resolveToDefinitions());
        }
        ArrayList<AbstractStepDefinition> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/psi/impl/GherkinStepImpl", "findDefinitions"));
        }
        return arrayList;
    }

    @Override
    public boolean isRenameAllowed(@Nullable String newName) {
        Collection<AbstractStepDefinition> definitions = this.findDefinitions();
        if (definitions.isEmpty()) {
            return false;
        }
        for (AbstractStepDefinition definition : definitions) {
            if (definition.supportsRename(newName)) continue;
            return false;
        }
        return true;
    }

    public void checkSetName(String name) {
        if (!this.isRenameAllowed(name)) {
            throw new IncorrectOperationException(RENAME_BAD_SYMBOLS_MESSAGE);
        }
    }
}

