/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.model.xml.web.converters;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.javaee.model.xml.web.HttpStatusCode;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpStatusCodeConverter
extends ResolvingConverter<HttpStatusCode> {
    private static final Pattern HTTP_STATUS_CODE = Pattern.compile("\\d{3}");
    private final Set<HttpStatusCode> myAllowedStatusCodes;
    private final boolean myCustomCodeAllowed;

    public HttpStatusCodeConverter() {
        this(EnumSet.allOf(HttpStatusCode.class), true);
    }

    public HttpStatusCodeConverter(Set<HttpStatusCode> allowedStatusCodes, boolean customCodeAllowed) {
        this.myAllowedStatusCodes = allowedStatusCodes;
        this.myAllowedStatusCodes.remove((Object)HttpStatusCode.CUSTOM);
        this.myCustomCodeAllowed = customCodeAllowed;
    }

    public final HttpStatusCode fromString(String s, ConvertContext context) {
        return this.findHttpStatusCode(s);
    }

    @Nullable
    private HttpStatusCode findHttpStatusCode(final @Nullable String s) {
        if (s == null) {
            return null;
        }
        HttpStatusCode value = (HttpStatusCode)((Object)ContainerUtil.find(this.myAllowedStatusCodes, (Condition)new Condition<HttpStatusCode>(){

            public boolean value(HttpStatusCode code) {
                return code.getValue().equals(s);
            }
        }));
        if (value != null) {
            return value;
        }
        if (!this.myCustomCodeAllowed) {
            return null;
        }
        return HTTP_STATUS_CODE.matcher(s).matches() ? HttpStatusCode.CUSTOM : null;
    }

    public final String toString(HttpStatusCode statusCode, ConvertContext context) {
        return statusCode == null ? null : statusCode.getValue();
    }

    @NotNull
    public Collection<HttpStatusCode> getVariants(ConvertContext context) {
        Set<HttpStatusCode> set = this.myAllowedStatusCodes;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/xml/web/converters/HttpStatusCodeConverter", "getVariants"));
        }
        return set;
    }

    public String getErrorMessage(@Nullable String s, ConvertContext context) {
        if (s == null || !HTTP_STATUS_CODE.matcher(s).matches()) {
            return "Invalid HTTP status code '" + s + "'";
        }
        return "HTTP status code '" + s + "' not allowed here";
    }

    @Nullable
    public LookupElement createLookupElement(HttpStatusCode statusCode) {
        return LookupElementBuilder.create((String)statusCode.getValue()).withStrikeoutness(statusCode.isDeprecated()).withTailText(" (" + statusCode.getReason() + ")", true);
    }
}

