/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.facet;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.facet.Facet;
import com.intellij.facet.ui.FacetBasedFrameworkSupportProvider;
import com.intellij.framework.library.DownloadableLibraryService;
import com.intellij.framework.library.FrameworkSupportWithLibrary;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportConfigurableBase;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportProviderBase;
import com.intellij.ide.util.frameworkSupport.FrameworkVersion;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.javaee.model.xml.web.Filter;
import com.intellij.javaee.model.xml.web.FilterMapping;
import com.intellij.javaee.model.xml.web.WebApp;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.struts2.StrutsFileTemplateProvider;
import com.intellij.struts2.facet.Struts2LibraryType;
import com.intellij.struts2.facet.StrutsFacet;
import com.intellij.struts2.facet.StrutsFacetConfiguration;
import com.intellij.struts2.facet.StrutsFacetType;
import com.intellij.struts2.facet.ui.StrutsConfigsSearcher;
import com.intellij.struts2.facet.ui.StrutsFileSet;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.ui.UIUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StrutsFrameworkSupportProvider
extends FacetBasedFrameworkSupportProvider<StrutsFacet> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.struts2.facet.StrutsFrameworkSupportProvider");

    public StrutsFrameworkSupportProvider() {
        super(StrutsFacetType.getInstance());
    }

    public String getTitle() {
        return UIUtil.replaceMnemonicAmpersand((String)"Struts &2");
    }

    @NotNull
    public FrameworkSupportConfigurableBase createConfigurable(@NotNull FrameworkSupportModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/struts2/facet/StrutsFrameworkSupportProvider", "createConfigurable"));
        }
        Struts2FrameworkSupportConfigurable struts2FrameworkSupportConfigurable = new Struts2FrameworkSupportConfigurable((FrameworkSupportProviderBase)this, model, this.getVersions(), this.getVersionLabelText());
        if (struts2FrameworkSupportConfigurable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/facet/StrutsFrameworkSupportProvider", "createConfigurable"));
        }
        return struts2FrameworkSupportConfigurable;
    }

    protected void setupConfiguration(StrutsFacet strutsFacet, ModifiableRootModel modifiableRootModel, FrameworkVersion version) {
    }

    protected void onFacetCreated(final StrutsFacet strutsFacet, final ModifiableRootModel modifiableRootModel, FrameworkVersion version) {
        final Module module = strutsFacet.getModule();
        StartupManager.getInstance((Project)module.getProject()).runWhenProjectIsInitialized(new Runnable(){

            @Override
            public void run() {
                DumbService.getInstance((Project)module.getProject()).runWhenSmart(new Runnable(){

                    @Override
                    public void run() {
                        VirtualFile[] sourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots();
                        if (sourceRoots.length <= 0) {
                            return;
                        }
                        PsiDirectory directory = PsiManager.getInstance((Project)module.getProject()).findDirectory(sourceRoots[0]);
                        if (directory == null || directory.findFile("struts.xml") != null) {
                            return;
                        }
                        final StrutsFileTemplateProvider templateProvider = new StrutsFileTemplateProvider(module);
                        FileTemplate strutsXmlTemplate = templateProvider.determineFileTemplate(directory.getProject());
                        try {
                            StrutsFacetConfiguration strutsFacetConfiguration = (StrutsFacetConfiguration)strutsFacet.getConfiguration();
                            PsiElement psiElement = FileTemplateUtil.createFromTemplate((FileTemplate)strutsXmlTemplate, (String)"struts.xml", null, (PsiDirectory)directory);
                            Set<StrutsFileSet> empty = Collections.emptySet();
                            StrutsFileSet fileSet = new StrutsFileSet(StrutsFileSet.getUniqueId(empty), StrutsFileSet.getUniqueName("Default File Set", empty), strutsFacetConfiguration);
                            fileSet.addFile(((XmlFile)psiElement).getVirtualFile());
                            StrutsConfigsSearcher searcher = new StrutsConfigsSearcher(module);
                            searcher.search();
                            MultiMap jarConfigFiles = searcher.getJars();
                            for (VirtualFile virtualFile : jarConfigFiles.keySet()) {
                                Collection psiFiles = jarConfigFiles.get((Object)virtualFile);
                                for (PsiFile psiFile : psiFiles) {
                                    fileSet.addFile(psiFile.getVirtualFile());
                                }
                            }
                            strutsFacetConfiguration.getFileSets().add(fileSet);
                            new WriteCommandAction.Simple(modifiableRootModel.getProject(), new PsiFile[0]){

                                protected void run() throws Throwable {
                                    WebFacet webFacet = strutsFacet.getWebFacet();
                                    ConfigFile configFile = webFacet.getWebXmlDescriptor();
                                    if (configFile == null) {
                                        return;
                                    }
                                    XmlFile webXmlFile = configFile.getXmlFile();
                                    WebApp webApp = (WebApp)JamCommonUtil.getRootElement((PsiFile)webXmlFile, WebApp.class, null);
                                    if (webApp == null) {
                                        return;
                                    }
                                    if (!FileModificationService.getInstance().prepareFileForWrite((PsiFile)webXmlFile)) {
                                        return;
                                    }
                                    Filter strutsFilter = webApp.addFilter();
                                    strutsFilter.getFilterName().setStringValue("struts2");
                                    String filterClass = templateProvider.is21orNewer() ? "org.apache.struts2.dispatcher.ng.filter.StrutsPrepareAndExecuteFilter" : "org.apache.struts2.dispatcher.FilterDispatcher";
                                    strutsFilter.getFilterClass().setStringValue(filterClass);
                                    FilterMapping filterMapping = webApp.addFilterMapping();
                                    filterMapping.getFilterName().setValue((Object)strutsFilter);
                                    filterMapping.addUrlPattern().setStringValue("/*");
                                }
                            }.execute();
                            NotificationListener showFacetSettingsListener = new NotificationListener(){

                                public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                                    if (notification == null) {
                                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/struts2/facet/StrutsFrameworkSupportProvider$1$1$2", "hyperlinkUpdate"));
                                    }
                                    if (event == null) {
                                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/struts2/facet/StrutsFrameworkSupportProvider$1$1$2", "hyperlinkUpdate"));
                                    }
                                    if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                                        notification.expire();
                                        ModulesConfigurator.showFacetSettingsDialog((Facet)strutsFacet, null);
                                    }
                                }
                            };
                            Notifications.Bus.notify((Notification)new Notification("Struts 2", "Struts 2 Setup", "Struts 2 Facet has been created, please check <a href=\"more\">created fileset</a>", NotificationType.INFORMATION, showFacetSettingsListener), (Project)module.getProject());
                        }
                        catch (Exception e) {
                            LOG.error("error creating struts.xml from template", (Throwable)e);
                        }
                    }
                });
            }
        });
    }

    private static class Struts2FrameworkSupportConfigurable
    extends FrameworkSupportConfigurableBase
    implements FrameworkSupportWithLibrary {
        private Struts2FrameworkSupportConfigurable(FrameworkSupportProviderBase frameworkSupportProvider, FrameworkSupportModel model, @NotNull List<FrameworkVersion> versions, @Nullable String versionLabelText) {
            if (versions == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versions", "com/intellij/struts2/facet/StrutsFrameworkSupportProvider$Struts2FrameworkSupportConfigurable", "<init>"));
            }
            super(frameworkSupportProvider, model, versions, versionLabelText);
        }

        @NotNull
        public CustomLibraryDescription createLibraryDescription() {
            CustomLibraryDescription customLibraryDescription = DownloadableLibraryService.getInstance().createDescriptionForType(Struts2LibraryType.class);
            if (customLibraryDescription == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/facet/StrutsFrameworkSupportProvider$Struts2FrameworkSupportConfigurable", "createLibraryDescription"));
            }
            return customLibraryDescription;
        }

        public boolean isLibraryOnly() {
            return false;
        }
    }
}

