/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.facet.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.struts2.facet.StrutsFacetConfiguration;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StrutsFileSet
implements Disposable {
    private final String id;
    private String name;
    private boolean autodetected;
    private boolean removed;
    private final List<VirtualFilePointer> files;
    @NonNls
    private static final String ID_PREFIX = "s2fileset";
    private static final Function<StrutsFileSet, String> FILESET_NAME_FUNCTION = new Function<StrutsFileSet, String>(){

        public String fun(StrutsFileSet strutsFileSet) {
            return strutsFileSet.getName();
        }
    };
    private static final Function<StrutsFileSet, String> FILESET_ID_FUNCTION = new Function<StrutsFileSet, String>(){

        public String fun(StrutsFileSet strutsFileSet) {
            return strutsFileSet.getId();
        }
    };

    public StrutsFileSet(@NotNull @NonNls String id, @NotNull @NonNls String name, @NotNull StrutsFacetConfiguration parent) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/struts2/facet/ui/StrutsFileSet", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/struts2/facet/ui/StrutsFileSet", "<init>"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/struts2/facet/ui/StrutsFileSet", "<init>"));
        }
        this.files = new SmartList();
        this.id = id;
        this.name = name;
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    public StrutsFileSet(@NotNull StrutsFileSet original) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/struts2/facet/ui/StrutsFileSet", "<init>"));
        }
        this.files = new SmartList();
        this.id = original.id;
        this.name = original.name;
        this.files.addAll(original.files);
        this.autodetected = original.autodetected;
        this.removed = original.removed;
    }

    public static String getUniqueId(Set<StrutsFileSet> list) {
        return UniqueNameGenerator.generateUniqueName((String)ID_PREFIX, (Collection)ContainerUtil.map2List(list, FILESET_ID_FUNCTION));
    }

    public static String getUniqueName(String prefix, Set<StrutsFileSet> list) {
        return UniqueNameGenerator.generateUniqueName((String)(prefix + " "), (Collection)ContainerUtil.map2List(list, FILESET_NAME_FUNCTION));
    }

    public boolean isNew() {
        return false;
    }

    @NotNull
    public String getId() {
        String string = this.id;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/facet/ui/StrutsFileSet", "getId"));
        }
        return string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/struts2/facet/ui/StrutsFileSet", "setName"));
        }
        this.name = name;
    }

    public boolean isAutodetected() {
        return this.autodetected;
    }

    public void setAutodetected(boolean autodetected) {
        this.autodetected = autodetected;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public void setRemoved(boolean removed) {
        this.removed = removed;
    }

    @NotNull
    public List<VirtualFilePointer> getFiles() {
        List<VirtualFilePointer> list = this.files;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/facet/ui/StrutsFileSet", "getFiles"));
        }
        return list;
    }

    public void addFile(VirtualFile file) {
        this.addFile(file.getUrl());
    }

    public void addFile(@NonNls String url) {
        if (!StringUtil.isEmptyOrSpaces((String)url)) {
            VirtualFilePointer filePointer = VirtualFilePointerManager.getInstance().create(url, (Disposable)this, null);
            this.files.add(filePointer);
        }
    }

    public void removeFile(VirtualFilePointer file) {
        this.files.remove(file);
    }

    public boolean hasFile(@Nullable VirtualFile file) {
        if (file == null) {
            return false;
        }
        for (VirtualFilePointer pointer : this.files) {
            VirtualFile virtualFile = pointer.getFile();
            if (virtualFile == null || !file.equals(virtualFile)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object another) {
        if (another instanceof StrutsFileSet) {
            StrutsFileSet obj = (StrutsFileSet)another;
            return Comparing.equal((String)obj.getId(), (String)this.id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.name;
    }

    public void dispose() {
    }
}

