/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.gotosymbol;

import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.struts2.StrutsIcons;
import com.intellij.struts2.dom.struts.model.StrutsManager;
import com.intellij.struts2.dom.struts.model.StrutsModel;
import com.intellij.struts2.dom.struts.strutspackage.StrutsPackage;
import com.intellij.struts2.facet.StrutsFacet;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.model.gotosymbol.GoToSymbolProvider;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class GoToPackageSymbolProvider
extends GoToSymbolProvider {
    private static final Function<StrutsPackage, String> STRUTS_PACKAGE_NAME_FUNCTION = new NullableFunction<StrutsPackage, String>(){

        public String fun(StrutsPackage strutsPackage) {
            return strutsPackage.getName().getStringValue();
        }
    };

    protected boolean acceptModule(Module module) {
        return StrutsFacet.getInstance(module) != null;
    }

    protected void addNames(@NotNull Module module, Set<String> result) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/struts2/gotosymbol/GoToPackageSymbolProvider", "addNames"));
        }
        StrutsModel strutsModel = StrutsManager.getInstance(module.getProject()).getCombinedModel(module);
        if (strutsModel == null) {
            return;
        }
        Set packageNames = ContainerUtil.map2Set(strutsModel.getStrutsPackages(), STRUTS_PACKAGE_NAME_FUNCTION);
        result.addAll(packageNames);
    }

    protected void addItems(@NotNull Module module, String name, List<NavigationItem> result) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/struts2/gotosymbol/GoToPackageSymbolProvider", "addItems"));
        }
        StrutsModel strutsModel = StrutsManager.getInstance(module.getProject()).getCombinedModel(module);
        if (strutsModel == null) {
            return;
        }
        List<StrutsPackage> strutsPackageList = strutsModel.getStrutsPackages();
        for (StrutsPackage strutsPackage : strutsPackageList) {
            if (!Comparing.strEqual((String)name, (String)strutsPackage.getName().getStringValue())) continue;
            NavigationItem item = GoToPackageSymbolProvider.createNavigationItem((PsiElement)strutsPackage.getXmlTag(), (String)name, (Icon)StrutsIcons.STRUTS_PACKAGE);
            result.add(item);
        }
    }
}

