/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.gotosymbol;

import com.intellij.codeInsight.navigation.DomGotoRelatedItem;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.GotoRelatedProvider;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.struts2.dom.struts.action.Action;
import com.intellij.struts2.dom.struts.action.Result;
import com.intellij.struts2.dom.struts.model.StrutsManager;
import com.intellij.struts2.dom.struts.model.StrutsModel;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class GotoRelatedActionProvider
extends GotoRelatedProvider {
    private static final Set<String> SUPPORTED_EXTENSIONS = ContainerUtil.newTroveSet((TObjectHashingStrategy)FileUtil.PATH_HASHING_STRATEGY, (Object[])new String[]{"ftl", "htm", "html", "jsp", "jspx", "txt", "vm"});

    @NotNull
    public List<? extends GotoRelatedItem> getItems(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/struts2/gotosymbol/GotoRelatedActionProvider", "getItems"));
        }
        PsiFile psiFile = psiElement.getContainingFile();
        if (psiFile == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/gotosymbol/GotoRelatedActionProvider", "getItems"));
            }
            return list;
        }
        PsiFile containingFile = psiFile.getOriginalFile();
        final String filename = containingFile.getName();
        String extension = FileUtilRt.getExtension((String)filename);
        if (!SUPPORTED_EXTENSIONS.contains(extension)) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/gotosymbol/GotoRelatedActionProvider", "getItems"));
            }
            return list;
        }
        StrutsManager strutsManager = StrutsManager.getInstance(psiElement.getProject());
        StrutsModel strutsModel = strutsManager.getCombinedModel(psiElement);
        if (strutsModel == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/gotosymbol/GotoRelatedActionProvider", "getItems"));
            }
            return list;
        }
        final List allFiles = containingFile.getViewProvider().getAllFiles();
        final HashSet actions = new HashSet();
        final ArrayList items = new ArrayList();
        strutsModel.processActions(new Processor<Action>(){

            public boolean process(Action action) {
                for (Result result : action.getResults()) {
                    PsiClass actionClass;
                    PsiElement resolve;
                    String path;
                    PathReference pathReference = (PathReference)result.getValue();
                    if (pathReference == null || !(path = pathReference.getPath()).endsWith(filename) || ContainerUtil.find((Iterable)allFiles, (Object)(resolve = pathReference.resolve())) == null) continue;
                    if (!actions.contains(action)) {
                        items.add(new DomGotoRelatedItem((DomElement)action));
                        actions.add(action);
                    }
                    if ((actionClass = action.searchActionClass()) == null) continue;
                    PsiMethod actionMethod = action.searchActionMethod();
                    items.add(new GotoRelatedItem((PsiElement)(actionMethod != null ? actionMethod : actionClass)));
                }
                return true;
            }
        });
        ArrayList arrayList = items;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/gotosymbol/GotoRelatedActionProvider", "getItems"));
        }
        return arrayList;
    }
}

