/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.osgi.model.converters;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.osgi.model.converters.BasicListenerMethodConverter;
import com.intellij.spring.osgi.model.xml.Service;
import com.intellij.util.xml.ConvertContext;
import org.jetbrains.annotations.Nullable;

public class RegistrationListenerMethodConverter
extends BasicListenerMethodConverter {
    @Override
    protected boolean checkParameterList(PsiMethod method, ConvertContext context) {
        Project project = method.getProject();
        PsiParameter[] parameters = method.getParameterList().getParameters();
        if (parameters.length == 2) {
            PsiType type2 = parameters[1].getType();
            return RegistrationListenerMethodConverter.checkServiceTypeParameter(context, parameters[0].getType()) && (RegistrationListenerMethodConverter.checkType(type2, "java.util.Map", project) || RegistrationListenerMethodConverter.checkType(type2, "java.util.Dictionary", project));
        }
        return false;
    }

    private static boolean checkServiceTypeParameter(ConvertContext context, PsiType type) {
        PsiClass beanClass;
        Service service = (Service)context.getInvocationElement().getParentOfType(Service.class, false);
        if (service != null && type != null && (beanClass = RegistrationListenerMethodConverter.getServiceBeanClass(service)) != null) {
            return type.isAssignableFrom((PsiType)PsiTypesUtil.getClassType((PsiClass)beanClass));
        }
        return true;
    }

    @Nullable
    private static PsiClass getServiceBeanClass(Service service) {
        SpringBeanPointer value = (SpringBeanPointer)service.getRef().getValue();
        if (value != null) {
            return value.getBeanClass();
        }
        return service.getBean().getBeanClass();
    }
}

