/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.persistence.integration;

import com.intellij.hibernate.facet.HibernateFacet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.persistence.extensions.PersistencePackagesProvider;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.persistence.integration.IntegrationUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SpringSessionFactoryProvider
implements PersistencePackagesProvider {
    private static final Key<CachedValue<List<PersistencePackage>>> SPRING_SESSION_FACTORIES_KEY = Key.create((String)"SPRING_SESSION_FACTORIES_KEY");

    @NotNull
    public List<PersistencePackage> getPersistencePackages(final PersistenceFacet facet) {
        final Module module = facet.getModule();
        if (!(facet instanceof HibernateFacet) || !module.isLoaded() || module.isDisposed() || DumbService.isDumb((Project)module.getProject())) {
            List<PersistencePackage> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/persistence/integration/SpringSessionFactoryProvider", "getPersistencePackages"));
            }
            return list;
        }
        final Project project = module.getProject();
        List list = (List)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)module, SPRING_SESSION_FACTORIES_KEY, (CachedValueProvider)new CachedValueProvider<List<PersistencePackage>>(){

            public CachedValueProvider.Result<List<PersistencePackage>> compute() {
                HashSet result = new HashSet();
                SpringManager springManager = SpringManager.getInstance((Project)project);
                SpringModel springModel = springManager.getCombinedModel(module);
                GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
                PsiClass sessionFactoryClass = JavaPsiFacade.getInstance((Project)project).findClass("org.hibernate.SessionFactory", scope);
                if (sessionFactoryClass != null) {
                    SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass((PsiClass)sessionFactoryClass).withInheritors().effectiveBeanTypes();
                    for (SpringBeanPointer bean : SpringModelSearchers.findBeans((CommonSpringModel)springModel, (SpringModelSearchParameters.BeanClass)searchParameters)) {
                        Function provider = (Function)IntegrationUtil.getProvider(bean, IntegrationUtil.myProviders, true);
                        if (provider == null) continue;
                        PersistencePackage unit = (PersistencePackage)provider.fun((Object)Pair.create((Object)bean, (Object)facet));
                        if (bean.isAbstract()) continue;
                        result.add(unit);
                    }
                }
                ArrayList factories = new ArrayList(result);
                HashSet dependencies = new HashSet();
                dependencies.addAll(ContainerUtil.newArrayList((Object[])SpringModificationTrackersManager.getInstance((Project)project).getOuterModelsDependencies()));
                dependencies.addAll(springModel.getConfigFiles());
                return CachedValueProvider.Result.create(factories, (Object[])springManager.getModelsDependencies(module, ArrayUtil.toObjectArray((Collection)dependencies)));
            }
        }, false);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/persistence/integration/SpringSessionFactoryProvider", "getPersistencePackages"));
        }
        return list;
    }
}

