/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.glassfish.server;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.javaee.oss.glassfish.server.GlassfishDebugConfig;
import com.intellij.javaee.oss.glassfish.server.GlassfishExecutableWrapperBase;
import com.intellij.javaee.oss.glassfish.server.GlassfishLocalModel;
import com.intellij.javaee.run.localRun.ExecutableObject;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;

public class GlassfishStartupExecutableWrapper
extends GlassfishExecutableWrapperBase {
    @NonNls
    private static final String JVM_OPTIONS_ELEMENT = "jvm-options";
    @NonNls
    private static final String JAVA_HOME_ATTR = "java-home";
    @NonNls
    private static final String JVM_OPTION_SPLITTER = "=";
    private static final MemoryOption[] ourMemoryOptions = new MemoryOption[]{new MemoryOption("mx"), new MemoryOption("ms"), new MemoryOption("mn"), new MemoryOption("ss")};

    public GlassfishStartupExecutableWrapper(ExecutableObject wrapped, GlassfishLocalModel serverModel) {
        super(wrapped, serverModel);
    }

    @Override
    public OSProcessHandler createProcessHandler(String workingDirectory, final Map<String, String> envVariables) throws ExecutionException {
        new GlassfishExecutableWrapperBase.GlassfishJavaConfigProcessorBase(){

            @Override
            protected void doProcessJavaConfig(File file, Document doc, Element serverConfig, Element javaConfig, Ref<Boolean> save) throws IOException, JDOMException {
                OptionsModifier defaultOptionsModifier;
                String jrePath = GlassfishStartupExecutableWrapper.this.getServerModel().getJrePath();
                if (jrePath != null) {
                    javaConfig.setAttribute(GlassfishStartupExecutableWrapper.JAVA_HOME_ATTR, jrePath);
                    save.set((Object)true);
                }
                Map<String, String> ideaOptionsMap = new OptionsParser(){

                    @Override
                    protected void iterateOptions() {
                        String ideaOptionsEnvVar = (String)envVariables.get("JAVA_OPTS");
                        if (ideaOptionsEnvVar == null) {
                            return;
                        }
                        for (String ideaOption : ideaOptionsEnvVar.split("\\s+")) {
                            if (GlassfishDebugConfig.isDebugParameter(ideaOption)) continue;
                            this.addOption(ideaOption);
                        }
                    }
                }.parse();
                GlassfishExecutableWrapperBase.DefaultOptionsReader defaultOptionsReader = new GlassfishExecutableWrapperBase.DefaultOptionsReader(file);
                if (defaultOptionsReader.isExists() && !(defaultOptionsModifier = new OptionsModifier(defaultOptionsReader.getElement(), ideaOptionsMap)).isModified()) {
                    defaultOptionsReader.resetContent(javaConfig);
                    save.set((Object)true);
                    return;
                }
                OptionsModifier currentOptionsModifier = new OptionsModifier(javaConfig, ideaOptionsMap);
                if (currentOptionsModifier.isModified()) {
                    if (!defaultOptionsReader.isExists()) {
                        Document defaultOptionsDoc = new Document(javaConfig.clone());
                        JDOMUtil.writeDocument((Document)defaultOptionsDoc, (File)defaultOptionsReader.getFile(), (String)"\n");
                    }
                    javaConfig.removeContent();
                    for (Map.Entry<String, String> currentOptionName2Value : currentOptionsModifier.getOptionsMap().entrySet()) {
                        boolean isMemoryOption;
                        Element currentOption = new Element(GlassfishStartupExecutableWrapper.JVM_OPTIONS_ELEMENT);
                        final StringBuilder currentOptionBuilder = new StringBuilder();
                        final String currentOptionName = currentOptionName2Value.getKey();
                        final String currentOptionValue = currentOptionName2Value.getValue();
                        currentOptionBuilder.append(currentOptionName);
                        boolean bl = isMemoryOption = !ContainerUtil.process((Object[])ourMemoryOptions, (Processor)new Processor<MemoryOption>(){

                            public boolean process(MemoryOption memoryOption) {
                                if (memoryOption.getFullName().equals(currentOptionName)) {
                                    currentOptionBuilder.append(currentOptionValue);
                                    return false;
                                }
                                return true;
                            }
                        });
                        if (!isMemoryOption && currentOptionValue != null) {
                            currentOptionBuilder.append(GlassfishStartupExecutableWrapper.JVM_OPTION_SPLITTER);
                            currentOptionBuilder.append(currentOptionValue);
                        }
                        currentOption.setText(currentOptionBuilder.toString());
                        javaConfig.addContent(currentOption);
                    }
                    save.set((Object)true);
                }
            }
        }.processConfig();
        return super.createProcessHandler(workingDirectory, envVariables);
    }

    private static class MemoryOption {
        private final String myFullName;
        private final Pattern myPattern;

        public MemoryOption(@NonNls String name) {
            this.myFullName = "-X" + name;
            this.myPattern = Pattern.compile(Pattern.quote(this.myFullName) + "(\\d+\\D*)");
        }

        public String getValue(String option) {
            Matcher matcher = this.myPattern.matcher(option);
            return matcher.matches() ? matcher.group(1) : null;
        }

        public String getFullName() {
            return this.myFullName;
        }
    }

    private static class OptionsModifier {
        private final Map<String, String> myOptionsMap;
        private final boolean myModified;

        public OptionsModifier(final Element optionsElement, Map<String, String> ideaOptionsMap) {
            this.myOptionsMap = new OptionsParser(){

                @Override
                protected void iterateOptions() {
                    for (Object jvmOption : optionsElement.getChildren(GlassfishStartupExecutableWrapper.JVM_OPTIONS_ELEMENT)) {
                        if (!(jvmOption instanceof Element)) continue;
                        this.addOption(((Element)jvmOption).getText());
                    }
                }
            }.parse();
            boolean modified = false;
            for (Map.Entry<String, String> ideaOptionName2Value : ideaOptionsMap.entrySet()) {
                String ideaOptionName = ideaOptionName2Value.getKey();
                String ideaOptionValue = ideaOptionName2Value.getValue();
                if (this.myOptionsMap.containsKey(ideaOptionName) && StringUtil.notNullize((String)this.myOptionsMap.get(ideaOptionName)).equals(StringUtil.notNullize((String)ideaOptionValue))) continue;
                modified = true;
                this.myOptionsMap.put(ideaOptionName, ideaOptionValue);
            }
            this.myModified = modified;
        }

        public boolean isModified() {
            return this.myModified;
        }

        public Map<String, String> getOptionsMap() {
            return this.myOptionsMap;
        }
    }

    private static abstract class OptionsParser {
        private Map<String, String> myResult;

        private OptionsParser() {
        }

        public Map<String, String> parse() {
            this.myResult = new LinkedHashMap<String, String>();
            this.iterateOptions();
            return this.myResult;
        }

        protected final void addOption(final String option) {
            boolean isMemoryOption;
            boolean bl = isMemoryOption = !ContainerUtil.process((Object[])ourMemoryOptions, (Processor)new Processor<MemoryOption>(){

                public boolean process(MemoryOption memoryOption) {
                    String memoryParamValue = memoryOption.getValue(option);
                    if (memoryParamValue != null) {
                        myResult.put(memoryOption.getFullName(), memoryParamValue);
                        return false;
                    }
                    return true;
                }
            });
            if (isMemoryOption) {
                return;
            }
            String[] optionNameValue = option.split(GlassfishStartupExecutableWrapper.JVM_OPTION_SPLITTER, 2);
            this.myResult.put(optionNameValue[0], optionNameValue.length > 1 ? optionNameValue[1] : null);
        }

        protected abstract void iterateOptions();
    }
}

